/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.resolve;

import com.espertech.esper.common.client.serde.SerdeProvider;
import com.espertech.esper.common.client.serde.SerdeProviderAdditionalInfo;
import com.espertech.esper.common.client.serde.SerdeProviderContextClass;
import com.espertech.esper.common.client.serde.SerdeProvision;
import com.espertech.esper.common.client.serde.SerdeProvisionArrayOfNonPrimitive;
import com.espertech.esper.common.client.serde.SerdeProvisionByClass;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.serde.compiletime.resolve.DataInputOutputSerdeException;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOSerializableObjectSerde;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.Collection;

public class SerdeCompileTimeResolverUtil {
    protected static SerdeProvision determineSerde(EPTypeClass type, Collection<SerdeProvider> serdeProviders, boolean allowSerializable, boolean allowExternalizable, boolean allowSerializationFallback, SerdeProviderAdditionalInfo additionalInfo) {
        SerdeProvision serde;
        if (!serdeProviders.isEmpty()) {
            EPTypeClass componentType;
            SerdeProvision componentSerde;
            serde = SerdeCompileTimeResolverUtil.determineSerdeFromProviders(type, serdeProviders, additionalInfo);
            if (serde != null) {
                return serde;
            }
            if (type.getType().isArray() && (componentSerde = SerdeCompileTimeResolverUtil.determineSerdeFromProviders(componentType = JavaClassHelper.getArrayComponentType(type), serdeProviders, additionalInfo)) != null) {
                return new SerdeProvisionArrayOfNonPrimitive(componentType, componentSerde);
            }
        }
        if ((serde = SerdeCompileTimeResolverUtil.determineSerializable(type, allowExternalizable, allowSerializable, allowSerializationFallback)) != null) {
            return serde;
        }
        throw SerdeCompileTimeResolverUtil.makeFailedToFindException(type, allowExternalizable, allowSerializable, serdeProviders.size(), additionalInfo);
    }

    private static SerdeProvision determineSerdeFromProviders(EPTypeClass type, Collection<SerdeProvider> serdeProviders, SerdeProviderAdditionalInfo additionalInfo) {
        if (serdeProviders.isEmpty()) {
            return null;
        }
        SerdeProviderContextClass context = new SerdeProviderContextClass(type, additionalInfo);
        for (SerdeProvider provider : serdeProviders) {
            try {
                SerdeProvision serde = provider.resolveSerdeForClass(context);
                if (serde == null) continue;
                return serde;
            }
            catch (DataInputOutputSerdeException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw SerdeCompileTimeResolverUtil.handleProviderRuntimeException(provider, type, ex);
            }
        }
        return null;
    }

    private static SerdeProvision determineSerializable(EPTypeClass type, boolean allowExternalizable, boolean allowSerializable, boolean allowSerializationFallback) {
        if (allowSerializationFallback) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        if (JavaClassHelper.isImplementsInterface(type, Externalizable.class) && allowExternalizable) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        if (type.getType().isArray() && JavaClassHelper.isImplementsInterface(type.getType().getComponentType(), Externalizable.class) && allowExternalizable) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        if (JavaClassHelper.isImplementsInterface(type, Serializable.class) && allowSerializable) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        if (type.getType().isArray() && JavaClassHelper.isImplementsInterface(type.getType().getComponentType(), Serializable.class) && allowSerializable) {
            return new SerdeProvisionByClass(DIOSerializableObjectSerde.class);
        }
        return null;
    }

    private static DataInputOutputSerdeException handleProviderRuntimeException(SerdeProvider provider, EPTypeClass type, RuntimeException ex) {
        return new DataInputOutputSerdeException("Unexpected exception invoking serde provider '" + provider.getClass().getName() + "' passing '" + type + "': " + ex.getMessage(), ex);
    }

    private static DataInputOutputSerdeException makeFailedToFindException(EPTypeClass clazz, boolean allowExternalizable, boolean allowSerializable, int numSerdeProviders, SerdeProviderAdditionalInfo additionalInfo) {
        return new DataInputOutputSerdeException("Failed to find serde for class '" + ClassHelperPrint.getClassNameFullyQualPretty(clazz) + "' for use with " + additionalInfo + " (allowExternalizable=" + allowExternalizable + ",allowSerializable=" + allowSerializable + ",serdeProvider-count=" + numSerdeProviders + ")");
    }
}

