/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.compiletime.sharable;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenFieldSharable;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.event.core.EventTypeUtility;

public class CodegenSharableSerdeEventTyped
implements CodegenFieldSharable {
    private final CodegenSharableSerdeName name;
    private final EventType eventType;

    public CodegenSharableSerdeEventTyped(CodegenSharableSerdeName name, EventType eventType) {
        this.name = name;
        this.eventType = eventType;
        if (eventType == null || name == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public EPTypeClass type() {
        return DataInputOutputSerde.EPTYPE;
    }

    @Override
    public CodegenExpression initCtorScoped() {
        CodegenExpression type = EventTypeUtility.resolveTypeCodegen(this.eventType, EPStatementInitServices.REF);
        return CodegenExpressionBuilder.exprDotMethodChain(EPStatementInitServices.REF).add("getEventTypeResolver", new CodegenExpression[0]).add("getEventSerdeFactory", new CodegenExpression[0]).add(this.name.methodName, type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodegenSharableSerdeEventTyped that = (CodegenSharableSerdeEventTyped)o;
        if (this.name != that.name) {
            return false;
        }
        return this.eventType.getName().equals(that.eventType.getName());
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.eventType.getName().hashCode();
        return result;
    }

    public static enum CodegenSharableSerdeName {
        NULLABLEEVENTMAYCOLLATE("nullableEventMayCollate"),
        LISTEVENTS("listEvents"),
        LINKEDHASHMAPEVENTSANDINT("linkedHashMapEventsAndInt"),
        REFCOUNTEDSETATOMICINTEGER("refCountedSetAtomicInteger");

        private final String methodName;

        private CodegenSharableSerdeName(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

