/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.serde.serdeset.builtin.DIOBigDecimalBigIntegerUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class DIOBigDecimalSerde
implements DataInputOutputSerde<BigDecimal> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOBigDecimalSerde.class);
    public static final DIOBigDecimalSerde INSTANCE = new DIOBigDecimalSerde();

    private DIOBigDecimalSerde() {
    }

    @Override
    public void write(BigDecimal object, DataOutput output, byte[] pageFullKey, EventBeanCollatedWriter writer) throws IOException {
        this.write(object, output);
    }

    public void write(BigDecimal bigDecimal, DataOutput stream) throws IOException {
        boolean isNull = bigDecimal == null;
        stream.writeBoolean(isNull);
        if (!isNull) {
            stream.writeInt(bigDecimal.scale());
            DIOBigDecimalBigIntegerUtil.writeBigInt(bigDecimal.unscaledValue(), stream);
        }
    }

    public BigDecimal read(DataInput input) throws IOException {
        return this.readInternal(input);
    }

    @Override
    public BigDecimal read(DataInput input, byte[] resourceKey) throws IOException {
        return this.readInternal(input);
    }

    private BigDecimal readInternal(DataInput s) throws IOException {
        boolean isNull = s.readBoolean();
        if (isNull) {
            return null;
        }
        int scale = s.readInt();
        BigInteger bigInt = DIOBigDecimalBigIntegerUtil.readBigInt(s);
        return new BigDecimal(bigInt, scale);
    }
}

