/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIONullableByteSerde
implements DataInputOutputSerde<Byte> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIONullableByteSerde.class);
    public static final DIONullableByteSerde INSTANCE = new DIONullableByteSerde();

    private DIONullableByteSerde() {
    }

    @Override
    public void write(Byte object, DataOutput output, byte[] pageFullKey, EventBeanCollatedWriter writer) throws IOException {
        this.write(object, output);
    }

    public void write(Byte object, DataOutput stream) throws IOException {
        boolean isNull = object == null;
        stream.writeBoolean(isNull);
        if (!isNull) {
            stream.writeByte(object.byteValue());
        }
    }

    public Byte read(DataInput input) throws IOException {
        return this.readInternal(input);
    }

    @Override
    public Byte read(DataInput s, byte[] resourceKey) throws IOException {
        return this.readInternal(s);
    }

    private Byte readInternal(DataInput input) throws IOException {
        boolean isNull = input.readBoolean();
        if (isNull) {
            return null;
        }
        return input.readByte();
    }
}

