/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIONullableFloatSerde
implements DataInputOutputSerde<Float> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIONullableFloatSerde.class);
    public static final DIONullableFloatSerde INSTANCE = new DIONullableFloatSerde();

    private DIONullableFloatSerde() {
    }

    @Override
    public void write(Float object, DataOutput output, byte[] pageFullKey, EventBeanCollatedWriter writer) throws IOException {
        this.write(object, output);
    }

    public void write(Float object, DataOutput stream) throws IOException {
        boolean isNull = object == null;
        stream.writeBoolean(isNull);
        if (!isNull) {
            stream.writeFloat(object.floatValue());
        }
    }

    public Float read(DataInput input) throws IOException {
        return this.readInternal(input);
    }

    @Override
    public Float read(DataInput input, byte[] resourceKey) throws IOException {
        return this.readInternal(input);
    }

    private Float readInternal(DataInput input) throws IOException {
        boolean isNull = input.readBoolean();
        if (isNull) {
            return null;
        }
        return Float.valueOf(input.readFloat());
    }
}

