/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.serde.serdeset.builtin;

import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.serde.EventBeanCollatedWriter;
import com.espertech.esper.common.client.type.EPTypeClass;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DIOPrimitiveFloatArray2DimNullableSerde
implements DataInputOutputSerde<float[][]> {
    public static final EPTypeClass EPTYPE = new EPTypeClass(DIOPrimitiveFloatArray2DimNullableSerde.class);
    public static final DIOPrimitiveFloatArray2DimNullableSerde INSTANCE = new DIOPrimitiveFloatArray2DimNullableSerde();

    private DIOPrimitiveFloatArray2DimNullableSerde() {
    }

    @Override
    public void write(float[][] object, DataOutput output, byte[] unitKey, EventBeanCollatedWriter writer) throws IOException {
        if (object == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(object.length);
        for (float[] i : object) {
            this.writeArray(i, output);
        }
    }

    @Override
    public float[][] read(DataInput input, byte[] unitKey) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        float[][] array = new float[len][];
        for (int i = 0; i < len; ++i) {
            array[i] = this.readArray(input);
        }
        return array;
    }

    private void writeArray(float[] array, DataOutput output) throws IOException {
        if (array == null) {
            output.writeInt(-1);
            return;
        }
        output.writeInt(array.length);
        for (float i : array) {
            output.writeFloat(i);
        }
    }

    private float[] readArray(DataInput input) throws IOException {
        int len = input.readInt();
        if (len == -1) {
            return null;
        }
        float[] array = new float[len];
        for (int i = 0; i < len; ++i) {
            array[i] = input.readFloat();
        }
        return array;
    }
}

