/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.settings;

import com.espertech.esper.common.client.annotation.BuiltinAnnotation;
import com.espertech.esper.common.client.annotation.BusEventType;
import com.espertech.esper.common.client.annotation.Private;
import com.espertech.esper.common.client.annotation.Protected;
import com.espertech.esper.common.client.annotation.Public;
import com.espertech.esper.common.client.configuration.common.ConfigurationCommon;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.util.ClassForNameProvider;
import com.espertech.esper.common.internal.epl.expression.time.abacus.TimeAbacus;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClass;
import com.espertech.esper.common.internal.settings.ClasspathExtensionClassEmpty;
import com.espertech.esper.common.internal.settings.ClasspathImportException;
import com.espertech.esper.common.internal.settings.ClasspathImportService;
import com.espertech.esper.common.internal.util.ClassHelperPrint;
import com.espertech.esper.common.internal.util.MethodResolver;
import com.espertech.esper.common.internal.util.MethodResolverNoSuchCtorException;
import com.espertech.esper.common.internal.util.MethodResolverNoSuchMethodException;
import com.espertech.esper.common.internal.util.TransientConfigurationResolver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClasspathImportServiceBase
implements ClasspathImportService {
    private static final Logger log = LoggerFactory.getLogger(ClasspathImportServiceBase.class);
    private final Map<String, Object> transientConfiguration;
    private final TimeAbacus timeAbacus;
    private final Set<String> eventTypeAutoNames;
    private final List<String> imports = new ArrayList<String>();
    private final List<String> annotationImports = new ArrayList<String>();

    public ClasspathImportServiceBase(Map<String, Object> transientConfiguration, TimeAbacus timeAbacus, Set<String> eventTypeAutoNames) {
        this.transientConfiguration = transientConfiguration;
        this.timeAbacus = timeAbacus;
        this.eventTypeAutoNames = eventTypeAutoNames;
    }

    @Override
    public ClassLoader getClassLoader() {
        return TransientConfigurationResolver.resolveClassLoader(this.transientConfiguration).classloader();
    }

    @Override
    public TimeAbacus getTimeAbacus() {
        return this.timeAbacus;
    }

    public void addImport(String importName) throws ClasspathImportException {
        this.validateImportAndAdd(importName, this.imports);
    }

    public void addAnnotationImport(String importName) throws ClasspathImportException {
        this.validateImportAndAdd(importName, this.annotationImports);
    }

    @Override
    public Method resolveMethodOverloadChecked(String className, String methodName, EPType[] paramTypes, boolean[] allowEventBeanType, boolean[] allowEventBeanCollType, ClasspathExtensionClass classpathExtension) throws ClasspathImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className, false, false, classpathExtension);
        }
        catch (ClassNotFoundException e) {
            throw new ClasspathImportException("Could not load class by name '" + className + "', please check imports", e);
        }
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, false, allowEventBeanType, allowEventBeanCollType);
        }
        catch (MethodResolverNoSuchMethodException e) {
            throw this.convert(clazz, methodName, paramTypes, e, false);
        }
    }

    @Override
    public Class resolveClass(String className, boolean forAnnotation, ClasspathExtensionClass classpathExtension) throws ClasspathImportException {
        Class clazz;
        try {
            clazz = this.resolveClassInternal(className, false, forAnnotation, classpathExtension);
        }
        catch (ClassNotFoundException e) {
            throw this.makeClassNotFoundEx(className, e);
        }
        return clazz;
    }

    @Override
    public Constructor resolveCtor(Class clazz, EPType[] paramTypes) throws ClasspathImportException {
        try {
            return MethodResolver.resolveCtor(clazz, paramTypes);
        }
        catch (MethodResolverNoSuchCtorException e) {
            throw this.convert(clazz, paramTypes, e);
        }
    }

    @Override
    public Method resolveMethod(Class clazz, String methodName, EPType[] paramTypes, boolean[] allowEventBeanType, boolean[] allowEventBeanCollType) throws ClasspathImportException {
        try {
            return MethodResolver.resolveMethod(clazz, methodName, paramTypes, true, allowEventBeanType, allowEventBeanCollType);
        }
        catch (MethodResolverNoSuchMethodException e) {
            throw this.convert(clazz, methodName, paramTypes, e, true);
        }
    }

    protected Class resolveClassInternal(String className, boolean requireAnnotation, boolean forAnnotationUse, ClasspathExtensionClass classpathExtension) throws ClassNotFoundException {
        Class clazzExtension;
        if (forAnnotationUse) {
            String lowercase = className.toLowerCase(Locale.ENGLISH);
            if (lowercase.equals("private")) {
                return Private.class;
            }
            if (lowercase.equals("protected")) {
                return Protected.class;
            }
            if (lowercase.equals("public")) {
                return Public.class;
            }
            if (lowercase.equals("buseventtype")) {
                return BusEventType.class;
            }
        }
        if ((clazzExtension = classpathExtension.findClassByName(className)) != null) {
            return clazzExtension;
        }
        try {
            return this.getClassForNameProvider().classForName(className);
        }
        catch (ClassNotFoundException e) {
            Class clazz;
            if (log.isDebugEnabled()) {
                log.debug("Class not found for resolving from name as-is '" + className + "'");
            }
            if (forAnnotationUse && (clazz = this.checkImports(this.annotationImports, requireAnnotation, className)) != null) {
                return clazz;
            }
            clazz = this.checkImports(this.imports, requireAnnotation, className);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException("Unknown class " + className);
        }
    }

    @Override
    public ClassForNameProvider getClassForNameProvider() {
        return TransientConfigurationResolver.resolveClassForNameProvider(this.transientConfiguration);
    }

    @Override
    public Class resolveClassForBeanEventType(String fullyQualClassName) throws ClasspathImportException {
        try {
            return this.getClassForNameProvider().classForName(fullyQualClassName);
        }
        catch (ClassNotFoundException ex) {
            Class clazz = null;
            for (String javaPackageName : this.eventTypeAutoNames) {
                String generatedClassName = javaPackageName + "." + fullyQualClassName;
                try {
                    Class resolvedClass = this.getClassForNameProvider().classForName(generatedClassName);
                    if (clazz != null) {
                        throw new ClasspathImportException("Failed to resolve name '" + fullyQualClassName + "', the class was ambigously found both in package '" + clazz.getPackage().getName() + "' and in package '" + resolvedClass.getPackage().getName() + "'", ex);
                    }
                    clazz = resolvedClass;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (clazz != null) {
                return clazz;
            }
            return this.resolveClass(fullyQualClassName, false, ClasspathExtensionClassEmpty.INSTANCE);
        }
    }

    private Class checkImports(List<String> imports, boolean requireAnnotation, String className) throws ClassNotFoundException {
        for (String importName : imports) {
            Class clazz;
            Class clazz2;
            String prefixedClassName;
            boolean isClassName = ClasspathImportServiceBase.isClassName(importName);
            boolean containsPackage = importName.indexOf(46) != -1;
            String classNameWithDot = "." + className;
            String classNameWithDollar = "$" + className;
            if (isClassName) {
                if (containsPackage && importName.endsWith(classNameWithDot) || containsPackage && importName.endsWith(classNameWithDollar) || !containsPackage && importName.equals(className) || !containsPackage && importName.endsWith(classNameWithDollar)) {
                    return this.getClassForNameProvider().classForName(importName);
                }
                prefixedClassName = importName + "$" + className;
                try {
                    clazz2 = this.getClassForNameProvider().classForName(prefixedClassName);
                    if (requireAnnotation && !clazz2.isAnnotation()) continue;
                    return clazz2;
                }
                catch (ClassNotFoundException e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Class not found for resolving from name '" + (String)prefixedClassName + "'");
                    continue;
                }
            }
            if (requireAnnotation && importName.equals(ConfigurationCommon.ANNOTATION_IMPORT) && (clazz = BuiltinAnnotation.BUILTIN.get(className.toLowerCase(Locale.ENGLISH))) != null) {
                return clazz;
            }
            prefixedClassName = ClasspathImportServiceBase.getPackageName(importName) + "." + className;
            try {
                clazz2 = this.getClassForNameProvider().classForName(prefixedClassName);
                if (requireAnnotation && !clazz2.isAnnotation()) continue;
                return clazz2;
            }
            catch (ClassNotFoundException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Class not found for resolving from name '" + prefixedClassName + "'");
            }
        }
        return null;
    }

    static boolean isClassName(String importName) {
        String classNameRegEx = "(\\w+\\.)*\\w+(\\$\\w+)?";
        return importName.matches(classNameRegEx);
    }

    static String getPackageName(String importName) {
        return importName.substring(0, importName.length() - 2);
    }

    private static boolean isPackageName(String importName) {
        String classNameRegEx = "(\\w+\\.)+\\*";
        return importName.matches(classNameRegEx);
    }

    protected void validateImportAndAdd(String importName, List<String> imports) throws ClasspathImportException {
        if (!ClasspathImportServiceBase.isClassName(importName) && !ClasspathImportServiceBase.isPackageName(importName)) {
            throw new ClasspathImportException("Invalid import name '" + importName + "'");
        }
        if (log.isDebugEnabled()) {
            log.debug("Adding import " + importName);
        }
        imports.add(importName);
    }

    protected ClasspathImportException makeClassNotFoundEx(String className, Exception e) {
        return new ClasspathImportException("Could not load class by name '" + className + "', please check imports", e);
    }

    protected ClasspathImportException convert(Class clazz, EPType[] paramTypes, MethodResolverNoSuchCtorException e) {
        String expected = ClassHelperPrint.getParameterAsString(paramTypes);
        Object message = "Could not find constructor ";
        message = paramTypes.length > 0 ? (String)message + "in class '" + ClassHelperPrint.getClassNameFullyQualPretty(clazz) + "' with matching parameter number and expected parameter type(s) '" + expected + "'" : (String)message + "in class '" + ClassHelperPrint.getClassNameFullyQualPretty(clazz) + "' taking no parameters";
        if (e.getNearestMissCtor() != null) {
            message = (String)message + " (nearest matching constructor ";
            message = e.getNearestMissCtor().getParameterTypes().length == 0 ? (String)message + "taking no parameters" : (String)message + "taking type(s) '" + ClassHelperPrint.getParameterAsString(e.getNearestMissCtor().getParameterTypes()) + "'";
            message = (String)message + ")";
        }
        return new ClasspathImportException((String)message, e);
    }

    protected ClasspathImportException convert(Class clazz, String methodName, EPType[] paramTypes, MethodResolverNoSuchMethodException e, boolean isInstance) {
        String expected = ClassHelperPrint.getParameterAsString(paramTypes);
        Object message = "Could not find ";
        message = !isInstance ? (String)message + "static method " : (String)message + "enumeration method, date-time method, instance method or property ";
        message = paramTypes.length > 0 ? (String)message + "named '" + methodName + "' in class '" + ClassHelperPrint.getClassNameFullyQualPretty(clazz) + "' with matching parameter number and expected parameter type(s) '" + expected + "'" : (String)message + "named '" + methodName + "' in class '" + ClassHelperPrint.getClassNameFullyQualPretty(clazz) + "' taking no parameters";
        if (e.getNearestMissMethod() != null) {
            message = (String)message + " (nearest match found was '" + e.getNearestMissMethod().getName();
            message = e.getNearestMissMethod().getParameterTypes().length == 0 ? (String)message + "' taking no parameters" : (String)message + "' taking type(s) '" + ClassHelperPrint.getParameterAsString(e.getNearestMissMethod().getParameterTypes()) + "'";
            message = (String)message + ")";
        }
        return new ClasspathImportException((String)message, e);
    }
}

