/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.settings;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.hook.condition.BaseCondition;
import com.espertech.esper.common.client.hook.condition.ConditionHandler;
import com.espertech.esper.common.client.hook.condition.ConditionHandlerContext;
import com.espertech.esper.common.client.hook.exception.ExceptionHandler;
import com.espertech.esper.common.client.hook.exception.ExceptionHandlerContext;
import com.espertech.esper.common.client.hook.exception.ExceptionHandlerContextUnassociated;
import com.espertech.esper.common.client.hook.exception.ExceptionHandlerExceptionType;
import com.espertech.esper.common.client.hook.exception.ExceptionHandlerInboundPool;
import com.espertech.esper.common.client.util.StatementProperty;
import com.espertech.esper.common.internal.context.util.EPStatementAgentInstanceHandle;
import com.espertech.esper.common.internal.context.util.StatementContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluatorContext;
import java.io.StringWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlingService {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlingService.class);
    private final String runtimeURI;
    private final List<ExceptionHandler> exceptionHandlers;
    private final List<ConditionHandler> conditionHandlers;

    public ExceptionHandlingService(String runtimeURI, List<ExceptionHandler> exceptionHandlers, List<ConditionHandler> conditionHandlers) {
        this.runtimeURI = runtimeURI;
        this.exceptionHandlers = exceptionHandlers;
        this.conditionHandlers = conditionHandlers;
    }

    public void handleCondition(BaseCondition condition, StatementContext statement) {
        String optionalEPL = (String)statement.getStatementInformationals().getProperties().get((Object)StatementProperty.EPL);
        this.handleCondition(condition, statement.getDeploymentId(), statement.getStatementName(), optionalEPL);
    }

    public void handleCondition(BaseCondition condition, ExprEvaluatorContext exprEvaluatorContext) {
        this.handleCondition(condition, exprEvaluatorContext.getDeploymentId(), exprEvaluatorContext.getStatementName(), exprEvaluatorContext.getEPLWhenAvailable());
    }

    public void handleCondition(BaseCondition condition, String deplomentId, String statementName, String optionalEPL) {
        if (this.conditionHandlers.isEmpty()) {
            String message = "Condition encountered processing deployment id '" + deplomentId + "' statement '" + statementName + "'";
            if (optionalEPL != null) {
                message = message + " statement text '" + optionalEPL + "'";
            }
            message = message + " :" + condition.toString();
            log.info(message);
            return;
        }
        ConditionHandlerContext context = new ConditionHandlerContext(this.runtimeURI, statementName, deplomentId, condition);
        for (ConditionHandler handler : this.conditionHandlers) {
            handler.handle(context);
        }
    }

    public void handleException(RuntimeException ex, EPStatementAgentInstanceHandle handle, ExceptionHandlerExceptionType type, EventBean optionalCurrentEvent) {
        this.handleException(ex, handle.getStatementHandle().getDeploymentId(), handle.getStatementHandle().getStatementName(), handle.getStatementHandle().getOptionalStatementEPL(), type, optionalCurrentEvent);
    }

    public String getRuntimeURI() {
        return this.runtimeURI;
    }

    public void handleException(Throwable t, String deploymentId, String statementName, String optionalEPL, ExceptionHandlerExceptionType type, EventBean optionalCurrentEvent) {
        if (this.exceptionHandlers.isEmpty()) {
            StringWriter writer = new StringWriter();
            if (type == ExceptionHandlerExceptionType.PROCESS) {
                writer.append("Exception encountered processing ");
            } else {
                writer.append("Exception encountered performing instance stop for ");
            }
            writer.append("deployment-id '");
            writer.append(deploymentId);
            writer.append("' ");
            writer.append("statement '");
            writer.append(statementName);
            writer.append("'");
            if (optionalEPL != null) {
                writer.append(" expression '");
                writer.append(optionalEPL);
                writer.append("'");
            }
            writer.append(" : ");
            writer.append(t.getMessage());
            String message = writer.toString();
            if (type == ExceptionHandlerExceptionType.PROCESS) {
                log.error(message, t);
            } else {
                log.warn(message, t);
            }
            return;
        }
        ExceptionHandlerContext context = new ExceptionHandlerContext(this.runtimeURI, t, deploymentId, statementName, optionalEPL, type, optionalCurrentEvent);
        for (ExceptionHandler handler : this.exceptionHandlers) {
            handler.handle(context);
        }
    }

    public void handleInboundPoolException(String runtimeURI, Throwable exception, Object event) {
        ExceptionHandlerContextUnassociated context = new ExceptionHandlerContextUnassociated(runtimeURI, exception, event);
        for (ExceptionHandler handler : this.exceptionHandlers) {
            if (!(handler instanceof ExceptionHandlerInboundPool)) continue;
            ((ExceptionHandlerInboundPool)handler).handleInboundPoolUnassociated(context);
        }
    }
}

