/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.statement.insertintolatch;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.statement.insertintolatch.InsertIntoLatch;
import com.espertech.esper.common.internal.statement.insertintolatch.InsertIntoLatchFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertIntoLatchSpin
implements InsertIntoLatch {
    private static final Logger log = LoggerFactory.getLogger(InsertIntoLatchSpin.class);
    private final InsertIntoLatchFactory factory;
    private InsertIntoLatchSpin earlier;
    private final long msecTimeout;
    private EventBean payload;
    private volatile boolean isCompleted;

    public InsertIntoLatchSpin(InsertIntoLatchFactory factory, InsertIntoLatchSpin earlier, long msecTimeout, EventBean payload) {
        this.factory = factory;
        this.earlier = earlier;
        this.msecTimeout = msecTimeout;
        this.payload = payload;
    }

    public InsertIntoLatchSpin(InsertIntoLatchFactory factory) {
        this.factory = factory;
        this.isCompleted = true;
        this.earlier = null;
        this.msecTimeout = 0L;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public EventBean await() {
        if (!this.earlier.isCompleted) {
            long spinStartTime = this.factory.getTimeSourceService().getTimeMillis();
            while (!this.earlier.isCompleted) {
                Thread.yield();
                long spinDelta = this.factory.getTimeSourceService().getTimeMillis() - spinStartTime;
                if (spinDelta <= this.msecTimeout) continue;
                log.info("Spin wait timeout exceeded in insert-into dispatch at " + this.msecTimeout + "ms for " + this.factory.getName() + ", consider disabling insert-into between-statement latching for better performance");
                break;
            }
        }
        return this.payload;
    }

    public void done() {
        this.isCompleted = true;
        this.earlier = null;
    }

    @Override
    public InsertIntoLatchFactory getFactory() {
        return this.factory;
    }

    @Override
    public EventBean getEvent() {
        return this.payload;
    }

    @Override
    public void setEvent(EventBean event) {
        this.payload = event;
    }
}

