/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.statement.resource;

import com.espertech.esper.common.internal.statement.resource.StatementResourceHolder;
import java.util.HashMap;
import java.util.Map;

public class StatementResourceService {
    private StatementResourceHolder resourcesUnpartitioned;
    private Map<Integer, StatementResourceHolder> resourcesPartitioned;

    public StatementResourceService(boolean partitioned) {
        if (partitioned) {
            this.resourcesPartitioned = new HashMap<Integer, StatementResourceHolder>();
        }
    }

    public StatementResourceHolder getResourcesUnpartitioned() {
        return this.resourcesUnpartitioned;
    }

    public Map<Integer, StatementResourceHolder> getResourcesPartitioned() {
        return this.resourcesPartitioned;
    }

    public StatementResourceHolder getPartitioned(int agentInstanceId) {
        return this.resourcesPartitioned.get(agentInstanceId);
    }

    public void setUnpartitioned(StatementResourceHolder statementResourceHolder) {
        this.resourcesUnpartitioned = statementResourceHolder;
    }

    public void setPartitioned(int agentInstanceId, StatementResourceHolder statementResourceHolder) {
        this.resourcesPartitioned.put(agentInstanceId, statementResourceHolder);
    }

    public StatementResourceHolder getUnpartitioned() {
        return this.resourcesUnpartitioned;
    }

    public StatementResourceHolder deallocatePartitioned(int agentInstanceId) {
        return this.resourcesPartitioned.remove(agentInstanceId);
    }

    public StatementResourceHolder deallocateUnpartitioned() {
        StatementResourceHolder unpartitioned = this.resourcesUnpartitioned;
        this.resourcesUnpartitioned = null;
        return unpartitioned;
    }
}

