/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.support;

import com.espertech.esper.common.client.annotation.EventRepresentation;
import com.espertech.esper.common.client.configuration.Configuration;
import com.espertech.esper.common.client.soda.AnnotationPart;
import com.espertech.esper.common.client.soda.EPStatementObjectModel;
import com.espertech.esper.common.client.util.EventUnderlyingType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.ArrayList;
import java.util.HashSet;

public enum EventRepresentationChoice {
    OBJECTARRAY(EventUnderlyingType.OBJECTARRAY, "@EventRepresentation('objectarray')"),
    MAP(EventUnderlyingType.MAP, "@EventRepresentation('map')"),
    AVRO(EventUnderlyingType.AVRO, "@EventRepresentation('avro')"),
    JSON(EventUnderlyingType.JSON, "@EventRepresentation('json')"),
    JSONCLASSPROVIDED(EventUnderlyingType.JSON, "@EventRepresentation('json')"),
    DEFAULT(EventUnderlyingType.getDefault(), "");

    private final EventUnderlyingType eventRepresentation;
    private final String annotationText;
    private final String outputTypeClassName;
    private final Class outputTypeClass;

    private EventRepresentationChoice(EventUnderlyingType eventRepresentation, String annotationText) {
        this.eventRepresentation = eventRepresentation;
        this.annotationText = annotationText;
        this.outputTypeClassName = eventRepresentation.getUnderlyingClassName();
        this.outputTypeClass = eventRepresentation.getUnderlyingClass();
    }

    public String getAnnotationText() {
        if (this == JSONCLASSPROVIDED) {
            throw new UnsupportedOperationException("For Json-Provided please use getAnnotationTextWJsonProvided(class)");
        }
        return this.annotationText;
    }

    public String getAnnotationTextWJsonProvided(Class jsonProvidedClass) {
        if (this == JSONCLASSPROVIDED) {
            return "@JsonSchema(className='" + jsonProvidedClass.getName() + "') " + this.annotationText;
        }
        return this.annotationText;
    }

    public boolean matchesClass(Class representationType) {
        HashSet<Class> supers = new HashSet<Class>();
        JavaClassHelper.getSuper(representationType, supers);
        supers.add(representationType);
        for (Class clazz : supers) {
            if (!clazz.getName().equals(this.outputTypeClassName) && (this.outputTypeClass == null || !JavaClassHelper.isSubclassOrImplementsInterface(clazz, this.outputTypeClass))) continue;
            return true;
        }
        return false;
    }

    public boolean isObjectArrayEvent() {
        return this == OBJECTARRAY;
    }

    public boolean isMapEvent() {
        return this == DEFAULT || this == MAP;
    }

    public String getAnnotationTextForNonMap() {
        if (this == DEFAULT || this == MAP) {
            return "";
        }
        return this.annotationText;
    }

    public void addAnnotationForNonMap(EPStatementObjectModel model) {
        if (this == DEFAULT || this == MAP) {
            return;
        }
        AnnotationPart part = new AnnotationPart(EventRepresentation.class.getSimpleName());
        if (this == OBJECTARRAY) {
            part.addValue("objectarray");
        }
        if (this == AVRO) {
            part.addValue("avro");
        }
        if (this == JSON || this == JSONCLASSPROVIDED) {
            part.addValue("json");
        }
        if (model.getAnnotations() == null) {
            model.setAnnotations(new ArrayList<AnnotationPart>(2));
        }
        model.getAnnotations().add(part);
    }

    public boolean isAvroEvent() {
        return this == AVRO;
    }

    public boolean isAvroOrJsonEvent() {
        return this == AVRO || this == JSON || this == JSONCLASSPROVIDED;
    }

    public static EventRepresentationChoice getEngineDefault(Configuration configuration) {
        EventUnderlyingType configured = configuration.getCommon().getEventMeta().getDefaultEventRepresentation();
        if (configured == EventUnderlyingType.OBJECTARRAY) {
            return OBJECTARRAY;
        }
        if (configured == EventUnderlyingType.AVRO) {
            return AVRO;
        }
        return MAP;
    }

    public boolean isJsonEvent() {
        return this == JSON;
    }

    public boolean isJsonProvidedClassEvent() {
        return this == JSONCLASSPROVIDED;
    }

    public String getName() {
        if (this == DEFAULT) {
            return this.eventRepresentation.name();
        }
        return this.name();
    }
}

