/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.support;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.util.Map;

public class SupportEventPropDesc {
    private String propertyName;
    private EPType propertyType;
    private boolean isRequiresIndex;
    private boolean isRequiresMapkey;
    private boolean isIndexed;
    private boolean isMapped;
    private boolean isFragment;
    private Class componentType;

    public SupportEventPropDesc(String name, Class clazz) {
        this.propertyName = name;
        this.propertyType = ClassHelperGenericType.getClassEPType(clazz);
        this.presets();
    }

    public SupportEventPropDesc(String name, EPType type) {
        this.propertyName = name;
        this.propertyType = type;
        this.presets();
    }

    private void presets() {
        if (this.propertyType == EPTypeNull.INSTANCE) {
            return;
        }
        EPTypeClass propertyClass = (EPTypeClass)this.propertyType;
        if (propertyClass.getType().isArray()) {
            this.indexed().componentType(propertyClass.getType().getComponentType());
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)propertyClass, Iterable.class)) {
            this.indexed().componentType(JavaClassHelper.getSingleParameterTypeOrObject((EPTypeClass)this.propertyType).getType());
        }
        if (JavaClassHelper.isSubclassOrImplementsInterface((EPType)propertyClass, Map.class)) {
            this.mapped().componentType(JavaClassHelper.getSecondParameterTypeOrObject((EPTypeClass)this.propertyType).getType());
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public EPType getPropertyType() {
        return this.propertyType;
    }

    public boolean isRequiresIndex() {
        return this.isRequiresIndex;
    }

    public boolean isRequiresMapkey() {
        return this.isRequiresMapkey;
    }

    public boolean isIndexed() {
        return this.isIndexed;
    }

    public boolean isMapped() {
        return this.isMapped;
    }

    public boolean isFragment() {
        return this.isFragment;
    }

    public Class getComponentType() {
        return this.componentType;
    }

    public SupportEventPropDesc mapped() {
        this.isMapped = true;
        return this;
    }

    public SupportEventPropDesc mapped(boolean flag) {
        this.isMapped = flag;
        return this;
    }

    public SupportEventPropDesc mappedRequiresKey() {
        this.isMapped = true;
        this.isRequiresMapkey = true;
        return this;
    }

    public SupportEventPropDesc indexed() {
        this.isIndexed = true;
        return this;
    }

    public SupportEventPropDesc indexed(boolean flag) {
        this.isIndexed = flag;
        return this;
    }

    public SupportEventPropDesc indexedRequiresIndex() {
        this.isIndexed = true;
        this.isRequiresIndex = true;
        return this;
    }

    public SupportEventPropDesc componentType(Class componentType) {
        this.componentType = componentType;
        return this;
    }

    public SupportEventPropDesc fragment() {
        this.isFragment = true;
        return this;
    }

    public SupportEventPropDesc fragment(boolean flag) {
        this.isFragment = flag;
        return this;
    }
}

