/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.support;

import com.espertech.esper.common.client.EventPropertyDescriptor;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.scopetest.ScopeTestHelper;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.support.SupportEventPropDesc;
import java.util.HashMap;

public class SupportEventPropUtil {
    public static void assertPropsEquals(EventPropertyDescriptor[] received, SupportEventPropDesc ... expected) {
        ScopeTestHelper.assertEquals(received.length, expected.length);
        HashMap<String, EventPropertyDescriptor> receivedProps = new HashMap<String, EventPropertyDescriptor>();
        for (EventPropertyDescriptor descReceived : received) {
            if (receivedProps.containsKey(descReceived.getPropertyName())) {
                ScopeTestHelper.fail("duplicate '" + descReceived.getPropertyName() + "'");
            }
            receivedProps.put(descReceived.getPropertyName(), descReceived);
        }
        HashMap<String, SupportEventPropDesc> expectedProps = new HashMap<String, SupportEventPropDesc>();
        for (SupportEventPropDesc expectedDesc : expected) {
            if (expectedProps.containsKey(expectedDesc.getPropertyName())) {
                ScopeTestHelper.fail("duplicate '" + expectedDesc.getPropertyName() + "'");
            }
            expectedProps.put(expectedDesc.getPropertyName(), expectedDesc);
        }
        for (EventPropertyDescriptor receivedDesc : received) {
            SupportEventPropDesc expectedDesc = (SupportEventPropDesc)expectedProps.get(receivedDesc.getPropertyName());
            if (expectedDesc == null) {
                ScopeTestHelper.fail("could not find in expected the name '" + receivedDesc.getPropertyName() + "'");
            }
            SupportEventPropUtil.assertPropEquals(expectedDesc, receivedDesc);
        }
    }

    public static void assertPropEquals(SupportEventPropDesc expected, EventPropertyDescriptor received) {
        String message = "comparing '" + expected.getPropertyName() + "'";
        ScopeTestHelper.assertEquals(message, expected.getPropertyName(), received.getPropertyName());
        ScopeTestHelper.assertEquals(message, expected.getPropertyType(), received.getPropertyEPType());
        ScopeTestHelper.assertEquals(message, expected.getComponentType(), received.getPropertyComponentType());
        ScopeTestHelper.assertEquals(message, expected.getPropertyType(), received.getPropertyEPType());
        ScopeTestHelper.assertEquals(message, expected.isFragment(), received.isFragment());
        ScopeTestHelper.assertEquals(message, expected.isIndexed(), received.isIndexed());
        ScopeTestHelper.assertEquals(message, expected.isRequiresIndex(), received.isRequiresIndex());
        ScopeTestHelper.assertEquals(message, expected.isMapped(), received.isMapped());
        ScopeTestHelper.assertEquals(message, expected.isRequiresMapkey(), received.isRequiresMapkey());
    }

    public static void assertTypes(EventType type, String[] fields, EPTypeClass[] classes) {
        int count = 0;
        for (String field : fields) {
            ScopeTestHelper.assertEquals("position " + count, classes[count++], type.getPropertyEPType(field));
        }
    }

    public static void assertTypes(EventType type, String field, EPTypeClass clazz) {
        SupportEventPropUtil.assertTypes(type, new String[]{field}, new EPTypeClass[]{clazz});
    }

    public static void assertTypesAllSame(EventType type, String[] fields, EPTypeClass clazz) {
        int count = 0;
        for (String field : fields) {
            ScopeTestHelper.assertEquals("position " + count, clazz, type.getPropertyEPType(field));
        }
    }
}

