/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.internal.type.ClassDescriptor;
import com.espertech.esper.common.internal.type.ClassDescriptorParseException;
import com.espertech.esper.common.internal.type.ClassDescriptorToken;
import com.espertech.esper.common.internal.type.ClassDescriptorTokenType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Locale;

public class ClassDescriptorParserWalker {
    private final ArrayDeque<ClassDescriptorToken> tokens;
    private ClassDescriptorToken lookahead;

    public ClassDescriptorParserWalker(ArrayDeque<ClassDescriptorToken> tokens) {
        if (tokens.isEmpty()) {
            throw new ClassDescriptorParseException("Empty class identifier");
        }
        this.lookahead = tokens.getFirst();
        this.tokens = tokens;
    }

    public ClassDescriptor walk(boolean typeParam) throws ClassDescriptorParseException {
        if (this.lookahead.token != ClassDescriptorTokenType.IDENTIFIER) {
            this.expectOrFail(ClassDescriptorTokenType.IDENTIFIER);
        }
        String name = this.lookahead.sequence;
        ClassDescriptor ident = new ClassDescriptor(name);
        this.nextToken();
        if (this.lookahead.token == ClassDescriptorTokenType.LESSER_THAN) {
            this.nextToken();
            this.walkTypeParams(ident);
        }
        if (this.lookahead.token == ClassDescriptorTokenType.LEFT_BRACKET) {
            this.nextToken();
            this.walkArray(ident);
        }
        if (!typeParam) {
            this.expectOrFail(ClassDescriptorTokenType.END);
            return ident;
        }
        return ident;
    }

    private void walkArray(ClassDescriptor ident) {
        if (this.lookahead.token == ClassDescriptorTokenType.IDENTIFIER) {
            String name = this.lookahead.sequence;
            if (!name.toLowerCase(Locale.ENGLISH).trim().equals("primitive")) {
                throw new ClassDescriptorParseException("Invalid array keyword '" + name + "', expected ']' or 'primitive'");
            }
            ident.setArrayOfPrimitive(true);
            this.nextToken();
        }
        while (true) {
            this.expectOrFail(ClassDescriptorTokenType.RIGHT_BRACKET);
            this.nextToken();
            ident.setArrayDimensions(ident.getArrayDimensions() + 1);
            if (this.lookahead.token != ClassDescriptorTokenType.LEFT_BRACKET) break;
            this.nextToken();
        }
    }

    private void walkTypeParams(ClassDescriptor parent) {
        ClassDescriptor ident = this.walk(true);
        if (parent.getTypeParameters().isEmpty()) {
            parent.setTypeParameters(new ArrayList<ClassDescriptor>(2));
        }
        parent.getTypeParameters().add(ident);
        while (true) {
            if (this.lookahead.token == ClassDescriptorTokenType.COMMA) {
                this.nextToken();
                ident = this.walk(true);
                parent.getTypeParameters().add(ident);
                continue;
            }
            if (this.lookahead.token == ClassDescriptorTokenType.GREATER_THAN) break;
            this.expectOrFail(ClassDescriptorTokenType.GREATER_THAN);
        }
        this.nextToken();
    }

    private void nextToken() {
        this.tokens.pop();
        this.lookahead = this.tokens.isEmpty() ? new ClassDescriptorToken(ClassDescriptorTokenType.END, "") : this.tokens.getFirst();
    }

    private void expectOrFail(ClassDescriptorTokenType expected) {
        if (this.lookahead.token != expected) {
            throw new ClassDescriptorParseException("Unexpected token " + this.lookahead.token + " value '" + this.lookahead.sequence + "', expecting " + expected);
        }
    }
}

