/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.internal.type.ClassDescriptorParseException;
import com.espertech.esper.common.internal.type.ClassDescriptorToken;
import com.espertech.esper.common.internal.type.ClassDescriptorTokenInfo;
import com.espertech.esper.common.internal.type.ClassDescriptorTokenType;
import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClassDescriptorTokenizer {
    private final LinkedList<ClassDescriptorTokenInfo> tokens = new LinkedList();

    public void add(String pattern, ClassDescriptorTokenType token) {
        this.tokens.add(new ClassDescriptorTokenInfo(Pattern.compile("^(" + pattern + ")"), token));
    }

    public ArrayDeque<ClassDescriptorToken> tokenize(String str) throws ClassDescriptorParseException {
        ArrayDeque<ClassDescriptorToken> tokens = new ArrayDeque<ClassDescriptorToken>(4);
        while (!str.equals("")) {
            boolean match = false;
            for (ClassDescriptorTokenInfo info : this.tokens) {
                Matcher m = info.regex.matcher(str);
                if (!m.find()) continue;
                match = true;
                String tok = m.group().trim();
                tokens.add(new ClassDescriptorToken(info.token, tok));
                str = m.replaceFirst("").trim();
                break;
            }
            if (match) continue;
            throw new ClassDescriptorParseException("Unexpected token '" + str + "'");
        }
        return tokens;
    }
}

