/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.type;

import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenBlock;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionField;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.type.MathContextCodegenField;
import com.espertech.esper.common.internal.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.HashMap;
import java.util.Map;

public enum MathArithTypeEnum {
    ADD("+"),
    SUBTRACT("-"),
    DIVIDE("/"),
    MULTIPLY("*"),
    MODULO("%");

    private static Map<MathArithDesc, Computer> computers;
    private String expressionText;

    private MathArithTypeEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public Computer getComputer(EPTypeClass coercedTypeClass, EPTypeClass typeOne, EPTypeClass typeTwo, boolean isIntegerDivision, boolean isDivisionByZeroReturnsNull, MathContext optionalMathContext) {
        Class<?> coercedType = coercedTypeClass.getType();
        if (coercedType != Double.class && coercedType != Float.class && coercedType != Long.class && coercedType != Integer.class && coercedType != BigDecimal.class && coercedType != BigInteger.class && coercedType != Short.class && coercedType != Byte.class) {
            throw new IllegalArgumentException("Expected base numeric type for computation result but got type " + coercedType);
        }
        if (coercedType == BigDecimal.class) {
            return this.makeBigDecimalComputer(typeOne, typeTwo, isDivisionByZeroReturnsNull, optionalMathContext);
        }
        if (coercedType == BigInteger.class) {
            return this.makeBigIntegerComputer(typeOne, typeTwo);
        }
        if (this != DIVIDE) {
            MathArithDesc key = new MathArithDesc(coercedTypeClass, this);
            Computer computer = computers.get(key);
            if (computer == null) {
                throw new IllegalArgumentException("Could not determine process or type " + this + " type " + coercedType);
            }
            return computer;
        }
        if (!isIntegerDivision) {
            return new DivideDouble(isDivisionByZeroReturnsNull);
        }
        if (coercedType == Double.class) {
            return new DivideDouble(isDivisionByZeroReturnsNull);
        }
        if (coercedType == Float.class) {
            return new DivideFloat();
        }
        if (coercedType == Long.class) {
            return new DivideLong();
        }
        if (coercedType == Integer.class) {
            return new DivideInt();
        }
        throw new IllegalArgumentException("Could not determine process or type " + this + " type " + coercedType);
    }

    private Computer makeBigDecimalComputer(EPTypeClass typeOne, EPTypeClass typeTwo, boolean divisionByZeroReturnsNull, MathContext optionalMathContext) {
        if (typeOne.getType() == BigDecimal.class && typeTwo.getType() == BigDecimal.class) {
            if (this == DIVIDE) {
                if (optionalMathContext != null) {
                    return new DivideBigDecWMathContext(divisionByZeroReturnsNull, optionalMathContext);
                }
                return new DivideBigDec(divisionByZeroReturnsNull);
            }
            return computers.get(new MathArithDesc(EPTypePremade.BIGDECIMAL.getEPType(), this));
        }
        SimpleNumberBigDecimalCoercer convertorOne = SimpleNumberCoercerFactory.getCoercerBigDecimal(typeOne);
        SimpleNumberBigDecimalCoercer convertorTwo = SimpleNumberCoercerFactory.getCoercerBigDecimal(typeTwo);
        if (this == ADD) {
            return new AddBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == SUBTRACT) {
            return new SubtractBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == MULTIPLY) {
            return new MultiplyBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == DIVIDE) {
            if (optionalMathContext == null) {
                return new DivideBigDecConvComputerNoMathCtx(convertorOne, convertorTwo, divisionByZeroReturnsNull);
            }
            return new DivideBigDecConvComputerWithMathCtx(convertorOne, convertorTwo, divisionByZeroReturnsNull, optionalMathContext);
        }
        return new ModuloDouble();
    }

    private Computer makeBigIntegerComputer(EPTypeClass typeOne, EPTypeClass typeTwo) {
        Computer computer;
        if (typeOne.getType() == BigDecimal.class && typeTwo.getType() == BigDecimal.class) {
            return computers.get(new MathArithDesc(EPTypePremade.BIGDECIMAL.getEPType(), this));
        }
        if (typeOne.getType() == BigInteger.class && typeTwo.getType() == BigInteger.class && (computer = computers.get(new MathArithDesc(EPTypePremade.BIGINTEGER.getEPType(), this))) != null) {
            return computer;
        }
        SimpleNumberBigIntegerCoercer convertorOne = SimpleNumberCoercerFactory.getCoercerBigInteger(typeOne);
        SimpleNumberBigIntegerCoercer convertorTwo = SimpleNumberCoercerFactory.getCoercerBigInteger(typeTwo);
        if (this == ADD) {
            return new AddBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == SUBTRACT) {
            return new SubtractBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == MULTIPLY) {
            return new MultiplyBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == DIVIDE) {
            return new DivideBigIntConvComputer(convertorOne, convertorTwo);
        }
        return new ModuloLong();
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public static MathArithTypeEnum parseOperator(String operator) {
        for (int i = 0; i < MathArithTypeEnum.values().length; ++i) {
            MathArithTypeEnum val = MathArithTypeEnum.values()[i];
            if (!val.getExpressionText().equals(operator)) continue;
            return MathArithTypeEnum.values()[i];
        }
        throw new IllegalArgumentException("Unknown operator '" + operator + "'");
    }

    public static CodegenExpression codegenAsLong(CodegenExpression ref, EPTypeClass type) {
        return SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLong(ref, type);
    }

    public static CodegenExpression codegenAsDouble(CodegenExpression ref, EPTypeClass type) {
        return SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(ref, type);
    }

    public static CodegenExpression codegenAsInt(CodegenExpression ref, EPTypeClass type) {
        return SimpleNumberCoercerFactory.SimpleNumberCoercerInt.codegenInt(ref, type);
    }

    public static CodegenExpression codegenAsFloat(CodegenExpression ref, EPTypeClass type) {
        return SimpleNumberCoercerFactory.SimpleNumberCoercerFloat.codegenFloat(ref, type);
    }

    static {
        computers = new HashMap<MathArithDesc, Computer>();
        computers.put(new MathArithDesc(EPTypePremade.DOUBLEBOXED.getEPType(), ADD), new AddDouble());
        computers.put(new MathArithDesc(EPTypePremade.FLOATBOXED.getEPType(), ADD), new AddFloat());
        computers.put(new MathArithDesc(EPTypePremade.LONGBOXED.getEPType(), ADD), new AddLong());
        computers.put(new MathArithDesc(EPTypePremade.INTEGERBOXED.getEPType(), ADD), new AddInt());
        computers.put(new MathArithDesc(EPTypePremade.BIGDECIMAL.getEPType(), ADD), new AddBigDec());
        computers.put(new MathArithDesc(EPTypePremade.BIGINTEGER.getEPType(), ADD), new AddBigInt());
        computers.put(new MathArithDesc(EPTypePremade.DOUBLEBOXED.getEPType(), SUBTRACT), new SubtractDouble());
        computers.put(new MathArithDesc(EPTypePremade.FLOATBOXED.getEPType(), SUBTRACT), new SubtractFloat());
        computers.put(new MathArithDesc(EPTypePremade.LONGBOXED.getEPType(), SUBTRACT), new SubtractLong());
        computers.put(new MathArithDesc(EPTypePremade.INTEGERBOXED.getEPType(), SUBTRACT), new SubtractInt());
        computers.put(new MathArithDesc(EPTypePremade.BIGDECIMAL.getEPType(), SUBTRACT), new SubtractBigDec());
        computers.put(new MathArithDesc(EPTypePremade.BIGINTEGER.getEPType(), SUBTRACT), new SubtractBigInt());
        computers.put(new MathArithDesc(EPTypePremade.DOUBLEBOXED.getEPType(), MULTIPLY), new MultiplyDouble());
        computers.put(new MathArithDesc(EPTypePremade.FLOATBOXED.getEPType(), MULTIPLY), new MultiplyFloat());
        computers.put(new MathArithDesc(EPTypePremade.LONGBOXED.getEPType(), MULTIPLY), new MultiplyLong());
        computers.put(new MathArithDesc(EPTypePremade.INTEGERBOXED.getEPType(), MULTIPLY), new MultiplyInt());
        computers.put(new MathArithDesc(EPTypePremade.BIGDECIMAL.getEPType(), MULTIPLY), new MultiplyBigDec());
        computers.put(new MathArithDesc(EPTypePremade.BIGINTEGER.getEPType(), MULTIPLY), new MultiplyBigInt());
        computers.put(new MathArithDesc(EPTypePremade.DOUBLEBOXED.getEPType(), MODULO), new ModuloDouble());
        computers.put(new MathArithDesc(EPTypePremade.FLOATBOXED.getEPType(), MODULO), new ModuloFloat());
        computers.put(new MathArithDesc(EPTypePremade.LONGBOXED.getEPType(), MODULO), new ModuloLong());
        computers.put(new MathArithDesc(EPTypePremade.INTEGERBOXED.getEPType(), MODULO), new ModuloInt());
        computers.put(new MathArithDesc(EPTypePremade.BIGDECIMAL.getEPType(), MODULO), new ModuloDouble());
        computers.put(new MathArithDesc(EPTypePremade.BIGINTEGER.getEPType(), MODULO), new ModuloLong());
    }

    public static interface Computer {
        public Number compute(Number var1, Number var2);

        public CodegenExpression codegen(CodegenMethodScope var1, CodegenClassScope var2, CodegenExpressionRef var3, CodegenExpressionRef var4, EPTypeClass var5, EPTypeClass var6);
    }

    public static class MathArithDesc {
        private final EPTypeClass type;
        private final MathArithTypeEnum arith;

        public MathArithDesc(EPTypeClass type, MathArithTypeEnum arith) {
            this.type = type;
            this.arith = arith;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MathArithDesc that = (MathArithDesc)o;
            if (!this.type.equals(that.type)) {
                return false;
            }
            return this.arith == that.arith;
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + this.arith.hashCode();
            return result;
        }
    }

    public static class DivideDouble
    implements Computer {
        private final boolean divisionByZeroReturnsNull;

        DivideDouble(boolean divisionByZeroReturnsNull) {
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            double d2Double = d2.doubleValue();
            if (this.divisionByZeroReturnsNull && d2Double == 0.0) {
                return null;
            }
            return d1.doubleValue() / d2Double;
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            if (!this.divisionByZeroReturnsNull) {
                return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsDouble(left, ltype), "/", MathArithTypeEnum.codegenAsDouble(right, rtype));
            }
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.DOUBLEBOXED.getEPType(), DivideDouble.class, (CodegenScope)codegenClassScope).addParam(ltype, "d1").addParam(rtype, "d2").getBlock().declareVar(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), "d2Double", MathArithTypeEnum.codegenAsDouble(CodegenExpressionBuilder.ref("d2"), rtype)).ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("d2Double"), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsDouble(CodegenExpressionBuilder.ref("d1"), ltype), "/", CodegenExpressionBuilder.ref("d2Double")));
            return CodegenExpressionBuilder.localMethodBuild(method).pass(left).pass(right).call();
        }
    }

    public static class DivideFloat
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            float d2Float = d2.floatValue();
            if (d2Float == 0.0f) {
                return null;
            }
            return Float.valueOf(d1.floatValue() / d2Float);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsFloat(left, ltype), "/", MathArithTypeEnum.codegenAsFloat(right, rtype));
        }
    }

    public static class DivideLong
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            long d2Long = d2.longValue();
            if (d2Long == 0L) {
                return null;
            }
            return d1.longValue() / d2Long;
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsLong(left, ltype), "/", MathArithTypeEnum.codegenAsLong(right, rtype));
        }
    }

    public static class DivideInt
    implements Computer {
        @Override
        public Number compute(Number i1, Number i2) {
            int i2int = i2.intValue();
            if (i2int == 0) {
                return null;
            }
            return i1.intValue() / i2int;
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.INTEGERBOXED.getEPType(), DivideInt.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "i1").addParam(EPTypePremade.INTEGERPRIMITIVE.getEPType(), "i2").getBlock().ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.ref("i2"), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.op(CodegenExpressionBuilder.ref("i1"), "/", CodegenExpressionBuilder.ref("i2")));
            return CodegenExpressionBuilder.localMethod(method, MathArithTypeEnum.codegenAsInt(left, ltype), MathArithTypeEnum.codegenAsInt(right, rtype));
        }
    }

    public static class DivideBigDecWMathContext
    implements Computer {
        private final boolean divisionByZeroReturnsNull;
        private final MathContext mathContext;

        DivideBigDecWMathContext(boolean divisionByZeroReturnsNull, MathContext mathContext) {
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
            this.mathContext = mathContext;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            if (b2.doubleValue() == 0.0) {
                if (this.divisionByZeroReturnsNull) {
                    return null;
                }
                double result = b1.doubleValue() / 0.0;
                return new BigDecimal(result);
            }
            return b1.divide(b2, this.mathContext);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenExpressionField math = codegenClassScope.addOrGetFieldSharable(new MathContextCodegenField(this.mathContext));
            CodegenBlock block = codegenMethodScope.makeChild(EPTypePremade.BIGDECIMAL.getEPType(), DivideBigDecWMathContext.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.BIGDECIMAL.getEPType(), "b1").addParam(EPTypePremade.BIGDECIMAL.getEPType(), "b2").getBlock();
            CodegenBlock ifZero = block.ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("b2"), "doubleValue", new CodegenExpression[0]), CodegenExpressionBuilder.constant(0)));
            if (this.divisionByZeroReturnsNull) {
                ifZero.blockReturn(CodegenExpressionBuilder.constantNull());
            } else {
                ifZero.blockReturn(CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.op(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("b1"), "doubleValue", new CodegenExpression[0]), "/", CodegenExpressionBuilder.constant(0))));
            }
            CodegenMethod method = block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("b1"), "divide", CodegenExpressionBuilder.ref("b2"), math));
            return CodegenExpressionBuilder.localMethod(method, left, right);
        }
    }

    public static class DivideBigDec
    implements Computer {
        private final boolean divisionByZeroReturnsNull;

        DivideBigDec(boolean divisionByZeroReturnsNull) {
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            if (b2.doubleValue() == 0.0) {
                if (this.divisionByZeroReturnsNull) {
                    return null;
                }
                double result = b1.doubleValue() / 0.0;
                return new BigDecimal(result);
            }
            return b1.divide(b2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenBlock block = codegenMethodScope.makeChild(EPTypePremade.BIGDECIMAL.getEPType(), DivideBigDec.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.BIGDECIMAL.getEPType(), "b1").addParam(EPTypePremade.BIGDECIMAL.getEPType(), "b2").getBlock();
            CodegenBlock ifBlock = block.ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("b1"), "doubleValue", new CodegenExpression[0]), CodegenExpressionBuilder.constant(0.0)));
            if (this.divisionByZeroReturnsNull) {
                ifBlock.blockReturn(CodegenExpressionBuilder.constantNull());
            } else {
                ifBlock.blockReturn(CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.op(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("b1"), "doubleValue", new CodegenExpression[0]), "/", CodegenExpressionBuilder.constant(0.0))));
            }
            CodegenMethod method = block.methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("b1"), "divide", CodegenExpressionBuilder.ref("b2")));
            return CodegenExpressionBuilder.localMethod(method, left, right);
        }
    }

    public static class AddBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        AddBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal s1 = this.convOne.coerceBoxedBigDec(d1);
            BigDecimal s2 = this.convTwo.coerceBoxedBigDec(d2);
            return s1.add(s2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenExpression leftAsBig = this.convOne.coerceBoxedBigDecCodegen(left, ltype);
            CodegenExpression rightAsBig = this.convTwo.coerceBoxedBigDecCodegen(right, rtype);
            return CodegenExpressionBuilder.exprDotMethod(leftAsBig, "add", rightAsBig);
        }
    }

    public static class SubtractBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        SubtractBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal s1 = this.convOne.coerceBoxedBigDec(d1);
            BigDecimal s2 = this.convTwo.coerceBoxedBigDec(d2);
            return s1.subtract(s2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.BIGDECIMAL.getEPType(), SubtractBigDecConvComputer.class, (CodegenScope)codegenClassScope).addParam(ltype, "d1").addParam(rtype, "d2").getBlock().declareVar(EPTypePremade.BIGDECIMAL.getEPType(), "s1", this.convOne.coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref("d1"), ltype)).declareVar(EPTypePremade.BIGDECIMAL.getEPType(), "s2", this.convTwo.coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref("d2"), rtype)).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("s1"), "subtract", CodegenExpressionBuilder.ref("s2")));
            return CodegenExpressionBuilder.localMethodBuild(method).pass(left).pass(right).call();
        }
    }

    public static class MultiplyBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        MultiplyBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal s1 = this.convOne.coerceBoxedBigDec(d1);
            BigDecimal s2 = this.convTwo.coerceBoxedBigDec(d2);
            return s1.multiply(s2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.BIGDECIMAL.getEPType(), MultiplyBigDecConvComputer.class, (CodegenScope)codegenClassScope).addParam(ltype, "d1").addParam(rtype, "d2").getBlock().declareVar(EPTypePremade.BIGDECIMAL.getEPType(), "s1", this.convOne.coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref("d1"), ltype)).declareVar(EPTypePremade.BIGDECIMAL.getEPType(), "s2", this.convTwo.coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref("d2"), rtype)).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("s1"), "multiply", CodegenExpressionBuilder.ref("s2")));
            return CodegenExpressionBuilder.localMethodBuild(method).pass(left).pass(right).call();
        }
    }

    public static class DivideBigDecConvComputerNoMathCtx
    extends DivideBigDecConvComputerBase {
        DivideBigDecConvComputerNoMathCtx(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo, boolean divisionByZeroReturnsNull) {
            super(convOne, convTwo, divisionByZeroReturnsNull);
        }

        @Override
        public Number doDivide(BigDecimal s1, BigDecimal s2) {
            return s1.divide(s2);
        }

        @Override
        public CodegenExpression doDivideCodegen(CodegenExpressionRef s1, CodegenExpressionRef s2, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.exprDotMethod(s1, "divide", s2);
        }
    }

    public static class DivideBigDecConvComputerWithMathCtx
    extends DivideBigDecConvComputerBase {
        private final MathContext mathContext;

        DivideBigDecConvComputerWithMathCtx(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo, boolean divisionByZeroReturnsNull, MathContext mathContext) {
            super(convOne, convTwo, divisionByZeroReturnsNull);
            this.mathContext = mathContext;
        }

        @Override
        public Number doDivide(BigDecimal s1, BigDecimal s2) {
            return s1.divide(s2, this.mathContext);
        }

        @Override
        public CodegenExpression doDivideCodegen(CodegenExpressionRef s1, CodegenExpressionRef s2, CodegenClassScope codegenClassScope) {
            CodegenExpressionField math = codegenClassScope.addOrGetFieldSharable(new MathContextCodegenField(this.mathContext));
            return CodegenExpressionBuilder.exprDotMethod(s1, "divide", s2, math);
        }
    }

    public static class ModuloDouble
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() % d2.doubleValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsDouble(left, ltype), "%", MathArithTypeEnum.codegenAsDouble(right, rtype));
        }
    }

    public static class AddBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        AddBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigInteger s1 = this.convOne.coerceBoxedBigInt(d1);
            BigInteger s2 = this.convTwo.coerceBoxedBigInt(d2);
            return s1.add(s2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenExpression leftAsBig = this.convOne.coerceBoxedBigIntCodegen(left, ltype);
            CodegenExpression rightAsBig = this.convTwo.coerceBoxedBigIntCodegen(right, rtype);
            return CodegenExpressionBuilder.exprDotMethod(leftAsBig, "add", rightAsBig);
        }
    }

    public static class SubtractBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        SubtractBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigInteger s1 = this.convOne.coerceBoxedBigInt(d1);
            BigInteger s2 = this.convTwo.coerceBoxedBigInt(d2);
            return s1.subtract(s2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenExpression leftAsBig = this.convOne.coerceBoxedBigIntCodegen(left, ltype);
            CodegenExpression rightAsBig = this.convTwo.coerceBoxedBigIntCodegen(right, rtype);
            return CodegenExpressionBuilder.exprDotMethod(leftAsBig, "subtract", rightAsBig);
        }
    }

    public static class MultiplyBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        MultiplyBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigInteger s1 = this.convOne.coerceBoxedBigInt(d1);
            BigInteger s2 = this.convTwo.coerceBoxedBigInt(d2);
            return s1.multiply(s2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenExpression leftAsBig = this.convOne.coerceBoxedBigIntCodegen(left, ltype);
            CodegenExpression rightAsBig = this.convTwo.coerceBoxedBigIntCodegen(right, rtype);
            return CodegenExpressionBuilder.exprDotMethod(leftAsBig, "multiply", rightAsBig);
        }
    }

    public static class DivideBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        DivideBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigInteger s1 = this.convOne.coerceBoxedBigInt(d1);
            BigInteger s2 = this.convTwo.coerceBoxedBigInt(d2);
            if (s2.doubleValue() == 0.0) {
                return null;
            }
            return s1.divide(s2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.BIGINTEGER.getEPType(), DivideBigIntConvComputer.class, (CodegenScope)codegenClassScope).addParam(ltype, "d1").addParam(rtype, "d2").getBlock().declareVar(EPTypePremade.BIGINTEGER.getEPType(), "s1", this.convOne.coerceBoxedBigIntCodegen(CodegenExpressionBuilder.ref("d1"), ltype)).declareVar(EPTypePremade.BIGINTEGER.getEPType(), "s2", this.convTwo.coerceBoxedBigIntCodegen(CodegenExpressionBuilder.ref("d2"), rtype)).ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("s2"), "doubleValue", new CodegenExpression[0]), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("s1"), "divide", CodegenExpressionBuilder.ref("s2")));
            return CodegenExpressionBuilder.localMethodBuild(method).pass(left).pass(right).call();
        }
    }

    public static class ModuloLong
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.longValue() % d2.longValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsLong(left, ltype), "%", MathArithTypeEnum.codegenAsLong(right, rtype));
        }
    }

    public static class AddDouble
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() + d2.doubleValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsDouble(left, ltype), "+", MathArithTypeEnum.codegenAsDouble(right, rtype));
        }
    }

    public static class AddFloat
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() + d2.floatValue());
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsFloat(left, ltype), "+", MathArithTypeEnum.codegenAsFloat(right, rtype));
        }
    }

    public static class AddLong
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.longValue() + d2.longValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsLong(left, ltype), "+", MathArithTypeEnum.codegenAsLong(right, rtype));
        }
    }

    public static class AddInt
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.intValue() + d2.intValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsInt(left, ltype), "+", MathArithTypeEnum.codegenAsInt(right, rtype));
        }
    }

    public static class AddBigDec
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            return b1.add(b2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.exprDotMethod(left, "add", right);
        }
    }

    public static class AddBigInt
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            BigInteger b1 = (BigInteger)d1;
            BigInteger b2 = (BigInteger)d2;
            return b1.add(b2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.exprDotMethod(left, "add", right);
        }
    }

    public static class SubtractDouble
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() - d2.doubleValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsDouble(left, ltype), "-", MathArithTypeEnum.codegenAsDouble(right, rtype));
        }
    }

    public static class SubtractFloat
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() - d2.floatValue());
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsFloat(left, ltype), "-", MathArithTypeEnum.codegenAsFloat(right, rtype));
        }
    }

    public static class SubtractLong
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.longValue() - d2.longValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsLong(left, ltype), "-", MathArithTypeEnum.codegenAsLong(right, rtype));
        }
    }

    public static class SubtractInt
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.intValue() - d2.intValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsInt(left, ltype), "-", MathArithTypeEnum.codegenAsInt(right, rtype));
        }
    }

    public static class SubtractBigDec
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            return b1.subtract(b2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.exprDotMethod(left, "subtract", right);
        }
    }

    public static class SubtractBigInt
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            BigInteger b1 = (BigInteger)d1;
            BigInteger b2 = (BigInteger)d2;
            return b1.subtract(b2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.exprDotMethod(left, "subtract", right);
        }
    }

    public static class MultiplyDouble
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() * d2.doubleValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsDouble(left, ltype), "*", MathArithTypeEnum.codegenAsDouble(right, rtype));
        }
    }

    public static class MultiplyFloat
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() * d2.floatValue());
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsFloat(left, ltype), "*", MathArithTypeEnum.codegenAsFloat(right, rtype));
        }
    }

    public static class MultiplyLong
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.longValue() * d2.longValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsLong(left, ltype), "*", MathArithTypeEnum.codegenAsLong(right, rtype));
        }
    }

    public static class MultiplyInt
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.intValue() * d2.intValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsInt(left, ltype), "*", MathArithTypeEnum.codegenAsInt(right, rtype));
        }
    }

    public static class MultiplyBigDec
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            return b1.multiply(b2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.exprDotMethod(left, "multiply", right);
        }
    }

    public static class MultiplyBigInt
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            BigInteger b1 = (BigInteger)d1;
            BigInteger b2 = (BigInteger)d2;
            return b1.multiply(b2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.exprDotMethod(left, "multiply", right);
        }
    }

    public static class ModuloFloat
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() % d2.floatValue());
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsFloat(left, ltype), "%", MathArithTypeEnum.codegenAsFloat(right, rtype));
        }
    }

    public static class ModuloInt
    implements Computer {
        @Override
        public Number compute(Number d1, Number d2) {
            return d1.intValue() % d2.intValue();
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            return CodegenExpressionBuilder.op(MathArithTypeEnum.codegenAsInt(left, ltype), "%", MathArithTypeEnum.codegenAsInt(right, rtype));
        }
    }

    public static abstract class DivideBigDecConvComputerBase
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;
        private final boolean divisionByZeroReturnsNull;

        public abstract Number doDivide(BigDecimal var1, BigDecimal var2);

        public abstract CodegenExpression doDivideCodegen(CodegenExpressionRef var1, CodegenExpressionRef var2, CodegenClassScope var3);

        DivideBigDecConvComputerBase(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo, boolean divisionByZeroReturnsNull) {
            this.convOne = convOne;
            this.convTwo = convTwo;
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
        }

        @Override
        public Number compute(Number d1, Number d2) {
            BigDecimal s1 = this.convOne.coerceBoxedBigDec(d1);
            BigDecimal s2 = this.convTwo.coerceBoxedBigDec(d2);
            if (s2.doubleValue() == 0.0) {
                if (this.divisionByZeroReturnsNull) {
                    return null;
                }
                double result = s1.doubleValue() / 0.0;
                return new BigDecimal(result);
            }
            return this.doDivide(s1, s2);
        }

        @Override
        public CodegenExpression codegen(CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope, CodegenExpressionRef left, CodegenExpressionRef right, EPTypeClass ltype, EPTypeClass rtype) {
            CodegenBlock block = codegenMethodScope.makeChild(EPTypePremade.BIGDECIMAL.getEPType(), DivideBigDecConvComputerBase.class, (CodegenScope)codegenClassScope).addParam(ltype, "d1").addParam(rtype, "d2").getBlock().declareVar(EPTypePremade.BIGDECIMAL.getEPType(), "s1", this.convOne.coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref("d1"), ltype)).declareVar(EPTypePremade.BIGDECIMAL.getEPType(), "s2", this.convTwo.coerceBoxedBigDecCodegen(CodegenExpressionBuilder.ref("d2"), rtype));
            CodegenBlock ifZeroDivisor = block.ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("s2"), "doubleValue", new CodegenExpression[0]), CodegenExpressionBuilder.constant(0)));
            if (this.divisionByZeroReturnsNull) {
                ifZeroDivisor.blockReturn(CodegenExpressionBuilder.constantNull());
            } else {
                ifZeroDivisor.declareVar(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), "result", CodegenExpressionBuilder.op(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("s1"), "doubleValue", new CodegenExpression[0]), "/", CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.ref("result")));
            }
            CodegenMethod method = block.methodReturn(this.doDivideCodegen(CodegenExpressionBuilder.ref("s1"), CodegenExpressionBuilder.ref("s2"), codegenClassScope));
            return CodegenExpressionBuilder.localMethodBuild(method).pass(left).pass(right).call();
        }
    }
}

