/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.util.HashableMultiKey;
import com.espertech.esper.common.internal.util.CollectionUtil;
import java.util.Comparator;

public final class ComparatorHashableMultiKey
implements Comparator<HashableMultiKey> {
    private final boolean[] isDescendingValues;

    public ComparatorHashableMultiKey(boolean[] isDescendingValues) {
        this.isDescendingValues = isDescendingValues;
    }

    @Override
    public final int compare(HashableMultiKey firstValues, HashableMultiKey secondValues) {
        if (firstValues.size() != this.isDescendingValues.length || secondValues.size() != this.isDescendingValues.length) {
            throw new IllegalArgumentException("Incompatible size MultiKey sizes for comparison");
        }
        for (int i = 0; i < firstValues.size(); ++i) {
            boolean isDescending;
            Object valueTwo;
            Object valueOne = firstValues.get(i);
            int comparisonResult = CollectionUtil.compareValues(valueOne, valueTwo = secondValues.get(i), isDescending = this.isDescendingValues[i]);
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        if (!firstValues.equals(secondValues)) {
            return -1;
        }
        return 0;
    }
}

