/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.DatabaseTypeBinding;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum DatabaseTypeEnum {
    String(String.class),
    BigDecimal(BigDecimal.class),
    Boolean(Boolean.class),
    Byte(Byte.class),
    Short(Short.class),
    Int(Integer.class),
    Long(Long.class),
    Float(Float.class),
    Double(Double.class),
    ByteArray(byte[].class),
    SqlDate(Date.class),
    SqlTime(Time.class),
    SqlTimestamp(Timestamp.class);

    private Class javaClass;
    private static Map<DatabaseTypeEnum, DatabaseTypeBinding> bindings;

    private DatabaseTypeEnum(Class javaClass) {
        this.javaClass = javaClass;
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public static DatabaseTypeEnum getEnum(String type) {
        String boxedType = JavaClassHelper.getBoxedClassName(type);
        for (DatabaseTypeEnum val : DatabaseTypeEnum.values()) {
            if (val.toString().toLowerCase(Locale.ENGLISH).equals(type.toLowerCase(Locale.ENGLISH))) {
                return val;
            }
            if (val.getJavaClass().getName().toLowerCase(Locale.ENGLISH).equals(type.toLowerCase(Locale.ENGLISH))) {
                return val;
            }
            if (val.getJavaClass().getName().toLowerCase(Locale.ENGLISH).equals(boxedType)) {
                return val;
            }
            if (!val.getJavaClass().getSimpleName().toLowerCase(Locale.ENGLISH).equals(boxedType)) continue;
            return val;
        }
        return null;
    }

    public DatabaseTypeBinding getBinding() {
        return bindings.get((Object)this);
    }

    static {
        bindings = new HashMap<DatabaseTypeEnum, DatabaseTypeBinding>();
        bindings.put(String, DatabaseTypeBindingString.INSTANCE);
        bindings.put(BigDecimal, DatabaseTypeBindingBigDecimal.INSTANCE);
        bindings.put(Boolean, DatabaseTypeBindingBoolean.INSTANCE);
        bindings.put(Byte, DatabaseTypeBindingByte.INSTANCE);
        bindings.put(ByteArray, DatabaseTypeBindingByteArray.INSTANCE);
        bindings.put(Double, DatabaseTypeBindingDouble.INSTANCE);
        bindings.put(Float, DatabaseTypeBindingFloat.INSTANCE);
        bindings.put(Int, DatabaseTypeBindingInt.INSTANCE);
        bindings.put(Long, DatabaseTypeBindingLong.INSTANCE);
        bindings.put(Short, DatabaseTypeBindingShort.INSTANCE);
        bindings.put(SqlDate, DatabaseTypeBindingSqlDate.INSTANCE);
        bindings.put(SqlTime, DatabaseTypeBindingSqlTime.INSTANCE);
        bindings.put(SqlTimestamp, DatabaseTypeBindingSqlTimestamp.INSTANCE);
    }

    public static class DatabaseTypeBindingString
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingString INSTANCE = new DatabaseTypeBindingString();
        private static final long serialVersionUID = -3831364370730920000L;

        private DatabaseTypeBindingString() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getString(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.STRING.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingBigDecimal
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingBigDecimal INSTANCE = new DatabaseTypeBindingBigDecimal();
        private static final long serialVersionUID = 7936793469129113188L;

        private DatabaseTypeBindingBigDecimal() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getBigDecimal(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.BIGDECIMAL.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingBoolean
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingBoolean INSTANCE = new DatabaseTypeBindingBoolean();
        private static final long serialVersionUID = 2011917861145281792L;

        private DatabaseTypeBindingBoolean() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getBoolean(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.BOOLEANBOXED.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingByte
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingByte INSTANCE = new DatabaseTypeBindingByte();
        private static final long serialVersionUID = -4384419006649960382L;

        private DatabaseTypeBindingByte() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getByte(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.BYTEBOXED.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingByteArray
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingByteArray INSTANCE = new DatabaseTypeBindingByteArray();
        private static final long serialVersionUID = -3021791118652285417L;

        private DatabaseTypeBindingByteArray() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getBytes(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.BYTEPRIMITIVEARRAY.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingDouble
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingDouble INSTANCE = new DatabaseTypeBindingDouble();
        private static final long serialVersionUID = 5260960578225698141L;

        private DatabaseTypeBindingDouble() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getDouble(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingFloat
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingFloat INSTANCE = new DatabaseTypeBindingFloat();
        private static final long serialVersionUID = -6368364148039830269L;

        private DatabaseTypeBindingFloat() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return java.lang.Float.valueOf(resultSet.getFloat(columnName));
        }

        @Override
        public EPType getType() {
            return EPTypePremade.FLOATBOXED.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingInt
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingInt INSTANCE = new DatabaseTypeBindingInt();
        private static final long serialVersionUID = -1781602056657894856L;

        private DatabaseTypeBindingInt() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getInt(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.INTEGERBOXED.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingLong
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingLong INSTANCE = new DatabaseTypeBindingLong();
        private static final long serialVersionUID = -2540462063946936850L;

        private DatabaseTypeBindingLong() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getLong(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.LONGBOXED.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingShort
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingShort INSTANCE = new DatabaseTypeBindingShort();
        private static final long serialVersionUID = -4696766274483402031L;

        private DatabaseTypeBindingShort() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getShort(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.SHORTBOXED.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingSqlDate
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingSqlDate INSTANCE = new DatabaseTypeBindingSqlDate();
        private static final long serialVersionUID = 8886935241855230262L;

        private DatabaseTypeBindingSqlDate() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getDate(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.SQLDATE.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingSqlTime
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingSqlTime INSTANCE = new DatabaseTypeBindingSqlTime();
        private static final long serialVersionUID = -9004717069396381416L;

        private DatabaseTypeBindingSqlTime() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getTime(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.SQLTIME.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }

    public static class DatabaseTypeBindingSqlTimestamp
    implements DatabaseTypeBinding {
        public static final DatabaseTypeBindingSqlTimestamp INSTANCE = new DatabaseTypeBindingSqlTimestamp();
        private static final long serialVersionUID = 4287456701361551857L;

        private DatabaseTypeBindingSqlTimestamp() {
        }

        @Override
        public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
            return resultSet.getTimestamp(columnName);
        }

        @Override
        public EPType getType() {
            return EPTypePremade.SQLTIMESTAMP.getEPType();
        }

        @Override
        public CodegenExpression make() {
            return CodegenExpressionBuilder.publicConstValue(this.getClass(), "INSTANCE");
        }
    }
}

