/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.client.util.ClassForNameProvider;
import com.espertech.esper.common.internal.util.ClassHelperGenericType;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SQLTypeMapUtil {
    private static Map<String, Integer> sqlTypeMap = new HashMap<String, Integer>();

    public static EPType sqlTypeToClass(int sqlType, String className, ClassForNameProvider classForNameProvider) {
        if (sqlType == 16 || sqlType == -7) {
            return EPTypePremade.BOOLEANBOXED.getEPType();
        }
        if (sqlType == 1 || sqlType == 12 || sqlType == -1) {
            return EPTypePremade.STRING.getEPType();
        }
        if (sqlType == 8 || sqlType == 6) {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }
        if (sqlType == 7) {
            return EPTypePremade.FLOATBOXED.getEPType();
        }
        if (sqlType == 4) {
            return EPTypePremade.INTEGERBOXED.getEPType();
        }
        if (sqlType == -5) {
            return EPTypePremade.LONGBOXED.getEPType();
        }
        if (sqlType == -6) {
            return EPTypePremade.BYTEBOXED.getEPType();
        }
        if (sqlType == 5) {
            return EPTypePremade.SHORTBOXED.getEPType();
        }
        if (sqlType == 2 || sqlType == 3) {
            return EPTypePremade.BIGDECIMAL.getEPType();
        }
        if (sqlType == -2 || sqlType == -3 || sqlType == -4) {
            return EPTypePremade.BYTEPRIMITIVEARRAY.getEPType();
        }
        if (sqlType == 91) {
            return EPTypePremade.SQLDATE.getEPType();
        }
        if (sqlType == 92) {
            return EPTypePremade.SQLTIME.getEPType();
        }
        if (sqlType == 93) {
            return EPTypePremade.SQLTIMESTAMP.getEPType();
        }
        if (sqlType == 2005) {
            return EPTypePremade.SQLCLOB.getEPType();
        }
        if (sqlType == 2004) {
            return EPTypePremade.SQLBLOB.getEPType();
        }
        if (sqlType == 2003) {
            return EPTypePremade.SQLARRAY.getEPType();
        }
        if (sqlType == 2002) {
            return EPTypePremade.SQLSTRUCT.getEPType();
        }
        if (sqlType == 2006) {
            return EPTypePremade.SQLREF.getEPType();
        }
        if (sqlType == 70) {
            return EPTypePremade.NETURL.getEPType();
        }
        if (sqlType == 2000 || sqlType == 2001) {
            if (className == null) {
                throw new IllegalArgumentException("No class supplied for sql type " + sqlType);
            }
            try {
                Class clazz = classForNameProvider.classForName(className);
                return ClassHelperGenericType.getClassEPType(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot load class for sql type " + sqlType + " and class " + className);
            }
        }
        if (sqlType == 0) {
            return EPTypeNull.INSTANCE;
        }
        throw new IllegalArgumentException("Cannot map java.sql.Types type " + sqlType);
    }

    public static int getSQLTypeByName(String type) {
        Integer val = sqlTypeMap.get(type.toUpperCase(Locale.ENGLISH));
        if (val != null) {
            return val;
        }
        throw new RuntimeException("Type by name '" + type + "' is not a recognized java.sql.Types type");
    }

    static {
        sqlTypeMap.put("BIT", -7);
        sqlTypeMap.put("TINYINT", -6);
        sqlTypeMap.put("SMALLINT", 5);
        sqlTypeMap.put("INTEGER", 4);
        sqlTypeMap.put("BIGINT", -5);
        sqlTypeMap.put("FLOAT", 6);
        sqlTypeMap.put("REAL", 7);
        sqlTypeMap.put("DOUBLE", 8);
        sqlTypeMap.put("NUMERIC", 2);
        sqlTypeMap.put("DECIMAL", 3);
        sqlTypeMap.put("CHAR", 1);
        sqlTypeMap.put("VARCHAR", 12);
        sqlTypeMap.put("LONGVARCHAR", -1);
        sqlTypeMap.put("DATE", 91);
        sqlTypeMap.put("TIME", 92);
        sqlTypeMap.put("TIMESTAMP", 93);
        sqlTypeMap.put("BINARY", -2);
        sqlTypeMap.put("VARBINARY", -3);
        sqlTypeMap.put("LONGVARBINARY", -4);
        sqlTypeMap.put("NULL", 0);
        sqlTypeMap.put("OTHER", 1111);
        sqlTypeMap.put("JAVA_OBJECT", 2000);
        sqlTypeMap.put("DISTINCT", 2001);
        sqlTypeMap.put("STRUCT", 2002);
        sqlTypeMap.put("ARRAY", 2003);
        sqlTypeMap.put("BLOB", 2004);
        sqlTypeMap.put("CLOB", 2005);
        sqlTypeMap.put("REF", 2006);
        sqlTypeMap.put("DATALINK", 70);
        sqlTypeMap.put("BOOLEAN", 16);
    }
}

