/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.common.internal.util.SimpleNumberCoercer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SimpleNumberCoercerFactory {
    public static SimpleNumberBigDecimalCoercer getCoercerBigDecimal(EPTypeClass fromType) {
        if (fromType.getType() == BigDecimal.class) {
            return SimpleNumberCoercerBigDecNull.INSTANCE;
        }
        if (JavaClassHelper.isFloatingPointClass(fromType)) {
            return SimpleNumberCoercerBigDecDouble.INSTANCE;
        }
        return SimpleNumberCoercerBigDecLong.INSTANCE;
    }

    public static SimpleNumberBigIntegerCoercer getCoercerBigInteger(EPTypeClass fromType) {
        if (fromType.getType() == BigInteger.class) {
            return SimpleNumberCoercerBigIntNull.INSTANCE;
        }
        return SimpleNumberCoercerBigInt.INSTANCE;
    }

    public static SimpleNumberCoercer getCoercer(EPType fromType, EPTypeClass resultBoxed) {
        if (fromType != null && fromType.equals(resultBoxed)) {
            return SimpleNumberCoercerNull.INSTANCE;
        }
        if (fromType instanceof EPTypeClass && resultBoxed.getType() == ((EPTypeClass)fromType).getType()) {
            return SimpleNumberCoercerNull.INSTANCE;
        }
        Class<?> resultBoxedType = resultBoxed.getType();
        if (resultBoxedType == Double.class) {
            return SimpleNumberCoercerDouble.INSTANCE;
        }
        if (resultBoxedType == Long.class) {
            return SimpleNumberCoercerLong.INSTANCE;
        }
        if (resultBoxedType == Float.class) {
            return SimpleNumberCoercerFloat.INSTANCE;
        }
        if (resultBoxedType == Integer.class) {
            return SimpleNumberCoercerInt.INSTANCE;
        }
        if (resultBoxedType == Short.class) {
            return SimpleNumberCoercerShort.INSTANCE;
        }
        if (resultBoxedType == Byte.class) {
            return SimpleNumberCoercerByte.INSTANCE;
        }
        if (resultBoxedType == BigInteger.class) {
            return SimpleNumberCoercerBigInt.INSTANCE;
        }
        if (resultBoxedType == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointClass(fromType)) {
                return SimpleNumberCoercerBigDecDouble.INSTANCE;
            }
            return SimpleNumberCoercerBigDecLong.INSTANCE;
        }
        if (resultBoxedType == Object.class || resultBoxedType == Number.class) {
            return SimpleNumberCoercerNull.INSTANCE;
        }
        throw new IllegalArgumentException("Cannot coerce to number subtype " + resultBoxedType.getName());
    }

    private static CodegenExpression codegenCoerceNonNull(EPTypeClass primitive, EPTypeClass boxed, String numberValueMethodName, CodegenExpression param, EPType type) {
        if (type == null || type == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constantNull();
        }
        EPTypeClass clazz = (EPTypeClass)type;
        if (clazz.equals(primitive) || clazz.equals(boxed)) {
            return param;
        }
        if (clazz.getType().isPrimitive()) {
            return CodegenExpressionBuilder.cast(primitive, param);
        }
        return CodegenExpressionBuilder.exprDotMethod(param, numberValueMethodName, new CodegenExpression[0]);
    }

    private static CodegenExpression codegenCoerceMayNull(EPTypeClass primitive, EPTypeClass boxed, String numberValueMethodName, CodegenExpression param, EPType type, CodegenMethodScope codegenMethodScope, Class generator, CodegenClassScope codegenClassScope) {
        if (type == null || type == EPTypeNull.INSTANCE) {
            return CodegenExpressionBuilder.constantNull();
        }
        EPTypeClass clazz = (EPTypeClass)type;
        if (clazz.equals(primitive) || clazz.equals(boxed)) {
            return param;
        }
        if (clazz.getType().isPrimitive()) {
            return CodegenExpressionBuilder.cast(primitive, param);
        }
        CodegenMethod method = codegenMethodScope.makeChild(boxed, generator, (CodegenScope)codegenClassScope).addParam(clazz, "value").getBlock().ifRefNullReturnNull("value").methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), numberValueMethodName, new CodegenExpression[0]));
        return CodegenExpressionBuilder.localMethod(method, param);
    }

    private static class SimpleNumberCoercerBigDecNull
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        public static final SimpleNumberCoercerBigDecNull INSTANCE = new SimpleNumberCoercerBigDecNull();

        private SimpleNumberCoercerBigDecNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return (BigDecimal)numToCoerce;
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.NUMBER.getEPType();
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return value;
        }

        @Override
        public CodegenExpression coerceBoxedBigDecCodegen(CodegenExpression expr, EPTypeClass type) {
            return expr;
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return value;
        }
    }

    public static class SimpleNumberCoercerBigDecDouble
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        public static final SimpleNumberCoercerBigDecDouble INSTANCE = new SimpleNumberCoercerBigDecDouble();

        private SimpleNumberCoercerBigDecDouble() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return new BigDecimal(numToCoerce.doubleValue());
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return new BigDecimal(numToCoerce.doubleValue());
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerBigDecDouble.codegenBigDec(value, valueType);
        }

        @Override
        public CodegenExpression coerceBoxedBigDecCodegen(CodegenExpression expr, EPTypeClass type) {
            return this.coerceCodegen(expr, type);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (valueTypeMustNumeric == null || valueTypeMustNumeric == EPTypeNull.INSTANCE) {
                return value;
            }
            EPTypeClass clazz = (EPTypeClass)valueTypeMustNumeric;
            if (clazz.getType().isPrimitive()) {
                return SimpleNumberCoercerBigDecDouble.codegenBigDec(value, clazz);
            }
            if (clazz.getType() == BigDecimal.class) {
                return value;
            }
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.BIGDECIMAL.getEPType(), SimpleNumberCoercerBigDecDouble.class, (CodegenScope)codegenClassScope).addParam(clazz, "value").getBlock().ifRefNullReturnNull("value").methodReturn(SimpleNumberCoercerBigDecDouble.codegenBigDec(CodegenExpressionBuilder.ref("value"), clazz));
            return CodegenExpressionBuilder.localMethod(method, value);
        }

        public static CodegenExpression codegenBigDec(CodegenExpression value, EPTypeClass valueType) {
            if (valueType.getType() == BigDecimal.class) {
                return value;
            }
            if (valueType.getType() == Double.TYPE || valueType.getType() == Double.class) {
                return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), value);
            }
            if (valueType.getType().isPrimitive()) {
                return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.cast(EPTypePremade.DOUBLEBOXED.getEPType(), value));
            }
            return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.exprDotMethod(value, "doubleValue", new CodegenExpression[0]));
        }
    }

    public static class SimpleNumberCoercerBigDecLong
    implements SimpleNumberCoercer,
    SimpleNumberBigDecimalCoercer {
        public static final SimpleNumberCoercerBigDecLong INSTANCE = new SimpleNumberCoercerBigDecLong();

        private SimpleNumberCoercerBigDecLong() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return new BigDecimal(numToCoerce.longValue());
        }

        @Override
        public BigDecimal coerceBoxedBigDec(Number numToCoerce) {
            return new BigDecimal(numToCoerce.longValue());
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.LONGBOXED.getEPType();
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerBigDecLong.codegenBigDec(value, valueType);
        }

        @Override
        public CodegenExpression coerceBoxedBigDecCodegen(CodegenExpression expr, EPTypeClass type) {
            return this.coerceCodegen(expr, type);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (valueTypeMustNumeric == null || valueTypeMustNumeric == EPTypeNull.INSTANCE) {
                return value;
            }
            EPTypeClass clazz = (EPTypeClass)valueTypeMustNumeric;
            if (clazz.getType().isPrimitive()) {
                return SimpleNumberCoercerBigDecLong.codegenBigDec(value, clazz);
            }
            if (clazz.getType() == BigDecimal.class) {
                return value;
            }
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.BIGDECIMAL.getEPType(), SimpleNumberCoercerBigDecLong.class, (CodegenScope)codegenClassScope).addParam(clazz, "value").getBlock().ifRefNullReturnNull("value").methodReturn(SimpleNumberCoercerBigDecLong.codegenBigDec(CodegenExpressionBuilder.ref("value"), clazz));
            return CodegenExpressionBuilder.localMethod(method, value);
        }

        public static CodegenExpression codegenBigDec(CodegenExpression value, EPTypeClass valueType) {
            if (valueType.getType() == BigDecimal.class) {
                return value;
            }
            if (valueType.getType() == Long.TYPE || valueType.getType() == Long.class) {
                return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), value);
            }
            if (valueType.getType().isPrimitive()) {
                return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.cast(EPTypePremade.LONGPRIMITIVE.getEPType(), value));
            }
            return CodegenExpressionBuilder.newInstance(EPTypePremade.BIGDECIMAL.getEPType(), CodegenExpressionBuilder.exprDotMethod(value, "longValue", new CodegenExpression[0]));
        }
    }

    private static class SimpleNumberCoercerBigIntNull
    implements SimpleNumberCoercer,
    SimpleNumberBigIntegerCoercer {
        public static final SimpleNumberCoercerBigIntNull INSTANCE = new SimpleNumberCoercerBigIntNull();

        private SimpleNumberCoercerBigIntNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public BigInteger coerceBoxedBigInt(Number numToCoerce) {
            return (BigInteger)numToCoerce;
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.NUMBER.getEPType();
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return value;
        }

        @Override
        public CodegenExpression coerceBoxedBigIntCodegen(CodegenExpression expr, EPTypeClass type) {
            return expr;
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return value;
        }
    }

    public static class SimpleNumberCoercerBigInt
    implements SimpleNumberCoercer,
    SimpleNumberBigIntegerCoercer {
        public static final SimpleNumberCoercerBigInt INSTANCE = new SimpleNumberCoercerBigInt();

        private SimpleNumberCoercerBigInt() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }

        @Override
        public BigInteger coerceBoxedBigInt(Number numToCoerce) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.LONGBOXED.getEPType();
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerBigInt.codegenBigInt(value, valueType);
        }

        @Override
        public CodegenExpression coerceBoxedBigIntCodegen(CodegenExpression expr, EPTypeClass type) {
            return this.coerceCodegen(expr, type);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (valueTypeMustNumeric == null || valueTypeMustNumeric == EPTypeNull.INSTANCE) {
                return value;
            }
            EPTypeClass clazz = (EPTypeClass)valueTypeMustNumeric;
            if (clazz.getType().isPrimitive()) {
                return SimpleNumberCoercerBigInt.codegenBigInt(value, clazz);
            }
            if (clazz.getType() == BigInteger.class) {
                return value;
            }
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.BIGINTEGER.getEPType(), SimpleNumberCoercerBigInt.class, (CodegenScope)codegenClassScope).addParam(clazz, "value").getBlock().ifRefNullReturnNull("value").methodReturn(SimpleNumberCoercerBigInt.codegenBigInt(CodegenExpressionBuilder.ref("value"), clazz));
            return CodegenExpressionBuilder.localMethod(method, value);
        }

        public static CodegenExpression codegenBigInt(CodegenExpression value, EPTypeClass valueType) {
            if (valueType.getType() == BigInteger.class) {
                return value;
            }
            if (valueType.getType() == Long.TYPE || valueType.getType() == Long.class) {
                return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", value);
            }
            if (valueType.getType().isPrimitive()) {
                return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.cast(EPTypePremade.LONGPRIMITIVE.getEPType(), value));
            }
            return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(value, "longValue", new CodegenExpression[0]));
        }
    }

    private static class SimpleNumberCoercerNull
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerNull INSTANCE = new SimpleNumberCoercerNull();

        private SimpleNumberCoercerNull() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce;
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.NUMBER.getEPType();
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return value;
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return value;
        }
    }

    public static class SimpleNumberCoercerDouble
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerDouble INSTANCE = new SimpleNumberCoercerDouble();

        private SimpleNumberCoercerDouble() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.doubleValue();
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.DOUBLEBOXED.getEPType();
        }

        public static CodegenExpression codegenDouble(CodegenExpression param, EPType type) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), EPTypePremade.DOUBLEBOXED.getEPType(), "doubleValue", param, type);
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerDouble.codegenDouble(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression param, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), EPTypePremade.DOUBLEBOXED.getEPType(), "doubleValue", param, valueTypeMustNumeric, codegenMethodScope, SimpleNumberCoercerDouble.class, codegenClassScope);
        }

        public static CodegenExpression codegenDoubleMayNullBoxedIncludeBig(CodegenExpression value, EPTypeClass valueType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (valueType.getType() == BigInteger.class || valueType.getType() == BigDecimal.class) {
                return CodegenExpressionBuilder.exprDotMethod(value, "doubleValue", new CodegenExpression[0]);
            }
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(EPTypePremade.DOUBLEPRIMITIVE.getEPType(), EPTypePremade.DOUBLEBOXED.getEPType(), "doubleValue", value, valueType, codegenMethodScope, SimpleNumberCoercerDouble.class, codegenClassScope);
        }
    }

    public static class SimpleNumberCoercerLong
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerLong INSTANCE = new SimpleNumberCoercerLong();

        private SimpleNumberCoercerLong() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.longValue();
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.LONGBOXED.getEPType();
        }

        public static CodegenExpression codegenLong(CodegenExpression param, EPTypeClass type) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(EPTypePremade.LONGPRIMITIVE.getEPType(), EPTypePremade.LONGBOXED.getEPType(), "longValue", param, type);
        }

        public static CodegenExpression codegenLongMayNullBox(CodegenExpression param, EPType type, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(EPTypePremade.LONGPRIMITIVE.getEPType(), EPTypePremade.LONGBOXED.getEPType(), "longValue", param, type, codegenMethodScope, SimpleNumberCoercerLong.class, codegenClassScope);
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerLong.codegenLong(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression param, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerLong.codegenLongMayNullBox(param, valueTypeMustNumeric, codegenMethodScope, codegenClassScope);
        }
    }

    public static class SimpleNumberCoercerFloat
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerFloat INSTANCE = new SimpleNumberCoercerFloat();

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return Float.valueOf(numToCoerce.floatValue());
        }

        private SimpleNumberCoercerFloat() {
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.FLOATBOXED.getEPType();
        }

        public static CodegenExpression codegenFloat(CodegenExpression ref, EPTypeClass type) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(EPTypePremade.FLOATPRIMITIVE.getEPType(), EPTypePremade.FLOATBOXED.getEPType(), "floatValue", ref, type);
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerFloat.codegenFloat(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(EPTypePremade.FLOATPRIMITIVE.getEPType(), EPTypePremade.FLOATBOXED.getEPType(), "floatValue", value, valueTypeMustNumeric, codegenMethodScope, SimpleNumberCoercerFloat.class, codegenClassScope);
        }
    }

    public static class SimpleNumberCoercerInt
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerInt INSTANCE = new SimpleNumberCoercerInt();

        private SimpleNumberCoercerInt() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.intValue();
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.INTEGERBOXED.getEPType();
        }

        public static CodegenExpression codegenInt(CodegenExpression param, EPTypeClass type) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(EPTypePremade.INTEGERPRIMITIVE.getEPType(), EPTypePremade.INTEGERBOXED.getEPType(), "intValue", param, type);
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerInt.codegenInt(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression param, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(EPTypePremade.INTEGERPRIMITIVE.getEPType(), EPTypePremade.INTEGERBOXED.getEPType(), "intValue", param, valueTypeMustNumeric, codegenMethodScope, SimpleNumberCoercerInt.class, codegenClassScope);
        }

        public static CodegenExpression coerceCodegenMayNull(CodegenExpression param, EPTypeClass type, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(EPTypePremade.INTEGERPRIMITIVE.getEPType(), EPTypePremade.INTEGERBOXED.getEPType(), "intValue", param, type, codegenMethodScope, SimpleNumberCoercerInt.class, codegenClassScope);
        }
    }

    public static class SimpleNumberCoercerShort
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerShort INSTANCE = new SimpleNumberCoercerShort();

        private SimpleNumberCoercerShort() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.shortValue();
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.SHORTBOXED.getEPType();
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerShort.codegenShort(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(EPTypePremade.SHORTPRIMITIVE.getEPType(), EPTypePremade.SHORTBOXED.getEPType(), "shortValue", value, valueTypeMustNumeric, codegenMethodScope, SimpleNumberCoercerShort.class, codegenClassScope);
        }

        public static CodegenExpression codegenShort(CodegenExpression input, EPTypeClass inputType) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(EPTypePremade.SHORTPRIMITIVE.getEPType(), EPTypePremade.SHORTBOXED.getEPType(), "shortValue", input, inputType);
        }
    }

    public static class SimpleNumberCoercerByte
    implements SimpleNumberCoercer {
        public static final SimpleNumberCoercerByte INSTANCE = new SimpleNumberCoercerByte();

        private SimpleNumberCoercerByte() {
        }

        @Override
        public Number coerceBoxed(Number numToCoerce) {
            return numToCoerce.byteValue();
        }

        @Override
        public EPTypeClass getReturnType() {
            return EPTypePremade.BYTEBOXED.getEPType();
        }

        @Override
        public CodegenExpression coerceCodegen(CodegenExpression value, EPTypeClass valueType) {
            return SimpleNumberCoercerByte.codegenByte(value, valueType);
        }

        @Override
        public CodegenExpression coerceCodegenMayNullBoxed(CodegenExpression value, EPType valueTypeMustNumeric, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return SimpleNumberCoercerFactory.codegenCoerceMayNull(EPTypePremade.BYTEPRIMITIVE.getEPType(), EPTypePremade.BYTEBOXED.getEPType(), "bteValue", value, valueTypeMustNumeric, codegenMethodScope, SimpleNumberCoercerByte.class, codegenClassScope);
        }

        public static CodegenExpression codegenByte(CodegenExpression input, EPTypeClass inputType) {
            return SimpleNumberCoercerFactory.codegenCoerceNonNull(EPTypePremade.BYTEPRIMITIVE.getEPType(), EPTypePremade.BYTEBOXED.getEPType(), "byteValue", input, inputType);
        }
    }
}

