/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethodScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenScope;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.SimpleNumberCoercerFactory;
import com.espertech.esper.common.internal.util.SimpleTypeCaster;
import com.espertech.esper.common.internal.util.SimpleTypeCasterAnyType;
import com.espertech.esper.common.internal.util.TypeWidenerSPI;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SimpleTypeCasterFactory {
    public static SimpleTypeCaster getCaster(EPType fromType, EPTypeClass targetType) {
        return SimpleTypeCasterFactory.getCaster(fromType == null || fromType == EPTypeNull.INSTANCE ? null : ((EPTypeClass)fromType).getType(), targetType);
    }

    public static SimpleTypeCaster getCaster(Class fromType, EPTypeClass targetType) {
        if (fromType == targetType.getType()) {
            return NullCaster.INSTANCE;
        }
        if ((targetType = JavaClassHelper.getBoxedType(targetType)).getType() == Integer.class) {
            return IntCaster.INSTANCE;
        }
        if (targetType.getType() == Long.class) {
            return LongCaster.INSTANCE;
        }
        if (targetType.getType() == Double.class) {
            return DoubleCaster.INSTANCE;
        }
        if (targetType.getType() == Float.class) {
            return FloatCaster.INSTANCE;
        }
        if (targetType.getType() == Short.class) {
            return ShortCaster.INSTANCE;
        }
        if (targetType.getType() == Byte.class) {
            return ByteCaster.INSTANCE;
        }
        if (targetType.getType() == Character.class && fromType == String.class) {
            return CharacterCaster.INSTANCE;
        }
        if (targetType.getType() == BigInteger.class) {
            if (fromType == BigDecimal.class) {
                return BigIntObjectCaster.INSTANCE;
            }
            if (JavaClassHelper.isNumeric(fromType)) {
                return BigIntCaster.INSTANCE;
            }
            return BigIntObjectCaster.INSTANCE;
        }
        if (targetType.getType() == BigDecimal.class) {
            if (fromType == BigInteger.class) {
                return BigDecObjectCaster.INSTANCE;
            }
            if (JavaClassHelper.isFloatingPointClass(fromType)) {
                return BigDecDoubleCaster.INSTANCE;
            }
            if (JavaClassHelper.isNumeric(fromType)) {
                return BigDecLongCaster.INSTANCE;
            }
            return BigDecObjectCaster.INSTANCE;
        }
        return new SimpleTypeCasterAnyType(targetType);
    }

    private static boolean isPrimitiveOrImplementsNumber(EPTypeClass typeClass) {
        return typeClass.getType().isPrimitive() || JavaClassHelper.isSubclassOrImplementsInterface((EPType)typeClass, EPTypePremade.NUMBER.getEPType());
    }

    private static class NullCaster
    implements SimpleTypeCaster {
        public static final NullCaster INSTANCE = new NullCaster();

        private NullCaster() {
        }

        @Override
        public Object cast(Object object) {
            return object;
        }

        @Override
        public boolean isNumericCast() {
            return false;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return input;
        }
    }

    private static class IntCaster
    implements SimpleTypeCaster {
        public static final IntCaster INSTANCE = new IntCaster();

        private IntCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).intValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerInt.codegenInt(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "intValue", new CodegenExpression[0]);
        }
    }

    private static class LongCaster
    implements SimpleTypeCaster {
        public static final LongCaster INSTANCE = new LongCaster();

        private LongCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).longValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerLong.codegenLong(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "longValue", new CodegenExpression[0]);
        }
    }

    private static class DoubleCaster
    implements SimpleTypeCaster {
        public static final DoubleCaster INSTANCE = new DoubleCaster();

        private DoubleCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).doubleValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerDouble.codegenDouble(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "doubleValue", new CodegenExpression[0]);
        }
    }

    private static class FloatCaster
    implements SimpleTypeCaster {
        public static final FloatCaster INSTANCE = new FloatCaster();

        private FloatCaster() {
        }

        @Override
        public Object cast(Object object) {
            return Float.valueOf(((Number)object).floatValue());
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerFloat.codegenFloat(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "floatValue", new CodegenExpression[0]);
        }
    }

    private static class ShortCaster
    implements SimpleTypeCaster {
        public static final ShortCaster INSTANCE = new ShortCaster();

        private ShortCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).shortValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerShort.codegenShort(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "shortValue", new CodegenExpression[0]);
        }
    }

    private static class ByteCaster
    implements SimpleTypeCaster {
        public static final ByteCaster INSTANCE = new ByteCaster();

        private ByteCaster() {
        }

        @Override
        public Object cast(Object object) {
            return ((Number)object).byteValue();
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerByte.codegenByte(input, inputType);
            }
            return CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "byteValue", new CodegenExpression[0]);
        }
    }

    public static class CharacterCaster
    implements SimpleTypeCaster,
    TypeWidenerSPI {
        public static final CharacterCaster INSTANCE = new CharacterCaster();

        private CharacterCaster() {
        }

        @Override
        public Object cast(Object object) {
            String value = object.toString();
            if (value.length() == 0) {
                return null;
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public Object widen(Object input) {
            return this.cast(input);
        }

        @Override
        public boolean isNumericCast() {
            return false;
        }

        @Override
        public CodegenExpression widenCodegen(CodegenExpression expression, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return this.codegen(expression, EPTypePremade.OBJECT.getEPType(), codegenMethodScope, codegenClassScope);
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            CodegenMethod method = codegenMethodScope.makeChild(EPTypePremade.CHARBOXED.getEPType(), CharacterCaster.class, (CodegenScope)codegenClassScope).addParam(EPTypePremade.OBJECT.getEPType(), "object").getBlock().declareVar(EPTypePremade.STRING.getEPType(), "value", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("object"), "toString", new CodegenExpression[0])).ifCondition(CodegenExpressionBuilder.equalsIdentity(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "length", new CodegenExpression[0]), CodegenExpressionBuilder.constant(0))).blockReturn(CodegenExpressionBuilder.constantNull()).methodReturn(CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.ref("value"), "charAt", CodegenExpressionBuilder.constant(0)));
            return CodegenExpressionBuilder.localMethodBuild(method).pass(input).call();
        }
    }

    public static class BigIntObjectCaster
    implements SimpleTypeCaster {
        public static final BigIntObjectCaster INSTANCE = new BigIntObjectCaster();

        private BigIntObjectCaster() {
        }

        @Override
        public Object cast(Object object) {
            return BigIntObjectCaster.castObjectToBigInteger(object);
        }

        public static BigInteger castObjectToBigInteger(Object object) {
            if (object instanceof BigInteger) {
                return (BigInteger)object;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).toBigInteger();
            }
            long value = ((Number)object).longValue();
            return BigInteger.valueOf(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(this.getClass(), "castObjectToBigInteger", input);
        }
    }

    private static class BigIntCaster
    implements SimpleTypeCaster {
        public static final BigIntCaster INSTANCE = new BigIntCaster();

        private BigIntCaster() {
        }

        @Override
        public Object cast(Object object) {
            long value = ((Number)object).longValue();
            return BigInteger.valueOf(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerBigInt.codegenBigInt(input, inputType);
            }
            return CodegenExpressionBuilder.staticMethod(BigInteger.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "longValue", new CodegenExpression[0]));
        }
    }

    public static class BigDecObjectCaster
    implements SimpleTypeCaster {
        public static final BigDecObjectCaster INSTANCE = new BigDecObjectCaster();

        private BigDecObjectCaster() {
        }

        @Override
        public Object cast(Object object) {
            return BigDecObjectCaster.castObjectToBigDecimal(object);
        }

        public static BigDecimal castObjectToBigDecimal(Object object) {
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof BigInteger) {
                return new BigDecimal((BigInteger)object);
            }
            if (object.getClass() == Double.class || object.getClass() == Float.class) {
                double value = ((Number)object).doubleValue();
                return BigDecimal.valueOf(value);
            }
            long value = ((Number)object).longValue();
            return BigDecimal.valueOf(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            return CodegenExpressionBuilder.staticMethod(this.getClass(), "castObjectToBigDecimal", input);
        }
    }

    private static class BigDecDoubleCaster
    implements SimpleTypeCaster {
        public static final BigDecDoubleCaster INSTANCE = new BigDecDoubleCaster();

        private BigDecDoubleCaster() {
        }

        @Override
        public Object cast(Object object) {
            double value = ((Number)object).doubleValue();
            return new BigDecimal(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerBigDecDouble.codegenBigDec(input, inputType);
            }
            return CodegenExpressionBuilder.staticMethod(BigDecimal.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "doubleValue", new CodegenExpression[0]));
        }
    }

    private static class BigDecLongCaster
    implements SimpleTypeCaster {
        public static final BigDecLongCaster INSTANCE = new BigDecLongCaster();

        private BigDecLongCaster() {
        }

        @Override
        public Object cast(Object object) {
            long value = ((Number)object).longValue();
            return new BigDecimal(value);
        }

        @Override
        public boolean isNumericCast() {
            return true;
        }

        @Override
        public CodegenExpression codegen(CodegenExpression input, EPTypeClass inputType, CodegenMethodScope codegenMethodScope, CodegenClassScope codegenClassScope) {
            if (SimpleTypeCasterFactory.isPrimitiveOrImplementsNumber(inputType)) {
                return SimpleNumberCoercerFactory.SimpleNumberCoercerBigDecLong.codegenBigDec(input, inputType);
            }
            return CodegenExpressionBuilder.staticMethod(BigDecimal.class, "valueOf", CodegenExpressionBuilder.exprDotMethod(CodegenExpressionBuilder.cast(EPTypePremade.NUMBER.getEPType(), input), "longValue", new CodegenExpression[0]));
        }
    }
}

