/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.util;

import com.espertech.esper.common.client.type.EPTypePremade;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionNewAnonymousClass;
import com.espertech.esper.common.internal.util.BoolValue;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.util.LongValue;
import com.espertech.esper.common.internal.util.SimpleTypeParser;
import com.espertech.esper.common.internal.util.SimpleTypeParserSPI;
import java.util.Locale;

public class SimpleTypeParserFactory {
    public static SimpleTypeParserSPI getParser(Class clazz) {
        Class<?> classBoxed = JavaClassHelper.getBoxedType(clazz);
        if (classBoxed == String.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String value) {
                    return value;
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return input;
                }
            };
        }
        if (classBoxed == Character.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String value) {
                    return Character.valueOf(value.charAt(0));
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return CodegenExpressionBuilder.exprDotMethod(input, "charAt", CodegenExpressionBuilder.constant(0));
                }
            };
        }
        if (classBoxed == Boolean.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String text) {
                    return BoolValue.parseString(text.toLowerCase(Locale.ENGLISH).trim());
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return CodegenExpressionBuilder.staticMethod(BoolValue.class, "parseString", CodegenExpressionBuilder.exprDotMethodChain(input).add("toLowerCase", CodegenExpressionBuilder.enumValue(Locale.class, "ENGLISH")).add("trim", new CodegenExpression[0]));
                }
            };
        }
        if (classBoxed == Byte.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String text) {
                    return Byte.decode(text.trim());
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return CodegenExpressionBuilder.staticMethod(Byte.class, "decode", CodegenExpressionBuilder.exprDotMethod(input, "trim", new CodegenExpression[0]));
                }
            };
        }
        if (classBoxed == Short.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String text) {
                    return Short.parseShort(text.trim());
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return CodegenExpressionBuilder.staticMethod(Short.class, "parseShort", CodegenExpressionBuilder.exprDotMethod(input, "trim", new CodegenExpression[0]));
                }
            };
        }
        if (classBoxed == Long.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String text) {
                    return LongValue.parseString(text.trim());
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return CodegenExpressionBuilder.staticMethod(LongValue.class, "parseString", CodegenExpressionBuilder.exprDotMethod(input, "trim", new CodegenExpression[0]));
                }
            };
        }
        if (classBoxed == Float.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String text) {
                    return Float.valueOf(Float.parseFloat(text.trim()));
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return CodegenExpressionBuilder.staticMethod(Float.class, "parseFloat", CodegenExpressionBuilder.exprDotMethod(input, "trim", new CodegenExpression[0]));
                }
            };
        }
        if (classBoxed == Double.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String text) {
                    return Double.parseDouble(text.trim());
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return CodegenExpressionBuilder.staticMethod(Double.class, "parseDouble", CodegenExpressionBuilder.exprDotMethod(input, "trim", new CodegenExpression[0]));
                }
            };
        }
        if (classBoxed == Integer.class) {
            return new SimpleTypeParserSPI(){

                @Override
                public Object parse(String text) {
                    return Integer.parseInt(text.trim());
                }

                @Override
                public CodegenExpression codegen(CodegenExpression input) {
                    return CodegenExpressionBuilder.staticMethod(Integer.class, "parseInt", CodegenExpressionBuilder.exprDotMethod(input, "trim", new CodegenExpression[0]));
                }
            };
        }
        return null;
    }

    public static CodegenExpression codegenSimpleParser(SimpleTypeParserSPI parser, CodegenMethod method, Class originator, CodegenClassScope classScope) {
        CodegenExpressionNewAnonymousClass anonymousClass = CodegenExpressionBuilder.newAnonymousClass(method.getBlock(), SimpleTypeParser.EPTYPE);
        CodegenMethod parse = CodegenMethod.makeParentNode(EPTypePremade.OBJECT.getEPType(), originator, classScope).addParam(EPTypePremade.STRING.getEPType(), "value");
        anonymousClass.addMethod("parse", parse);
        parse.getBlock().methodReturn(parser.codegen(CodegenExpressionBuilder.ref("value")));
        return anonymousClass;
    }
}

