/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.core;

import com.espertech.esper.common.client.EPException;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.Viewable;
import com.espertech.esper.common.internal.view.core.ViewablePair;
import java.util.List;

public class ViewFactoryUtil {
    public static int evaluateSizeParam(String viewName, ExprEvaluator sizeEvaluator, AgentInstanceContext context) {
        Number size = (Number)sizeEvaluator.evaluate(null, true, context);
        if (!ViewFactoryUtil.validateSize(size)) {
            throw new EPException(ViewFactoryUtil.getSizeValidationMsg(viewName, size));
        }
        return size.intValue();
    }

    private static boolean validateSize(Number size) {
        return size != null && size.intValue() > 0;
    }

    private static String getSizeValidationMsg(String viewName, Number size) {
        return viewName + " view requires a positive integer for size but received " + size;
    }

    public static ViewablePair materialize(ViewFactory[] factories, Viewable eventStreamParent, AgentInstanceViewFactoryChainContext viewFactoryChainContext, List<AgentInstanceMgmtCallback> stopCallbacks) {
        if (factories.length == 0) {
            return new ViewablePair(eventStreamParent, eventStreamParent);
        }
        Viewable current = eventStreamParent;
        View topView = null;
        View streamView = null;
        for (ViewFactory viewFactory : factories) {
            View view = viewFactory.makeView(viewFactoryChainContext);
            if (view instanceof AgentInstanceMgmtCallback) {
                stopCallbacks.add((AgentInstanceMgmtCallback)((Object)view));
            }
            current.setChild(view);
            view.setParent(current);
            if (topView == null) {
                topView = view;
            }
            streamView = view;
            current = view;
        }
        return new ViewablePair(topView, streamView);
    }
}

