/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.derived;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.collection.SingleEventIterator;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.event.core.EventBeanTypedEventFactory;
import com.espertech.esper.common.internal.view.core.DerivedValueView;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.derived.BaseStatisticsBean;
import com.espertech.esper.common.internal.view.derived.StatViewAdditionalPropsEval;
import java.util.Iterator;

public abstract class BaseBivariateStatisticsView
extends ViewSupport
implements DerivedValueView {
    protected final ViewFactory viewFactory;
    protected BaseStatisticsBean statisticsBean = new BaseStatisticsBean();
    private final ExprEvaluator expressionXEval;
    private final ExprEvaluator expressionYEval;
    private final EventBean[] eventsPerStream = new EventBean[1];
    protected final AgentInstanceContext agentInstanceContext;
    protected final StatViewAdditionalPropsEval additionalProps;
    protected final EventType eventType;
    protected Object[] lastValuesEventNew;
    private EventBean lastNewEvent;

    protected abstract EventBean populateMap(BaseStatisticsBean var1, EventBeanTypedEventFactory var2, EventType var3, StatViewAdditionalPropsEval var4, Object[] var5);

    public BaseBivariateStatisticsView(ViewFactory viewFactory, AgentInstanceContext agentInstanceContext, ExprEvaluator expressionXEval, ExprEvaluator expressionYEval, EventType eventType, StatViewAdditionalPropsEval additionalProps) {
        this.viewFactory = viewFactory;
        this.agentInstanceContext = agentInstanceContext;
        this.expressionXEval = expressionXEval;
        this.expressionYEval = expressionYEval;
        this.eventType = eventType;
        this.additionalProps = additionalProps;
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        double y;
        double x;
        Number ynum;
        Number xnum;
        int i;
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.viewFactory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.viewFactory, newData, oldData);
        EventBean oldValues = null;
        if (this.lastNewEvent == null && this.child != null) {
            oldValues = this.populateMap(this.statisticsBean, this.agentInstanceContext.getEventBeanTypedEventFactory(), this.eventType, this.additionalProps, this.lastValuesEventNew);
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                this.eventsPerStream[0] = newData[i];
                xnum = (Number)this.expressionXEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                ynum = (Number)this.expressionYEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (xnum == null || ynum == null) continue;
                x = xnum.doubleValue();
                y = ynum.doubleValue();
                this.statisticsBean.addPoint(x, y);
            }
            if (this.additionalProps != null && newData.length != 0) {
                if (this.lastValuesEventNew == null) {
                    this.lastValuesEventNew = new Object[this.additionalProps.getAdditionalEvals().length];
                }
                for (int val = 0; val < this.additionalProps.getAdditionalEvals().length; ++val) {
                    this.lastValuesEventNew[val] = this.additionalProps.getAdditionalEvals()[val].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                }
            }
        }
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                this.eventsPerStream[0] = oldData[i];
                xnum = (Number)this.expressionXEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                ynum = (Number)this.expressionYEval.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
                if (xnum == null || ynum == null) continue;
                x = xnum.doubleValue();
                y = ynum.doubleValue();
                this.statisticsBean.removePoint(x, y);
            }
        }
        if (this.child != null) {
            EventBean newDataMap = this.populateMap(this.statisticsBean, this.agentInstanceContext.getEventBeanTypedEventFactory(), this.eventType, this.additionalProps, this.lastValuesEventNew);
            EventBean[] newEvents = new EventBean[]{newDataMap};
            EventBean[] oldEvents = this.lastNewEvent == null ? new EventBean[]{oldValues} : new EventBean[]{this.lastNewEvent};
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.viewFactory, newEvents, oldEvents);
            this.child.update(newEvents, oldEvents);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            this.lastNewEvent = newDataMap;
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SingleEventIterator(this.populateMap(this.statisticsBean, this.agentInstanceContext.getEventBeanTypedEventFactory(), this.eventType, this.additionalProps, this.lastValuesEventNew));
    }

    public BaseStatisticsBean getStatisticsBean() {
        return this.statisticsBean;
    }

    public Object[] getLastValuesEventNew() {
        return this.lastValuesEventNew;
    }

    public void setLastValuesEventNew(Object[] lastValuesEventNew) {
        this.lastValuesEventNew = lastValuesEventNew;
    }

    public StatViewAdditionalPropsEval getAdditionalProps() {
        return this.additionalProps;
    }

    public ViewFactory getViewFactory() {
        return this.viewFactory;
    }

    public ExprEvaluator getExpressionXEval() {
        return this.expressionXEval;
    }

    public ExprEvaluator getExpressionYEval() {
        return this.expressionYEval;
    }
}

