/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.derived;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.compile.stage3.StmtClassForgeableFactory;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.serde.compiletime.eventtype.SerdeEventTypeUtility;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.core.ViewEnum;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeVisitor;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.derived.StatViewAdditionalPropsForge;
import com.espertech.esper.common.internal.view.derived.ViewFactoryForgeBaseDerived;
import com.espertech.esper.common.internal.view.derived.WeightedAverageView;
import com.espertech.esper.common.internal.view.derived.WeightedAverageViewFactory;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.util.List;

public class WeightedAverageViewForge
extends ViewFactoryForgeBaseDerived {
    protected ExprNode fieldNameX;
    protected ExprNode fieldNameWeight;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        this.viewParameters = parameters;
    }

    @Override
    public void attachValidate(EventType parentEventType, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        ExprNode[] validated = ViewForgeSupport.validate(this.getViewName(), parentEventType, this.viewParameters, true, viewForgeEnv);
        if (validated.length < 2) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (!JavaClassHelper.isNumeric(validated[0].getForge().getEvaluationType()) || !JavaClassHelper.isNumeric(validated[1].getForge().getEvaluationType())) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.fieldNameX = validated[0];
        this.fieldNameWeight = validated[1];
        this.additionalProps = StatViewAdditionalPropsForge.make(validated, 2, parentEventType, viewForgeEnv);
        this.eventType = WeightedAverageView.createEventType(this.additionalProps, viewForgeEnv);
    }

    @Override
    public List<StmtClassForgeableFactory> initAdditionalForgeables(ViewForgeEnv viewForgeEnv) {
        return SerdeEventTypeUtility.plan(this.eventType, viewForgeEnv.getStatementRawInfo(), viewForgeEnv.getSerdeEventTypeRegistry(), viewForgeEnv.getSerdeResolver(), viewForgeEnv.getStateMgmtSettingsProvider());
    }

    @Override
    public EPTypeClass typeOfFactory() {
        return WeightedAverageViewFactory.EPTYPE;
    }

    @Override
    public String factoryMethod() {
        return "weightedavg";
    }

    @Override
    public void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.additionalProps != null) {
            method.getBlock().exprDotMethod(factory, "setAdditionalProps", this.additionalProps.codegen(method, classScope));
        }
        method.getBlock().exprDotMethod(factory, "setFieldNameXEvaluator", ExprNodeUtilityCodegen.codegenEvaluator(this.fieldNameX.getForge(), method, this.getClass(), classScope)).exprDotMethod(factory, "setFieldNameWeightEvaluator", ExprNodeUtilityCodegen.codegenEvaluator(this.fieldNameWeight.getForge(), method, this.getClass(), classScope));
    }

    @Override
    public String getViewName() {
        return ViewEnum.WEIGHTED_AVERAGE.getName();
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.WINDOW_WEIGHTEDAVG;
    }

    @Override
    public <T> T accept(ViewFactoryForgeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires two expressions returning numeric values as parameters";
    }
}

