/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.expression;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.event.arr.ObjectArrayEventBean;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.expression.ExpressionBatchViewUtil;
import com.espertech.esper.common.internal.view.expression.ExpressionViewBase;
import com.espertech.esper.common.internal.view.expression.ExpressionViewOAFieldEnum;
import com.espertech.esper.common.internal.view.expression.ExpressionWindowTimestampEventPair;
import com.espertech.esper.common.internal.view.expression.ExpressionWindowTimestampEventPairIterator;
import com.espertech.esper.common.internal.view.expression.ExpressionWindowViewFactory;
import java.util.ArrayDeque;
import java.util.Iterator;

public class ExpressionWindowView
extends ExpressionViewBase {
    protected final ArrayDeque<ExpressionWindowTimestampEventPair> window = new ArrayDeque();
    private final EventBean[] removedEvents = new EventBean[1];

    public ExpressionWindowView(ExpressionWindowViewFactory factory, ViewUpdatedCollection viewUpdatedCollection, ObjectArrayEventBean builtinEventProps, AgentInstanceViewFactoryChainContext agentInstanceContext) {
        super(factory, viewUpdatedCollection, builtinEventProps, agentInstanceContext);
    }

    public boolean isEmpty() {
        return this.window.isEmpty();
    }

    @Override
    public void scheduleCallback() {
        this.expire(null, null);
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        if (newData != null) {
            for (EventBean newEvent : newData) {
                ExpressionWindowTimestampEventPair pair = new ExpressionWindowTimestampEventPair(this.agentInstanceContext.getTimeProvider().getTime(), newEvent);
                this.window.add(pair);
                this.internalHandleAdd(pair);
            }
            if (this.aggregationService != null) {
                this.aggregationService.applyEnter(newData, null, this.agentInstanceContext);
            }
        }
        if (oldData != null) {
            Iterator<ExpressionWindowTimestampEventPair> it = this.window.iterator();
            while (it.hasNext()) {
                ExpressionWindowTimestampEventPair pair = it.next();
                for (EventBean anOldData : oldData) {
                    if (pair.getTheEvent() != anOldData) continue;
                    it.remove();
                    break;
                }
                this.internalHandleRemoved(pair);
            }
            if (this.aggregationService != null) {
                this.aggregationService.applyLeave(oldData, null, this.agentInstanceContext);
            }
        }
        this.expire(newData, oldData);
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    public void internalHandleRemoved(ExpressionWindowTimestampEventPair pair) {
    }

    public void internalHandleExpired(ExpressionWindowTimestampEventPair pair) {
    }

    public void internalHandleAdd(ExpressionWindowTimestampEventPair pair) {
    }

    private void expire(EventBean[] newData, EventBean[] oldData) {
        OneEventCollection expired = null;
        if (oldData != null) {
            expired = new OneEventCollection();
            expired.add(oldData);
        }
        int expiredCount = 0;
        if (!this.window.isEmpty()) {
            ExpressionWindowTimestampEventPair first;
            boolean pass;
            ExpressionWindowTimestampEventPair newest = this.window.getLast();
            while (!(pass = this.checkEvent(first = this.window.getFirst(), newest, expiredCount))) {
                if (expired == null) {
                    expired = new OneEventCollection();
                }
                EventBean removed = this.window.removeFirst().getTheEvent();
                expired.add(removed);
                if (this.aggregationService != null) {
                    this.removedEvents[0] = removed;
                    this.aggregationService.applyLeave(this.removedEvents, null, this.agentInstanceContext);
                }
                ++expiredCount;
                this.internalHandleExpired(first);
                if (!this.window.isEmpty()) continue;
                if (this.aggregationService == null) break;
                this.aggregationService.clearResults(this.agentInstanceContext);
                break;
            }
        }
        EventBean[] expiredArr = null;
        if (expired != null) {
            expiredArr = expired.toArray();
        }
        if (this.viewUpdatedCollection != null) {
            this.viewUpdatedCollection.update(newData, expiredArr);
        }
        if (this.child != null) {
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, expiredArr);
            this.child.update(newData, expiredArr);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
    }

    private boolean checkEvent(ExpressionWindowTimestampEventPair first, ExpressionWindowTimestampEventPair newest, int numExpired) {
        ExpressionViewOAFieldEnum.populate(this.builtinEventProps.getProperties(), this.window.size(), first.getTimestamp(), newest.getTimestamp(), this, numExpired, first.getTheEvent(), newest.getTheEvent());
        this.eventsPerStream[0] = first.getTheEvent();
        return ExpressionBatchViewUtil.evaluate(this.eventsPerStream, this.agentInstanceContext, this.factory, this.aggregationService);
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new ExpressionWindowTimestampEventPairIterator(this.window.iterator());
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (!this.agentInstanceContext.getStatementContext().getSchedulingService().isScheduled(this.scheduleHandle)) {
            this.agentInstanceContext.getAuditProvider().scheduleAdd(0L, this.agentInstanceContext, this.scheduleHandle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().add(0L, this.scheduleHandle, this.scheduleSlot);
        }
    }

    public ArrayDeque<ExpressionWindowTimestampEventPair> getWindow() {
        return this.window;
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.window, true, this.factory.getViewName(), null);
    }
}

