/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.intersect;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowViewFactory;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewFactoryContext;
import com.espertech.esper.common.internal.view.intersect.IntersectAsymetricView;
import com.espertech.esper.common.internal.view.intersect.IntersectAsymetricViewLocalState;
import com.espertech.esper.common.internal.view.intersect.IntersectBatchView;
import com.espertech.esper.common.internal.view.intersect.IntersectBatchViewLocalState;
import com.espertech.esper.common.internal.view.intersect.IntersectDefaultView;
import com.espertech.esper.common.internal.view.intersect.IntersectDefaultViewLocalState;
import java.util.ArrayList;

public class IntersectViewFactory
implements ViewFactory,
DataWindowViewFactory {
    public static final EPTypeClass EPTYPE = new EPTypeClass(IntersectViewFactory.class);
    protected EventType eventType;
    protected ViewFactory[] intersecteds;
    protected int batchViewIndex;
    protected boolean hasAsymetric;
    protected ThreadLocal<IntersectBatchViewLocalState> batchViewLocalState;
    protected ThreadLocal<IntersectDefaultViewLocalState> defaultViewLocalState;
    protected ThreadLocal<IntersectAsymetricViewLocalState> asymetricViewLocalState;

    @Override
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void init(ViewFactoryContext viewFactoryContext, EPStatementInitServices services) {
        for (ViewFactory grouped : this.intersecteds) {
            grouped.init(viewFactoryContext, services);
        }
        if (this.batchViewIndex != -1) {
            this.batchViewLocalState = new ThreadLocal<IntersectBatchViewLocalState>(){

                @Override
                protected synchronized IntersectBatchViewLocalState initialValue() {
                    return new IntersectBatchViewLocalState(new EventBean[IntersectViewFactory.this.intersecteds.length][], new EventBean[IntersectViewFactory.this.intersecteds.length][]);
                }
            };
        } else if (this.hasAsymetric) {
            this.asymetricViewLocalState = new ThreadLocal<IntersectAsymetricViewLocalState>(){

                @Override
                protected synchronized IntersectAsymetricViewLocalState initialValue() {
                    return new IntersectAsymetricViewLocalState(new EventBean[IntersectViewFactory.this.intersecteds.length][]);
                }
            };
        } else {
            this.defaultViewLocalState = new ThreadLocal<IntersectDefaultViewLocalState>(){

                @Override
                protected synchronized IntersectDefaultViewLocalState initialValue() {
                    return new IntersectDefaultViewLocalState(new EventBean[IntersectViewFactory.this.intersecteds.length][]);
                }
            };
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        ArrayList<View> views = new ArrayList<View>();
        for (ViewFactory viewFactory : this.intersecteds) {
            agentInstanceViewFactoryContext.setRemoveStream(true);
            views.add(viewFactory.makeView(agentInstanceViewFactoryContext));
        }
        if (this.batchViewIndex != -1) {
            return new IntersectBatchView(agentInstanceViewFactoryContext, this, views);
        }
        if (this.hasAsymetric) {
            return new IntersectAsymetricView(agentInstanceViewFactoryContext, this, views);
        }
        return new IntersectDefaultView(agentInstanceViewFactoryContext, this, views);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    public int getBatchViewIndex() {
        return this.batchViewIndex;
    }

    public boolean isHasAsymetric() {
        return this.hasAsymetric;
    }

    public IntersectBatchViewLocalState getBatchViewLocalStatePerThread() {
        return this.batchViewLocalState.get();
    }

    public IntersectDefaultViewLocalState getDefaultViewLocalStatePerThread() {
        return this.defaultViewLocalState.get();
    }

    public IntersectAsymetricViewLocalState getAsymetricViewLocalStatePerThread() {
        return this.asymetricViewLocalState.get();
    }

    public void setBatchViewIndex(int batchViewIndex) {
        this.batchViewIndex = batchViewIndex;
    }

    public void setHasAsymetric(boolean hasAsymetric) {
        this.hasAsymetric = hasAsymetric;
    }

    public void setIntersecteds(ViewFactory[] intersecteds) {
        this.intersecteds = intersecteds;
    }

    public ViewFactory[] getIntersecteds() {
        return this.intersecteds;
    }

    @Override
    public String getViewName() {
        return IntersectViewFactory.getViewNameUnionIntersect(true, this.intersecteds);
    }

    public static String getViewNameUnionIntersect(boolean intersect, ViewFactory[] factories) {
        StringBuilder buf = new StringBuilder();
        buf.append(intersect ? "Intersection" : "Union");
        if (factories == null) {
            return buf.toString();
        }
        buf.append(" of ");
        String delimiter = "";
        for (ViewFactory factory : factories) {
            buf.append(delimiter);
            buf.append(factory.getViewName());
            delimiter = ",";
        }
        return buf.toString();
    }
}

