/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.prior;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.collection.ViewUpdatedCollection;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewFactoryContext;
import com.espertech.esper.common.internal.view.prior.PriorEventBufferMulti;
import com.espertech.esper.common.internal.view.prior.PriorEventBufferSingle;
import com.espertech.esper.common.internal.view.prior.PriorEventBufferUnbound;
import com.espertech.esper.common.internal.view.prior.PriorEventView;
import java.util.Iterator;
import java.util.SortedSet;

public class PriorEventViewFactory
implements ViewFactory {
    public static final EPTypeClass EPTYPE = new EPTypeClass(PriorEventViewFactory.class);
    protected EventType eventType;
    protected boolean isUnbound;

    public void setUnbound(boolean unbound) {
        this.isUnbound = unbound;
    }

    @Override
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void init(ViewFactoryContext viewFactoryContext, EPStatementInitServices services) {
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        return new PriorEventView(agentInstanceViewFactoryContext.getPriorViewUpdatedCollection());
    }

    public ViewUpdatedCollection makeViewUpdatedCollection(SortedSet<Integer> priorRequests, AgentInstanceContext agentInstanceContext) {
        if (priorRequests.isEmpty()) {
            throw new IllegalStateException("No resources requested");
        }
        int[] requested = new int[priorRequests.size()];
        int count = 0;
        Iterator iterator = priorRequests.iterator();
        while (iterator.hasNext()) {
            int reqIndex = (Integer)iterator.next();
            requested[count++] = reqIndex;
        }
        if (this.isUnbound) {
            return new PriorEventBufferUnbound(priorRequests.last());
        }
        if (requested.length == 1) {
            return new PriorEventBufferSingle(requested[0]);
        }
        return new PriorEventBufferMulti(requested);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public String getViewName() {
        return "prior";
    }
}

