/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.rank;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.serde.DataInputOutputSerde;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityMake;
import com.espertech.esper.common.internal.view.access.RandomAccessByIndexGetter;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowViewFactory;
import com.espertech.esper.common.internal.view.core.DataWindowViewWithPrevious;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewEnum;
import com.espertech.esper.common.internal.view.core.ViewFactoryContext;
import com.espertech.esper.common.internal.view.core.ViewFactoryUtil;
import com.espertech.esper.common.internal.view.previous.IStreamSortRankRandomAccess;
import com.espertech.esper.common.internal.view.rank.RankWindowView;
import java.util.Comparator;

public class RankWindowViewFactory
implements DataWindowViewFactory,
DataWindowViewWithPrevious {
    public static final EPTypeClass EPTYPE = new EPTypeClass(RankWindowViewFactory.class);
    protected boolean[] isDescendingValues;
    protected ExprEvaluator criteriaEval;
    protected EPType[] criteriaTypes;
    protected DataInputOutputSerde keySerde;
    protected ExprEvaluator[] sortCriteriaEvaluators;
    protected EPType[] sortCriteriaTypes;
    protected ExprEvaluator size;
    protected boolean useCollatorSort;
    protected DataInputOutputSerde[] sortSerdes;
    protected EventType eventType;
    protected Comparator<Object> comparator;

    @Override
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void init(ViewFactoryContext viewFactoryContext, EPStatementInitServices services) {
        this.comparator = ExprNodeUtilityMake.getComparatorHashableMultiKeys(this.sortCriteriaTypes, this.useCollatorSort, this.isDescendingValues);
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        int sortWindowSize = ViewFactoryUtil.evaluateSizeParam(this.getViewName(), this.size, agentInstanceViewFactoryContext.getAgentInstanceContext());
        IStreamSortRankRandomAccess rankedRandomAccess = agentInstanceViewFactoryContext.getStatementContext().getViewServicePreviousFactory().getOptPreviousExprSortedRankedAccess(agentInstanceViewFactoryContext);
        return new RankWindowView(this, sortWindowSize, rankedRandomAccess, agentInstanceViewFactoryContext);
    }

    @Override
    public RandomAccessByIndexGetter makePreviousGetter() {
        return new RandomAccessByIndexGetter();
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    public boolean[] getIsDescendingValues() {
        return this.isDescendingValues;
    }

    public ExprEvaluator getCriteriaEval() {
        return this.criteriaEval;
    }

    public ExprEvaluator[] getSortCriteriaEvaluators() {
        return this.sortCriteriaEvaluators;
    }

    public boolean isUseCollatorSort() {
        return this.useCollatorSort;
    }

    public ExprEvaluator getSizeEvaluator() {
        return this.size;
    }

    public Comparator<Object> getComparator() {
        return this.comparator;
    }

    public void setIsDescendingValues(boolean[] isDescendingValues) {
        this.isDescendingValues = isDescendingValues;
    }

    public void setCriteriaEval(ExprEvaluator criteriaEval) {
        this.criteriaEval = criteriaEval;
    }

    public void setSortCriteriaEvaluators(ExprEvaluator[] sortCriteriaEvaluators) {
        this.sortCriteriaEvaluators = sortCriteriaEvaluators;
    }

    public void setSortCriteriaTypes(EPType[] sortCriteriaTypes) {
        this.sortCriteriaTypes = sortCriteriaTypes;
    }

    public void setSize(ExprEvaluator size) {
        this.size = size;
    }

    public void setUseCollatorSort(boolean useCollatorSort) {
        this.useCollatorSort = useCollatorSort;
    }

    public void setCriteriaTypes(EPType[] criteriaTypes) {
        this.criteriaTypes = criteriaTypes;
    }

    @Override
    public String getViewName() {
        return ViewEnum.RANK_WINDOW.getName();
    }

    public void setKeySerde(DataInputOutputSerde keySerde) {
        this.keySerde = keySerde;
    }

    public void setSortSerdes(DataInputOutputSerde[] sortSerdes) {
        this.sortSerdes = sortSerdes;
    }
}

