/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.sort;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.util.HashableMultiKey;
import com.espertech.esper.common.internal.collection.OneEventCollection;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.util.CollectionUtil;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.previous.IStreamSortRankRandomAccess;
import com.espertech.esper.common.internal.view.sort.SortWindowIterator;
import com.espertech.esper.common.internal.view.sort.SortWindowViewFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class SortWindowView
extends ViewSupport
implements DataWindowView {
    private final SortWindowViewFactory factory;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final int sortWindowSize;
    private final IStreamSortRankRandomAccess optionalSortedRandomAccess;
    protected final AgentInstanceContext agentInstanceContext;
    protected TreeMap<Object, Object> sortedEvents;
    protected int eventCount;

    public SortWindowView(SortWindowViewFactory factory, int sortWindowSize, IStreamSortRankRandomAccess optionalSortedRandomAccess, AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        this.factory = factory;
        this.sortWindowSize = sortWindowSize;
        this.optionalSortedRandomAccess = optionalSortedRandomAccess;
        this.agentInstanceContext = agentInstanceViewFactoryContext.getAgentInstanceContext();
        this.sortedEvents = new TreeMap(factory.comparator);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public final void update(EventBean[] newData, EventBean[] oldData) {
        Object sortValues;
        int i;
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        OneEventCollection removedEvents = null;
        if (oldData != null) {
            for (i = 0; i < oldData.length; ++i) {
                EventBean oldDataItem = oldData[i];
                sortValues = this.getSortValues(oldDataItem);
                boolean result = CollectionUtil.removeEventByKeyLazyListMap(sortValues, oldDataItem, this.sortedEvents);
                if (!result) continue;
                --this.eventCount;
                if (removedEvents == null) {
                    removedEvents = new OneEventCollection();
                }
                removedEvents.add(oldDataItem);
                this.internalHandleRemoved(sortValues, oldDataItem);
            }
        }
        if (newData != null) {
            for (i = 0; i < newData.length; ++i) {
                EventBean newDataItem = newData[i];
                sortValues = this.getSortValues(newDataItem);
                CollectionUtil.addEventByKeyLazyListMapFront(sortValues, newDataItem, this.sortedEvents);
                ++this.eventCount;
                this.internalHandleAdd(sortValues, newDataItem);
            }
        }
        if (this.eventCount > this.sortWindowSize) {
            int removeCount = this.eventCount - this.sortWindowSize;
            for (int i2 = 0; i2 < removeCount; ++i2) {
                Object lastKey = this.sortedEvents.lastKey();
                Object lastEntry = this.sortedEvents.get(lastKey);
                if (lastEntry instanceof List) {
                    List events = (List)lastEntry;
                    EventBean theEvent = (EventBean)events.remove(events.size() - 1);
                    --this.eventCount;
                    if (events.isEmpty()) {
                        this.sortedEvents.remove(lastKey);
                    }
                    if (removedEvents == null) {
                        removedEvents = new OneEventCollection();
                    }
                    removedEvents.add(theEvent);
                    this.internalHandleRemoved(lastKey, theEvent);
                    continue;
                }
                EventBean theEvent = (EventBean)lastEntry;
                --this.eventCount;
                this.sortedEvents.remove(lastKey);
                if (removedEvents == null) {
                    removedEvents = new OneEventCollection();
                }
                removedEvents.add(theEvent);
                this.internalHandleRemoved(lastKey, theEvent);
            }
        }
        if (this.optionalSortedRandomAccess != null) {
            this.optionalSortedRandomAccess.refresh(this.sortedEvents, this.eventCount, this.sortWindowSize);
        }
        if (this.child != null) {
            EventBean[] expiredArr = null;
            if (removedEvents != null) {
                expiredArr = removedEvents.toArray();
            }
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, expiredArr);
            this.child.update(newData, expiredArr);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    public void internalHandleAdd(Object sortValues, EventBean newDataItem) {
    }

    public void internalHandleRemoved(Object sortValues, EventBean oldDataItem) {
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return new SortWindowIterator(this.sortedEvents);
    }

    public final String toString() {
        return this.getClass().getName() + " isDescending=" + Arrays.toString(this.factory.isDescendingValues) + " sortWindowSize=" + this.sortWindowSize;
    }

    protected Object getSortValues(EventBean theEvent) {
        this.eventsPerStream[0] = theEvent;
        if (this.factory.sortCriteriaEvaluators.length == 1) {
            return this.factory.sortCriteriaEvaluators[0].evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        Object[] result = new Object[this.factory.sortCriteriaEvaluators.length];
        int count = 0;
        for (ExprEvaluator expr : this.factory.sortCriteriaEvaluators) {
            result[count++] = expr.evaluate(this.eventsPerStream, true, this.agentInstanceContext);
        }
        return new HashableMultiKey(result);
    }

    public boolean isEmpty() {
        if (this.sortedEvents == null) {
            return true;
        }
        return this.sortedEvents.isEmpty();
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.sortedEvents, false, this.factory.getViewName(), this.eventCount, null);
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

