/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.time_accum;

import com.espertech.esper.common.client.EventBean;
import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.internal.context.util.AgentInstanceContext;
import com.espertech.esper.common.internal.context.util.AgentInstanceMgmtCallback;
import com.espertech.esper.common.internal.context.util.AgentInstanceStopServices;
import com.espertech.esper.common.internal.context.util.EPStatementHandleCallbackSchedule;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodProvide;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallback;
import com.espertech.esper.common.internal.schedule.ScheduleObjectType;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowView;
import com.espertech.esper.common.internal.view.core.ViewDataVisitor;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewSupport;
import com.espertech.esper.common.internal.view.time_accum.TimeAccumViewFactory;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;

public class TimeAccumViewRStream
extends ViewSupport
implements DataWindowView,
AgentInstanceMgmtCallback {
    private final TimeAccumViewFactory factory;
    private final AgentInstanceContext agentInstanceContext;
    private final long scheduleSlot;
    private final TimePeriodProvide timePeriodProvide;
    private LinkedHashMap<EventBean, Long> currentBatch = new LinkedHashMap();
    private EventBean lastEvent;
    private long callbackScheduledTime;
    private EPStatementHandleCallbackSchedule handle;

    public TimeAccumViewRStream(TimeAccumViewFactory timeBatchViewFactory, final AgentInstanceViewFactoryChainContext agentInstanceContext, TimePeriodProvide timePeriodProvide) {
        this.agentInstanceContext = agentInstanceContext.getAgentInstanceContext();
        this.factory = timeBatchViewFactory;
        this.scheduleSlot = agentInstanceContext.getStatementContext().getScheduleBucket().allocateSlot();
        this.timePeriodProvide = timePeriodProvide;
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            @Override
            public void scheduledTrigger() {
                agentInstanceContext.getAuditProvider().scheduleFire(agentInstanceContext.getAgentInstanceContext(), ScheduleObjectType.view, TimeAccumViewRStream.this.factory.getViewName());
                agentInstanceContext.getInstrumentationProvider().qViewScheduledEval(TimeAccumViewRStream.this.factory);
                TimeAccumViewRStream.this.sendRemoveStream();
                agentInstanceContext.getInstrumentationProvider().aViewScheduledEval();
            }
        };
        this.handle = new EPStatementHandleCallbackSchedule(agentInstanceContext.getEpStatementAgentInstanceHandle(), callback);
    }

    @Override
    public final EventType getEventType() {
        return this.parent.getEventType();
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        this.agentInstanceContext.getAuditProvider().view(newData, oldData, this.agentInstanceContext, this.factory);
        this.agentInstanceContext.getInstrumentationProvider().qViewProcessIRStream(this.factory, newData, oldData);
        if (newData != null && newData.length > 0) {
            boolean removeSchedule = false;
            boolean addSchedule = false;
            long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
            if (!this.currentBatch.isEmpty()) {
                long callbackTime = timestamp + this.timePeriodProvide.deltaAdd(timestamp, null, true, this.agentInstanceContext);
                if (callbackTime != this.callbackScheduledTime) {
                    removeSchedule = true;
                    addSchedule = true;
                }
            } else {
                addSchedule = true;
            }
            if (removeSchedule) {
                this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
                this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.callbackScheduledTime = -1L;
            }
            if (addSchedule) {
                long timeIntervalSize = this.timePeriodProvide.deltaAdd(timestamp, null, true, this.agentInstanceContext);
                this.agentInstanceContext.getAuditProvider().scheduleAdd(timeIntervalSize, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
                this.agentInstanceContext.getStatementContext().getSchedulingService().add(timeIntervalSize, this.handle, this.scheduleSlot);
                this.callbackScheduledTime = timeIntervalSize + timestamp;
            }
            for (int i = 0; i < newData.length; ++i) {
                this.currentBatch.put(newData[i], timestamp);
                this.lastEvent = newData[i];
            }
        }
        if (oldData != null && oldData.length > 0) {
            boolean removedLastEvent = false;
            for (EventBean anOldData : oldData) {
                this.currentBatch.remove(anOldData);
                if (anOldData != this.lastEvent) continue;
                removedLastEvent = true;
            }
            if (this.currentBatch.size() == 0) {
                this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
                this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                this.callbackScheduledTime = -1L;
                this.lastEvent = null;
            } else if (removedLastEvent) {
                Set<EventBean> keyset = this.currentBatch.keySet();
                EventBean[] events = keyset.toArray(new EventBean[keyset.size()]);
                this.lastEvent = events[events.length - 1];
                long lastTimestamp = this.currentBatch.get(this.lastEvent);
                long timestamp = this.agentInstanceContext.getStatementContext().getSchedulingService().getTime();
                long callbackTime = lastTimestamp + this.timePeriodProvide.deltaAdd(lastTimestamp, null, true, this.agentInstanceContext);
                long deltaFromNow = callbackTime - timestamp;
                if (callbackTime != this.callbackScheduledTime) {
                    this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
                    this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
                    this.agentInstanceContext.getAuditProvider().scheduleAdd(deltaFromNow, this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
                    this.agentInstanceContext.getStatementContext().getSchedulingService().add(deltaFromNow, this.handle, this.scheduleSlot);
                    this.callbackScheduledTime = callbackTime;
                }
            }
        }
        if (this.child != null) {
            this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, newData, oldData);
            this.child.update(newData, oldData);
            this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
        }
        this.agentInstanceContext.getInstrumentationProvider().aViewProcessIRStream();
    }

    @Override
    public void visitView(ViewDataVisitor viewDataVisitor) {
        viewDataVisitor.visitPrimary(this.currentBatch, true, this.factory.getViewName(), this.currentBatch.size(), null);
    }

    private void sendRemoveStream() {
        this.callbackScheduledTime = -1L;
        if (this.child != null) {
            EventBean[] oldData = null;
            if (!this.currentBatch.isEmpty()) {
                oldData = this.currentBatch.keySet().toArray(new EventBean[this.currentBatch.size()]);
            }
            if (oldData != null) {
                this.agentInstanceContext.getInstrumentationProvider().qViewIndicate(this.factory, null, oldData);
                this.child.update(null, oldData);
                this.agentInstanceContext.getInstrumentationProvider().aViewIndicate();
            }
        }
        this.currentBatch.clear();
    }

    public boolean isEmpty() {
        return this.currentBatch.isEmpty();
    }

    @Override
    public final Iterator<EventBean> iterator() {
        return this.currentBatch.keySet().iterator();
    }

    public final String toString() {
        return this.getClass().getName();
    }

    @Override
    public void stop(AgentInstanceStopServices services) {
        if (this.handle != null) {
            this.agentInstanceContext.getAuditProvider().scheduleRemove(this.agentInstanceContext, this.handle, ScheduleObjectType.view, this.factory.getViewName());
            this.agentInstanceContext.getStatementContext().getSchedulingService().remove(this.handle, this.scheduleSlot);
        }
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }
}

