/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.timetolive;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityCodegen;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodCompute;
import com.espertech.esper.common.internal.epl.expression.time.eval.TimePeriodComputeForge;
import com.espertech.esper.common.internal.schedule.ScheduleHandleCallbackProvider;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForgeWithPrevious;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeVisitor;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.timetolive.TimeOrderViewFactory;
import com.espertech.esper.common.internal.view.util.ViewFactoryTimePeriodHelper;
import com.espertech.esper.common.internal.view.util.ViewForgeSupport;
import java.util.List;

public class TimeOrderViewForge
extends ViewFactoryForgeBase
implements DataWindowViewForge,
DataWindowViewForgeWithPrevious,
ScheduleHandleCallbackProvider {
    private List<ExprNode> viewParameters;
    private ExprNode timestampExpression;
    protected TimePeriodComputeForge timePeriodCompute;
    protected int scheduleCallbackId = -1;

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        this.viewParameters = parameters;
    }

    @Override
    public void attachValidate(EventType parentEventType, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        ExprNode[] validated = ViewForgeSupport.validate(this.getViewName(), parentEventType, this.viewParameters, true, viewForgeEnv);
        if (this.viewParameters.size() != 2) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        if (!JavaClassHelper.isNumeric(validated[0].getForge().getEvaluationType())) {
            throw new ViewParameterException(this.getViewParamMessage());
        }
        this.timestampExpression = validated[0];
        this.timePeriodCompute = ViewFactoryTimePeriodHelper.validateAndEvaluateTimeDeltaFactory(this.getViewName(), this.viewParameters.get(1), this.getViewParamMessage(), 1, viewForgeEnv);
        this.eventType = parentEventType;
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return TimeOrderViewFactory.EPTYPE;
    }

    @Override
    protected String factoryMethod() {
        return "timeorder";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        if (this.scheduleCallbackId == -1) {
            throw new IllegalStateException("No schedule callback id");
        }
        method.getBlock().declareVar(TimePeriodCompute.EPTYPE, "eval", this.timePeriodCompute.makeEvaluator(method, classScope)).exprDotMethod(factory, "setTimestampEval", ExprNodeUtilityCodegen.codegenEvaluator(this.timestampExpression.getForge(), method, TimeOrderViewForge.class, classScope)).exprDotMethod(factory, "setTimePeriodCompute", CodegenExpressionBuilder.ref("eval")).exprDotMethod(factory, "setScheduleCallbackId", CodegenExpressionBuilder.constant(this.scheduleCallbackId));
    }

    @Override
    public String getViewName() {
        return "Time-Order";
    }

    @Override
    public void setScheduleCallbackId(int id) {
        this.scheduleCallbackId = id;
    }

    @Override
    public int getScheduleCallbackId() {
        return this.scheduleCallbackId;
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.WINDOW_TIMEORDER;
    }

    @Override
    public <T> T accept(ViewFactoryForgeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    private String getViewParamMessage() {
        return this.getViewName() + " view requires the expression supplying timestamp values, and a numeric or time period parameter for interval size";
    }
}

