/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.union;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.context.module.EPStatementInitServices;
import com.espertech.esper.common.internal.view.core.AgentInstanceViewFactoryChainContext;
import com.espertech.esper.common.internal.view.core.DataWindowViewFactory;
import com.espertech.esper.common.internal.view.core.View;
import com.espertech.esper.common.internal.view.core.ViewFactory;
import com.espertech.esper.common.internal.view.core.ViewFactoryContext;
import com.espertech.esper.common.internal.view.intersect.IntersectViewFactory;
import com.espertech.esper.common.internal.view.union.UnionAsymetricView;
import com.espertech.esper.common.internal.view.union.UnionView;
import java.util.ArrayList;

public class UnionViewFactory
implements ViewFactory,
DataWindowViewFactory {
    public static final EPTypeClass EPTYPE = new EPTypeClass(UnionViewFactory.class);
    protected EventType eventType;
    protected ViewFactory[] unioned;
    protected boolean hasAsymetric;

    @Override
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Override
    public void init(ViewFactoryContext viewFactoryContext, EPStatementInitServices services) {
        for (ViewFactory factory : this.unioned) {
            factory.init(viewFactoryContext, services);
        }
    }

    @Override
    public View makeView(AgentInstanceViewFactoryChainContext agentInstanceViewFactoryContext) {
        ArrayList<View> views = new ArrayList<View>();
        for (ViewFactory viewFactory : this.unioned) {
            views.add(viewFactory.makeView(agentInstanceViewFactoryContext));
        }
        if (this.hasAsymetric) {
            return new UnionAsymetricView(agentInstanceViewFactoryContext, this, views);
        }
        return new UnionView(agentInstanceViewFactoryContext, this, views);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    public ViewFactory[] getUnioned() {
        return this.unioned;
    }

    public void setUnioned(ViewFactory[] unioned) {
        this.unioned = unioned;
    }

    public boolean isHasAsymetric() {
        return this.hasAsymetric;
    }

    public void setHasAsymetric(boolean hasAsymetric) {
        this.hasAsymetric = hasAsymetric;
    }

    @Override
    public String getViewName() {
        return IntersectViewFactory.getViewNameUnionIntersect(false, this.unioned);
    }
}

