/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.union;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.annotation.AppliesTo;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenClassScope;
import com.espertech.esper.common.internal.bytecodemodel.base.CodegenMethod;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpression;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionBuilder;
import com.espertech.esper.common.internal.bytecodemodel.model.expression.CodegenExpressionRef;
import com.espertech.esper.common.internal.context.aifactory.core.SAIFFInitializeSymbol;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.view.core.AsymetricDataWindowViewForge;
import com.espertech.esper.common.internal.view.core.DataWindowViewForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForge;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeBase;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeUtil;
import com.espertech.esper.common.internal.view.core.ViewFactoryForgeVisitor;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewForgeVisitor;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import com.espertech.esper.common.internal.view.intersect.IntersectViewFactoryForge;
import com.espertech.esper.common.internal.view.union.UnionViewFactory;
import java.util.List;

public class UnionViewFactoryForge
extends ViewFactoryForgeBase
implements DataWindowViewForge {
    private final List<ViewFactoryForge> unioned;
    private boolean hasAsymetric;

    public UnionViewFactoryForge(List<ViewFactoryForge> unioned) {
        this.unioned = unioned;
        if (unioned.isEmpty()) {
            throw new IllegalStateException("Empty unioned views");
        }
        for (ViewFactoryForge forge : unioned) {
            this.hasAsymetric |= forge instanceof AsymetricDataWindowViewForge;
        }
    }

    @Override
    public void setViewParameters(List<ExprNode> parameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
    }

    @Override
    public void attachValidate(EventType parentEventType, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        this.eventType = parentEventType;
    }

    @Override
    protected EPTypeClass typeOfFactory() {
        return UnionViewFactory.EPTYPE;
    }

    @Override
    protected String factoryMethod() {
        return "union";
    }

    @Override
    protected void assign(CodegenMethod method, CodegenExpressionRef factory, SAIFFInitializeSymbol symbols, CodegenClassScope classScope) {
        method.getBlock().exprDotMethod(factory, "setHasAsymetric", CodegenExpressionBuilder.constant(this.hasAsymetric)).exprDotMethod(factory, "setUnioned", CodegenExpressionBuilder.localMethod(ViewFactoryForgeUtil.makeViewFactories(this.unioned, this.getClass(), method, classScope, symbols), new CodegenExpression[0]));
    }

    @Override
    public void accept(ViewForgeVisitor visitor) {
        visitor.visit(this);
        for (ViewFactoryForge forge : this.unioned) {
            forge.accept(visitor);
        }
    }

    @Override
    public List<ViewFactoryForge> getInnerForges() {
        return this.unioned;
    }

    @Override
    public String getViewName() {
        return IntersectViewFactoryForge.getViewNameUnionIntersect(false, this.unioned);
    }

    @Override
    public AppliesTo appliesTo() {
        return AppliesTo.WINDOW_UNION;
    }

    @Override
    public <T> T accept(ViewFactoryForgeVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

