/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.util;

import com.espertech.esper.common.internal.view.core.ViewParameterException;
import java.util.Locale;

public class TimeBatchFlags {
    private static final String FORCE_UPDATE_KEYWORD = "force_update";
    private static final String START_EAGER_KEYWORD = "start_eager";
    private final boolean isForceUpdate;
    private final boolean isStartEager;

    public TimeBatchFlags(boolean isForceUpdate, boolean isStartEager) {
        this.isForceUpdate = isForceUpdate;
        this.isStartEager = isStartEager;
    }

    public boolean isForceUpdate() {
        return this.isForceUpdate;
    }

    public boolean isStartEager() {
        return this.isStartEager;
    }

    public static TimeBatchFlags processKeywords(Object keywords, String errorMessage) throws ViewParameterException {
        boolean isForceUpdate = false;
        boolean isStartEager = false;
        if (!(keywords instanceof String)) {
            throw new ViewParameterException(errorMessage);
        }
        String[] keyword = ((String)keywords).split(",");
        for (int i = 0; i < keyword.length; ++i) {
            String keywordText = keyword[i].toLowerCase(Locale.ENGLISH).trim();
            if (keywordText.length() == 0) continue;
            if (keywordText.equals(FORCE_UPDATE_KEYWORD)) {
                isForceUpdate = true;
                continue;
            }
            if (keywordText.equals(START_EAGER_KEYWORD)) {
                isForceUpdate = true;
                isStartEager = true;
                continue;
            }
            String keywordRange = "force_update,start_eager";
            throw new ViewParameterException("Time-batch encountered an invalid keyword '" + keywordText + "', valid control keywords are: " + keywordRange);
        }
        return new TimeBatchFlags(isForceUpdate, isStartEager);
    }
}

