/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.common.internal.view.util;

import com.espertech.esper.common.client.EventType;
import com.espertech.esper.common.client.type.EPType;
import com.espertech.esper.common.client.type.EPTypeClass;
import com.espertech.esper.common.client.type.EPTypeNull;
import com.espertech.esper.common.internal.epl.expression.core.ExprEvaluator;
import com.espertech.esper.common.internal.epl.expression.core.ExprForge;
import com.espertech.esper.common.internal.epl.expression.core.ExprNode;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeOrigin;
import com.espertech.esper.common.internal.epl.expression.core.ExprNodeUtilityValidate;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContext;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationContextBuilder;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationException;
import com.espertech.esper.common.internal.epl.expression.core.ExprValidationMemberNameQualifiedView;
import com.espertech.esper.common.internal.epl.expression.visitor.ExprNodeSummaryVisitor;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeService;
import com.espertech.esper.common.internal.epl.streamtype.StreamTypeServiceImpl;
import com.espertech.esper.common.internal.util.JavaClassHelper;
import com.espertech.esper.common.internal.view.core.ViewForgeEnv;
import com.espertech.esper.common.internal.view.core.ViewParameterException;
import java.util.ArrayList;
import java.util.List;

public class ViewForgeSupport {
    public static Object validateAndEvaluate(String viewName, ExprNode expression, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        return ViewForgeSupport.validateAndEvaluateExpr(viewName, expression, new StreamTypeServiceImpl(false), viewForgeEnv, 0);
    }

    public static Object evaluateAssertNoProperties(String viewName, ExprNode expression, int index) throws ViewParameterException {
        ViewForgeSupport.validateNoProperties(viewName, expression, index);
        return expression.getForge().getExprEvaluator().evaluate(null, false, null);
    }

    public static void assertReturnsNonConstant(String viewName, ExprNode expression, int index) throws ViewParameterException {
        if (expression.getForge().getForgeConstantType().isCompileTimeConstant()) {
            String message = "Invalid view parameter expression " + index + ViewForgeSupport.getViewDesc(viewName) + ", the expression returns a constant result value, are you sure?";
            throw new ViewParameterException(message);
        }
    }

    public static void validateNoProperties(String viewName, ExprNode expression, int index) throws ViewParameterException {
        ExprNodeSummaryVisitor visitor = new ExprNodeSummaryVisitor();
        expression.accept(visitor);
        if (!visitor.isPlain()) {
            String message = "Invalid view parameter expression " + index + ViewForgeSupport.getViewDesc(viewName) + ", " + visitor.getMessage() + " are not allowed within the expression";
            throw new ViewParameterException(message);
        }
    }

    public static Object validateAndEvaluateExpr(String viewName, ExprNode expression, StreamTypeService streamTypeService, ViewForgeEnv viewForgeEnv, int expressionNumber) throws ViewParameterException {
        ExprNode validated = ViewForgeSupport.validateExpr(viewName, expression, streamTypeService, viewForgeEnv, expressionNumber);
        try {
            return validated.getForge().getExprEvaluator().evaluate(null, true, null);
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate parameter expression " + expressionNumber + ViewForgeSupport.getViewDesc(viewName);
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            throw new ViewParameterException(message, ex);
        }
    }

    public static ExprForge validateSizeSingleParam(String viewName, List<ExprNode> expressionParameters, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        ExprNode[] validated = ViewForgeSupport.validate(viewName, expressionParameters, viewForgeEnv, streamNumber);
        if (validated.length != 1) {
            throw new ViewParameterException(ViewForgeSupport.getViewParamMessage(viewName));
        }
        return ViewForgeSupport.validateSizeParam(viewName, validated[0], 0);
    }

    public static ExprForge validateSizeParam(String viewName, ExprNode sizeNode, int expressionNumber) throws ViewParameterException {
        Number size;
        ExprForge forge = sizeNode.getForge();
        EPType sizeType = sizeNode.getForge().getEvaluationType();
        if (sizeType == null || sizeType == EPTypeNull.INSTANCE) {
            throw new ViewParameterException(ViewForgeSupport.getViewParamMessage(viewName));
        }
        EPTypeClass sizeTypeBoxed = JavaClassHelper.getBoxedType((EPTypeClass)sizeType);
        if (!JavaClassHelper.isNumeric(sizeTypeBoxed) || JavaClassHelper.isFloatingPointClass(sizeTypeBoxed) || sizeTypeBoxed.getType() == Long.class) {
            throw new ViewParameterException(ViewForgeSupport.getViewParamMessage(viewName));
        }
        if (sizeNode.getForge().getForgeConstantType().isCompileTimeConstant() && !ViewForgeSupport.validateSize(size = (Number)ViewForgeSupport.evaluate(forge.getExprEvaluator(), expressionNumber, viewName))) {
            throw new ViewParameterException(ViewForgeSupport.getSizeValidationMsg(viewName, size));
        }
        return forge;
    }

    public static ExprNode[] validate(String viewName, EventType eventType, List<ExprNode> expressions, boolean allowConstantResult, ViewForgeEnv viewForgeEnv) throws ViewParameterException {
        ArrayList<ExprNode> results = new ArrayList<ExprNode>();
        int expressionNumber = 0;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(eventType, null, false);
        for (ExprNode expr : expressions) {
            ExprNode validated = ViewForgeSupport.validateExpr(viewName, expr, streamTypeService, viewForgeEnv, expressionNumber);
            results.add(validated);
            if (!allowConstantResult && validated.getForge().getForgeConstantType().isCompileTimeConstant()) {
                String message = "Invalid view parameter expression " + expressionNumber + ViewForgeSupport.getViewDesc(viewName) + ", the expression returns a constant result value, are you sure?";
                throw new ViewParameterException(message);
            }
            ++expressionNumber;
        }
        return results.toArray(new ExprNode[results.size()]);
    }

    public static ExprNode[] validate(String viewName, List<ExprNode> expressions, ViewForgeEnv viewForgeEnv, int streamNumber) throws ViewParameterException {
        ExprNode[] results = new ExprNode[expressions.size()];
        int expressionNumber = 0;
        StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(false);
        for (ExprNode expr : expressions) {
            results[expressionNumber] = ViewForgeSupport.validateExpr(viewName, expr, streamTypeService, viewForgeEnv, expressionNumber);
            ++expressionNumber;
        }
        return results;
    }

    public static ExprNode validateExpr(String viewName, ExprNode expression, StreamTypeService streamTypeService, ViewForgeEnv viewForgeEnv, int expressionNumber) throws ViewParameterException {
        ExprNode validated;
        try {
            ExprValidationMemberNameQualifiedView names = new ExprValidationMemberNameQualifiedView(viewForgeEnv.getStreamNumber());
            ExprValidationContext validationContext = new ExprValidationContextBuilder(streamTypeService, viewForgeEnv.getStatementRawInfo(), viewForgeEnv.getStatementCompileTimeServices()).withMemberName(names).build();
            validated = ExprNodeUtilityValidate.getValidatedSubtree(ExprNodeOrigin.VIEWPARAMETER, expression, validationContext);
        }
        catch (ExprValidationException ex) {
            String message = "Invalid parameter expression " + expressionNumber + ViewForgeSupport.getViewDesc(viewName);
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            throw new ViewParameterException(message, ex);
        }
        return validated;
    }

    public static Object evaluate(ExprEvaluator evaluator, int expressionNumber, String viewName) throws ViewParameterException {
        try {
            return evaluator.evaluate(null, true, null);
        }
        catch (RuntimeException ex) {
            String message = "Failed to evaluate parameter expression " + expressionNumber + ViewForgeSupport.getViewDesc(viewName);
            if (ex.getMessage() != null) {
                message = message + ": " + ex.getMessage();
            }
            throw new ViewParameterException(message, ex);
        }
    }

    public static void validateNoParameters(String viewName, List<ExprNode> expressionParameters) throws ViewParameterException {
        if (!expressionParameters.isEmpty()) {
            String errorMessage = viewName + " view requires an empty parameter list";
            throw new ViewParameterException(errorMessage);
        }
    }

    private static String getViewParamMessage(String viewName) {
        return viewName + " view requires a single integer-type parameter";
    }

    private static boolean validateSize(Number size) {
        return size != null && size.intValue() > 0;
    }

    private static String getSizeValidationMsg(String viewName, Number size) {
        return viewName + " view requires a positive integer for size but received " + size;
    }

    private static String getViewDesc(String viewName) {
        return " for " + viewName + " view";
    }
}

