/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.dom;

import com.fasterxml.aalto.dom.BijectiveNsMap;
import com.fasterxml.aalto.dom.OutputElementBase;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMOutputElement
extends OutputElementBase {
    private DOMOutputElement _parent;
    private Element _element;
    private boolean _defaultNsSet;

    private DOMOutputElement() {
        this._parent = null;
        this._element = null;
        this._nsMapping = null;
        this._nsMapShared = false;
        this._defaultNsURI = "";
        this._rootNsContext = null;
        this._defaultNsSet = false;
    }

    private DOMOutputElement(DOMOutputElement dOMOutputElement, Element element, BijectiveNsMap bijectiveNsMap) {
        super(dOMOutputElement, bijectiveNsMap);
        this._parent = dOMOutputElement;
        this._element = element;
        this._nsMapping = bijectiveNsMap;
        this._nsMapShared = bijectiveNsMap != null;
        this._defaultNsURI = dOMOutputElement._defaultNsURI;
        this._rootNsContext = dOMOutputElement._rootNsContext;
        this._defaultNsSet = false;
    }

    private void relink(DOMOutputElement dOMOutputElement, Element element) {
        super.relink(dOMOutputElement);
        this._parent = dOMOutputElement;
        this._element = element;
        dOMOutputElement.appendNode(element);
        this._defaultNsSet = false;
    }

    public static DOMOutputElement createRoot() {
        return new DOMOutputElement();
    }

    protected DOMOutputElement createAndAttachChild(Element element) {
        if (this.isRoot()) {
            element.getOwnerDocument().appendChild(element);
        } else {
            this._element.appendChild(element);
        }
        return this.createChild(element);
    }

    protected DOMOutputElement createChild(Element element) {
        return new DOMOutputElement(this, element, this._nsMapping);
    }

    protected DOMOutputElement reuseAsChild(DOMOutputElement dOMOutputElement, Element element) {
        DOMOutputElement dOMOutputElement2 = this._parent;
        this.relink(dOMOutputElement, element);
        return dOMOutputElement2;
    }

    protected void addToPool(DOMOutputElement dOMOutputElement) {
        this._parent = dOMOutputElement;
    }

    public DOMOutputElement getParent() {
        return this._parent;
    }

    @Override
    public boolean isRoot() {
        return this._parent == null;
    }

    @Override
    public String getNameDesc() {
        if (this._element != null) {
            return this._element.getLocalName();
        }
        return "#error";
    }

    @Override
    public void setDefaultNsUri(String string) {
        this._defaultNsURI = string;
        this._defaultNsSet = true;
    }

    @Override
    protected void setRootNsContext(NamespaceContext namespaceContext) {
        String string;
        this._rootNsContext = namespaceContext;
        if (!this._defaultNsSet && (string = namespaceContext.getNamespaceURI("")) != null && string.length() > 0) {
            this._defaultNsURI = string;
        }
    }

    protected void appendNode(Node node) {
        if (this.isRoot()) {
            this._element.getOwnerDocument().appendChild(node);
        } else {
            this._element.appendChild(node);
        }
    }

    protected void addAttribute(String string, String string2) {
        this._element.setAttribute(string, string2);
    }

    protected void addAttribute(String string, String string2, String string3) {
        this._element.setAttributeNS(string, string2, string3);
    }

    public void appendChild(Node node) {
        this._element.appendChild(node);
    }
}

