/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.impl;

import org.codehaus.stax2.XMLStreamLocation2;

public class LocationImpl
implements XMLStreamLocation2 {
    private static final LocationImpl sEmptyLocation = new LocationImpl("", "", -1, -1, -1);
    final String mPublicId;
    final String mSystemId;
    final int mCharOffset;
    final int mCol;
    final int mRow;
    transient String mDesc = null;

    public LocationImpl(String string, String string2, int n, int n2, int n3) {
        this.mPublicId = string;
        this.mSystemId = string2;
        this.mCharOffset = n < 0 ? Integer.MAX_VALUE : n;
        this.mCol = n3;
        this.mRow = n2;
    }

    public static LocationImpl fromZeroBased(String string, String string2, int n, int n2, int n3) {
        return new LocationImpl(string, string2, n, n2 + 1, n3 + 1);
    }

    public static LocationImpl getEmptyLocation() {
        return sEmptyLocation;
    }

    public int getCharacterOffset() {
        return this.mCharOffset;
    }

    public int getColumnNumber() {
        return this.mCol;
    }

    public int getLineNumber() {
        return this.mRow;
    }

    public String getPublicId() {
        return this.mPublicId;
    }

    public String getSystemId() {
        return this.mSystemId;
    }

    public XMLStreamLocation2 getContext() {
        return null;
    }

    public String toString() {
        if (this.mDesc == null) {
            StringBuffer stringBuffer = new StringBuffer(100);
            this.appendDesc(stringBuffer);
            this.mDesc = stringBuffer.toString();
        }
        return this.mDesc;
    }

    private void appendDesc(StringBuffer stringBuffer) {
        String string;
        if (this.mSystemId != null) {
            stringBuffer.append("[row,col,system-id]: ");
            string = this.mSystemId;
        } else if (this.mPublicId != null) {
            stringBuffer.append("[row,col,public-id]: ");
            string = this.mPublicId;
        } else {
            stringBuffer.append("[row,col {unknown-source}]: ");
            string = null;
        }
        stringBuffer.append('[');
        stringBuffer.append(this.mRow);
        stringBuffer.append(',');
        stringBuffer.append(this.mCol);
        if (string != null) {
            stringBuffer.append(',');
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        stringBuffer.append(']');
    }
}

