/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.in.CharBasedPNameTable;
import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.InputCharTypes;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.PNameC;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamLocation2;

public final class ReaderScanner
extends XmlScanner {
    private static final XmlCharTypes sCharTypes = InputCharTypes.getLatin1CharTypes();
    protected Reader _in;
    protected char[] _inputBuffer;
    protected int _inputPtr;
    protected int _inputEnd;
    protected int mTmpChar = 0;
    protected final CharBasedPNameTable _symbols;
    protected int mPastChars;
    protected int mRowStartOffset;

    public ReaderScanner(ReaderConfig readerConfig, Reader reader, char[] cArray, int n, int n2) {
        super(readerConfig);
        this._in = reader;
        this._inputBuffer = cArray;
        this._inputPtr = n;
        this._inputEnd = n2;
        this.mPastChars = 0;
        this.mRowStartOffset = 0;
        this._symbols = readerConfig.getCBSymbols();
    }

    public ReaderScanner(ReaderConfig readerConfig, Reader reader) {
        super(readerConfig);
        this._in = reader;
        this._inputBuffer = readerConfig.allocFullCBuffer(4000);
        this._inputEnd = 0;
        this._inputPtr = 0;
        this.mPastChars = 0;
        this.mRowStartOffset = 0;
        this._symbols = readerConfig.getCBSymbols();
    }

    @Override
    protected void _releaseBuffers() {
        super._releaseBuffers();
        if (this._symbols.maybeDirty()) {
            this._config.updateCBSymbols(this._symbols);
        }
        if (this._in != null && this._inputBuffer != null) {
            this._config.freeFullCBuffer(this._inputBuffer);
            this._inputBuffer = null;
        }
    }

    @Override
    protected void _closeSource() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    @Override
    public final int nextFromProlog(boolean bl) throws XMLStreamException {
        char c;
        if (this._tokenIncomplete) {
            this.skipToken();
        }
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return -1;
            }
            if ((c = this._inputBuffer[this._inputPtr++] & 0xFF) == '<') break;
            if (c == ' ') continue;
            if (c == '\n') {
                this.markLF();
                continue;
            }
            if (c == '\r') {
                if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                    this.markLF();
                    return -1;
                }
                if (this._inputBuffer[this._inputPtr] == '\n') {
                    ++this._inputPtr;
                }
                this.markLF();
                continue;
            }
            if (c == '\t') continue;
            this.reportPrologUnexpChar(bl, c, null);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed(5);
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '!') {
            return this.handlePrologDeclStart(bl);
        }
        if (c == '?') {
            return this.handlePIStart();
        }
        if (c == '/' || !bl) {
            this.reportPrologUnexpChar(bl, c, " (unbalanced start/end tags?)");
        }
        return this.handleStartElement(c);
    }

    @Override
    public final int nextFromTree() throws XMLStreamException {
        if (this._tokenIncomplete) {
            if (this.skipToken()) {
                this._textBuilder.resetWithEmpty();
                return this._currToken;
            }
        } else if (this._currToken == 1) {
            if (this._isEmptyTag) {
                --this._depth;
                this._currToken = 2;
                return 2;
            }
        } else if (this._currToken == 2) {
            this._currElem = this._currElem.getParent();
            while (this._lastNsDecl != null && this._lastNsDecl.getLevel() >= this._depth) {
                this._lastNsDecl = this._lastNsDecl.unbind();
            }
        } else if (this._entityPending) {
            this._entityPending = false;
            this._textBuilder.resetWithEmpty();
            return 9;
        }
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            return -1;
        }
        char c = this._inputBuffer[this._inputPtr];
        if (c == '<') {
            ++this._inputPtr;
            c = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne(5);
            if (c == '!') {
                return this.handleCommentOrCdataStart();
            }
            if (c == '?') {
                return this.handlePIStart();
            }
            if (c == '/') {
                return this.handleEndElement();
            }
            return this.handleStartElement(c);
        }
        if (c == '&') {
            ++this._inputPtr;
            int n = this.handleEntityInText(false);
            if (n == 0) {
                this._currToken = 9;
                return 9;
            }
            this.mTmpChar = -n;
        } else {
            this.mTmpChar = c;
        }
        if (this._cfgLazyParsing) {
            this._tokenIncomplete = true;
        } else {
            this.finishCharacters();
        }
        this._currToken = 4;
        return 4;
    }

    protected final int handlePrologDeclStart(boolean bl) throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
                if (this._cfgLazyParsing) {
                    this._tokenIncomplete = true;
                } else {
                    this.finishComment();
                }
                this._currToken = 5;
                return 5;
            }
        } else if (c == 'D' && bl) {
            this.handleDtdStart();
            if (!this._cfgLazyParsing && this._tokenIncomplete) {
                this.finishDTD(true);
                this._tokenIncomplete = false;
            }
            return 11;
        }
        this._tokenIncomplete = true;
        this._currToken = 4;
        this.reportPrologUnexpChar(bl, c, " (expected '-' for COMMENT)");
        return this._currToken;
    }

    private final int handleDtdStart() throws XMLStreamException {
        this.matchAsciiKeyword("DOCTYPE");
        char c = this.skipInternalWs(true, "after DOCTYPE keyword, before root name");
        this._tokenName = this.parsePName(c);
        c = this.skipInternalWs(false, null);
        if (c == 'P') {
            this.matchAsciiKeyword("PUBLIC");
            c = this.skipInternalWs(true, null);
            this._publicId = this.parsePublicId(c);
            c = this.skipInternalWs(true, null);
            this._systemId = this.parseSystemId(c);
            c = this.skipInternalWs(false, null);
        } else if (c == 'S') {
            this.matchAsciiKeyword("SYSTEM");
            c = this.skipInternalWs(true, null);
            this._publicId = null;
            this._systemId = this.parseSystemId(c);
            c = this.skipInternalWs(false, null);
        } else {
            this._systemId = null;
            this._publicId = null;
        }
        if (c == '>') {
            this._tokenIncomplete = false;
            this._currToken = 11;
            return 11;
        }
        if (c != '[') {
            String string = this._systemId != null ? " (expected '[' for the internal subset, or '>' to end DOCTYPE declaration)" : " (expected a 'PUBLIC' or 'SYSTEM' keyword, '[' for the internal subset, or '>' to end DOCTYPE declaration)";
            this.reportTreeUnexpChar(c, string);
        }
        this._tokenIncomplete = true;
        this._currToken = 11;
        return 11;
    }

    protected final int handleCommentOrCdataStart() throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '-') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) != '-') {
                this.reportTreeUnexpChar(c, " (expected '-' for COMMENT)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishComment();
            }
            this._currToken = 5;
            return 5;
        }
        if (c == '[') {
            this._currToken = 12;
            for (int i = 0; i < 6; ++i) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishCData();
            }
            return 12;
        }
        this.reportTreeUnexpChar(c, " (expected either '-' for COMMENT or '[CDATA[' for CDATA section)");
        return -1;
    }

    protected final int handlePIStart() throws XMLStreamException {
        this._currToken = 3;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        char c = this._inputBuffer[this._inputPtr++];
        this._tokenName = this.parsePName(c);
        String string = this._tokenName.getLocalName();
        if (string.length() == 3 && string.equalsIgnoreCase("xml") && this._tokenName.getPrefix() == null) {
            this.reportInputProblem(ErrorConsts.ERR_WF_PI_XML_TARGET);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
            while (true) {
                if (c == '\n') {
                    this.markLF();
                } else if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                } else if (c != ' ' && c != '\t') {
                    this.throwInvalidSpace(c);
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr]) > ' ') break;
                ++this._inputPtr;
            }
            if (this._cfgLazyParsing) {
                this._tokenIncomplete = true;
            } else {
                this.finishPI();
            }
        } else {
            if (c != '?') {
                this.reportMissingPISpace(c);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) != '>') {
                this.reportMissingPISpace(c);
            }
            this._textBuilder.resetWithEmpty();
            this._tokenIncomplete = false;
        }
        return 3;
    }

    protected final int handleCharEntity() throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        char c = this._inputBuffer[this._inputPtr++];
        int n = 0;
        if (c == 'x') {
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) != ';') {
                    n <<= 4;
                    if (c <= '9' && c >= '0') {
                        n += c - 48;
                    } else if (c >= 'a' && c <= 'f') {
                        n += 10 + (c - 97);
                    } else if (c >= 'A' && c <= 'F') {
                        n += 10 + (c - 65);
                    } else {
                        this.throwUnexpectedChar(c, "; expected a hex digit (0-9a-fA-F)");
                    }
                    if (n <= 0x10FFFF) continue;
                    this.reportEntityOverflow();
                    continue;
                }
                break;
            }
        } else {
            while (c != ';') {
                if (c <= '9' && c >= '0') {
                    if ((n = n * 10 + (c - 48)) > 0x10FFFF) {
                        this.reportEntityOverflow();
                    }
                } else {
                    this.throwUnexpectedChar(c, "; expected a decimal number");
                }
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                c = this._inputBuffer[this._inputPtr++];
            }
        }
        if (n >= 55296) {
            if (n < 57344) {
                this.reportInvalidXmlChar(n);
            }
            if (n == 65534 || n == 65535) {
                this.reportInvalidXmlChar(n);
            }
        } else if (!(n >= 32 || n == 10 || n == 13 || n == 9 || this._xml11 && n != 0)) {
            this.reportInvalidXmlChar(n);
        }
        return n;
    }

    protected final int handleStartElement(char c) throws XMLStreamException {
        int n;
        boolean bl;
        this._currToken = 1;
        this._currNsCount = 0;
        PName pName = this.parsePName(c);
        String string = pName.getPrefix();
        if (string == null) {
            bl = true;
        } else {
            pName = this.bindName(pName, string);
            bl = pName.isBound();
        }
        this._tokenName = pName;
        this._currElem = new ElementScope(pName, this._currElem);
        int n2 = 0;
        while (true) {
            PName pName2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
                do {
                    if (c == '\n') {
                        this.markLF();
                    } else if (c == '\r') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c != ' ' && c != '\t') {
                        this.throwInvalidSpace(c);
                    }
                    if (this._inputPtr < this._inputEnd) continue;
                    this.loadMoreGuaranteed();
                } while ((c = this._inputBuffer[this._inputPtr++]) <= ' ');
            } else if (c != '/' && c != '>') {
                this.throwUnexpectedChar(c, " expected space, or '>' or \"/>\"");
            }
            if (c == '/') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) != '>') {
                    this.throwUnexpectedChar(c, " expected '>'");
                }
                this._isEmptyTag = true;
                break;
            }
            if (c == '>') {
                this._isEmptyTag = false;
                break;
            }
            if (c == '<') {
                this.reportInputProblem("Unexpected '<' character in element (missing closing '>'?)");
            }
            if ((string = (pName2 = this.parsePName(c)).getPrefix()) == null) {
                n = pName2.getLocalName() == "xmlns" ? 1 : 0;
            } else if (string == "xmlns") {
                n = 1;
            } else {
                pName2 = this.bindName(pName2, string);
                if (bl) {
                    bl = pName2.isBound();
                }
                n = 0;
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) > ' ') break;
                if (c == '\n') {
                    this.markLF();
                    continue;
                }
                if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                this.throwInvalidSpace(c);
            }
            if (c != '=') {
                this.throwUnexpectedChar(c, " expected '='");
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) > ' ') break;
                if (c == '\n') {
                    this.markLF();
                    continue;
                }
                if (c == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == ' ' || c == '\t') continue;
                this.throwInvalidSpace(c);
            }
            if (c != '\"' && c != '\'') {
                this.throwUnexpectedChar(c, " Expected a quote");
            }
            if (n != 0) {
                this.handleNsDeclaration(pName2, c);
                ++this._currNsCount;
                continue;
            }
            n2 = this.collectValue(n2, c, pName2);
        }
        int n3 = this._attrCollector.finishLastValue(n2);
        if (n3 < 0) {
            n3 = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = n3;
        ++this._depth;
        if (!bl) {
            if (!pName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            n = this._attrCount;
            for (n3 = 0; n3 < n; ++n3) {
                PName pName3 = this._attrCollector.getName(n3);
                if (pName3.isBound()) continue;
                this.reportUnboundPrefix(pName3, true);
            }
        }
        return 1;
    }

    private final int collectValue(int n, char n2, PName pName) throws XMLStreamException {
        char[] cArray = this._attrCollector.startNewValue(pName, n);
        int[] nArray = ReaderScanner.sCharTypes.ATTR_CHARS;
        block9: while (true) {
            int n3;
            int n4;
            block30: {
                int n5;
                int n6;
                if ((n4 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n4 = this._inputPtr;
                }
                if (n >= cArray.length) {
                    cArray = this._attrCollector.valueBufferFull();
                }
                if ((n6 = n4 + (cArray.length - n)) < (n5 = this._inputEnd)) {
                    n5 = n6;
                }
                while (n4 < n5) {
                    if ((n3 = this._inputBuffer[n4++]) <= 255) {
                        if (nArray[n3] != 0) {
                            this._inputPtr = n4;
                            break block30;
                        }
                    } else if (n3 >= 55296) {
                        this._inputPtr = n4;
                        break block30;
                    }
                    cArray[n++] = n3;
                }
                this._inputPtr = n4;
                continue;
            }
            if (n3 <= 255) {
                switch (nArray[n3]) {
                    case 1: {
                        n3 = this.handleInvalidXmlChar(n3);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                    }
                    case 3: {
                        this.markLF();
                    }
                    case 8: {
                        n3 = 32;
                        break;
                    }
                    case 9: {
                        this.throwUnexpectedChar(n3, "'<' not allowed in attribute value");
                    }
                    case 10: {
                        n4 = this.handleEntityInText(false);
                        if (n4 == 0) {
                            this.reportUnexpandedEntityInAttr(pName, false);
                        }
                        if (n4 >> 16 != 0) {
                            cArray[n++] = (char)(0xD800 | (n4 -= 65536) >> 10);
                            n4 = 0xDC00 | n4 & 0x3FF;
                            if (n >= cArray.length) {
                                cArray = this._attrCollector.valueBufferFull();
                            }
                        }
                        n3 = (char)n4;
                        break;
                    }
                    case 14: {
                        if (n3 == n2) break block9;
                    }
                }
            } else if (n3 >= 55296) {
                if (n3 < 57344) {
                    n4 = this.checkSurrogate((char)n3);
                    cArray[n++] = n3;
                    if (n >= cArray.length) {
                        cArray = this._attrCollector.valueBufferFull();
                    }
                    n3 = n4;
                } else if (n3 >= 65534) {
                    n3 = this.handleInvalidXmlChar(n3);
                }
            }
            cArray[n++] = n3;
        }
        return n;
    }

    private void handleNsDeclaration(PName pName, char c) throws XMLStreamException {
        int n = 0;
        char[] cArray = this._nameBuffer;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == c) break;
            if (c2 == '&') {
                int n2 = this.handleEntityInText(false);
                if (n2 == 0) {
                    this.reportUnexpandedEntityInAttr(pName, true);
                }
                if (n2 >> 16 != 0) {
                    if (n >= cArray.length) {
                        this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                    }
                    cArray[n++] = (char)(0xD800 | (n2 -= 65536) >> 10);
                    n2 = 0xDC00 | n2 & 0x3FF;
                }
                c2 = (char)n2;
            } else if (c2 == '<') {
                this.throwUnexpectedChar(c2, "'<' not allowed in attribute value");
            } else if (c2 < ' ') {
                if (c2 == '\n') {
                    this.markLF();
                } else if (c2 == '\r') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c2 = '\n';
                } else if (c2 != '\t') {
                    this.throwInvalidSpace(c2);
                }
            }
            if (n >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[n++] = c2;
        }
        if (n == 0) {
            this.bindNs(pName, "");
        } else {
            String string = this._config.canonicalizeURI(cArray, n);
            this.bindNs(pName, string);
        }
    }

    protected final int handleEndElement() throws XMLStreamException {
        char c;
        --this._depth;
        this._currToken = 2;
        this._tokenName = this._currElem.getName();
        String string = this._tokenName.getPrefixedName();
        int n = 0;
        int n2 = string.length();
        do {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == string.charAt(n)) continue;
            this.reportUnexpectedEndTag(string);
        } while (++n < n2);
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) <= ' ') {
            c = this.skipInternalWs(false, null);
        } else if (c != '>' && (c == ':' || XmlChars.is10NameChar(c))) {
            this.reportUnexpectedEndTag(string);
        }
        if (c != '>') {
            this.throwUnexpectedChar(c, " expected space or closing '>'");
        }
        return 2;
    }

    protected final int handleEntityInText(boolean bl) throws XMLStreamException {
        int n;
        String string;
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) == '#') {
            return this.handleCharEntity();
        }
        if (c == 'a') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 'm') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'p') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                        return 38;
                    }
                    string = "amp";
                } else {
                    string = "am";
                }
            } else if (c == 'p') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'o') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == 's') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                            return 39;
                        }
                        string = "apos";
                    } else {
                        string = "apo";
                    }
                } else {
                    string = "ap";
                }
            } else {
                string = "a";
            }
        } else if (c == 'l') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                    return 60;
                }
                string = "lt";
            } else {
                string = "l";
            }
        } else if (c == 'g') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                    return 62;
                }
                string = "gt";
            } else {
                string = "g";
            }
        } else if (c == 'q') {
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == 'u') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = this._inputBuffer[this._inputPtr++]) == 'o') {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == 't') {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((c = this._inputBuffer[this._inputPtr++]) == ';') {
                            return 34;
                        }
                        string = "quot";
                    } else {
                        string = "quo";
                    }
                } else {
                    string = "qu";
                }
            } else {
                string = "q";
            }
        } else {
            string = "";
        }
        int[] nArray = ReaderScanner.sCharTypes.NAME_CHARS;
        char[] cArray = this._nameBuffer;
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            cArray[n] = string.charAt(n);
        }
        while (c != ';') {
            if (c <= '\u00ff') {
                switch (nArray[c]) {
                    case 0: 
                    case 1: 
                    case 2: {
                        n2 = n > 0 ? 1 : 0;
                        break;
                    }
                    case 3: {
                        n2 = 1;
                        break;
                    }
                    default: {
                        n2 = 0;
                        break;
                    }
                }
            } else if (c < '\ue000') {
                int n3 = this.decodeSurrogate(c);
                if (n >= cArray.length) {
                    this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                }
                cArray[n++] = c;
                c = this._inputBuffer[this._inputPtr - 1];
                n2 = (n == 0 ? XmlChars.is10NameStartChar(n3) : XmlChars.is10NameChar(n3)) ? 1 : 0;
            } else if (c >= '\ufffe') {
                c = this.handleInvalidXmlChar(c);
                n2 = 0;
            } else {
                n2 = 1;
            }
            if (n2 == 0) {
                this.reportInvalidNameChar(c, n);
            }
            if (n >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[n++] = c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            c = this._inputBuffer[this._inputPtr++];
        }
        String string2 = new String(cArray, 0, n);
        this._tokenName = new PNameC(string2, null, string2, 0);
        if (this._config.willExpandEntities()) {
            this.reportInputProblem("General entity reference (&" + string2 + ";) encountered in entity expanding mode: operation not (yet) implemented");
        }
        if (bl) {
            this.reportInputProblem("General entity reference (&" + string2 + ";) encountered in attribute value, in non-entity-expanding mode: no way to handle it");
        }
        return 0;
    }

    @Override
    protected final void finishComment() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] cArray = this._inputBuffer;
        char[] cArray2 = this._textBuilder.resetWithEmpty();
        int n = 0;
        block6: while (true) {
            int n2;
            int n3;
            block27: {
                int n4;
                int n5;
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                }
                if (n >= cArray2.length) {
                    cArray2 = this._textBuilder.finishCurrentSegment();
                    n = 0;
                }
                if ((n5 = n3 + (cArray2.length - n)) < (n4 = this._inputEnd)) {
                    n4 = n5;
                }
                while (n3 < n4) {
                    if ((n2 = cArray[n3++]) <= 255) {
                        if (nArray[n2] != 0) {
                            this._inputPtr = n3;
                            break block27;
                        }
                    } else if (n2 >= 55296) {
                        this._inputPtr = n3;
                        break block27;
                    }
                    cArray2[n++] = n2;
                }
                this._inputPtr = n3;
                continue;
            }
            if (n2 <= 255) {
                switch (nArray[n2]) {
                    case 1: {
                        n2 = this.handleInvalidXmlChar(n2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (cArray[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        n2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 13: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '-') {
                            ++this._inputPtr;
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr++] == '>') break block6;
                            this.reportDoubleHyphenInComments();
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (n2 >= 55296) {
                if (n2 < 57344) {
                    n3 = this.checkSurrogate((char)n2);
                    cArray2[n++] = n2;
                    if (n >= cArray2.length) {
                        cArray2 = this._textBuilder.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = n3;
                } else if (n2 >= 65534) {
                    n2 = this.handleInvalidXmlChar(n2);
                }
            }
            cArray2[n++] = n2;
        }
        this._textBuilder.setCurrentLength(n);
    }

    @Override
    protected final void finishPI() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] cArray = this._inputBuffer;
        char[] cArray2 = this._textBuilder.resetWithEmpty();
        int n = 0;
        block5: while (true) {
            int n2;
            int n3;
            block25: {
                int n4;
                int n5;
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                }
                if (n >= cArray2.length) {
                    cArray2 = this._textBuilder.finishCurrentSegment();
                    n = 0;
                }
                if ((n5 = n3 + (cArray2.length - n)) < (n4 = this._inputEnd)) {
                    n4 = n5;
                }
                while (n3 < n4) {
                    if ((n2 = cArray[n3++]) <= 255) {
                        if (nArray[n2] != 0) {
                            this._inputPtr = n3;
                            break block25;
                        }
                    } else if (n2 >= 55296) {
                        this._inputPtr = n3;
                        break block25;
                    }
                    cArray2[n++] = n2;
                }
                this._inputPtr = n3;
                continue;
            }
            if (n2 <= 255) {
                switch (nArray[n2]) {
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (cArray[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        n2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '>') {
                            ++this._inputPtr;
                            break block5;
                        } else {
                            break;
                        }
                    }
                }
            } else if (n2 >= 55296) {
                if (n2 < 57344) {
                    n3 = this.checkSurrogate((char)n2);
                    cArray2[n++] = n2;
                    if (n >= cArray2.length) {
                        cArray2 = this._textBuilder.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = n3;
                } else if (n2 >= 65534) {
                    n2 = this.handleInvalidXmlChar(n2);
                }
            }
            cArray2[n++] = n2;
        }
        this._textBuilder.setCurrentLength(n);
    }

    @Override
    protected final void finishDTD(boolean bl) throws XMLStreamException {
        int n;
        char[] cArray = bl ? this._textBuilder.resetWithEmpty() : null;
        int n2 = 0;
        int[] nArray = ReaderScanner.sCharTypes.DTD_CHARS;
        boolean bl2 = false;
        int n3 = 0;
        block9: while (true) {
            block35: {
                int n4;
                block34: {
                    block33: {
                        if ((n4 = this._inputPtr) >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            n4 = this._inputPtr;
                        }
                        int n5 = this._inputEnd;
                        if (cArray != null) {
                            int n6;
                            if (n2 >= cArray.length) {
                                cArray = this._textBuilder.finishCurrentSegment();
                                n2 = 0;
                            }
                            if ((n6 = n4 + (cArray.length - n2)) < n5) {
                                n5 = n6;
                            }
                        }
                        while (n4 < n5) {
                            if ((n = this._inputBuffer[n4++]) <= 255) {
                                if (nArray[n] != 0) {
                                    this._inputPtr = n4;
                                    break block33;
                                }
                            } else if (n >= 55296) {
                                this._inputPtr = n4;
                                break block33;
                            }
                            if (cArray == null) continue;
                            cArray[n2++] = n;
                        }
                        this._inputPtr = n4;
                        continue;
                    }
                    if (n > 255) break block34;
                    switch (nArray[n]) {
                        case 1: {
                            n = this.handleInvalidXmlChar(n);
                        }
                        case 2: {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if (this._inputBuffer[this._inputPtr] == '\n') {
                                ++this._inputPtr;
                            }
                            this.markLF();
                            n = 10;
                            break;
                        }
                        case 3: {
                            this.markLF();
                            break;
                        }
                        case 8: {
                            if (n3 == 0) {
                                n3 = n;
                                break;
                            }
                            if (n3 == n) {
                                n3 = 0;
                                break;
                            }
                            break block35;
                        }
                        case 9: {
                            if (!bl2) {
                                bl2 = true;
                                break;
                            }
                            break block35;
                        }
                        case 10: {
                            if (n3 == 0) {
                                bl2 = false;
                                break;
                            }
                            break block35;
                        }
                        case 11: {
                            if (!bl2 && n3 == 0) break block9;
                        }
                    }
                    break block35;
                }
                if (n >= 55296) {
                    if (n < 57344) {
                        n4 = this.checkSurrogate((char)n);
                        if (cArray != null) {
                            cArray[n2++] = n;
                            if (n2 >= cArray.length) {
                                cArray = this._textBuilder.finishCurrentSegment();
                                n2 = 0;
                            }
                        }
                        n = n4;
                    } else if (n >= 65534) {
                        n = this.handleInvalidXmlChar(n);
                    }
                }
            }
            if (cArray == null) continue;
            cArray[n2++] = n;
        }
        if (cArray != null) {
            this._textBuilder.setCurrentLength(n2);
        }
        if ((n = (int)this.skipInternalWs(false, null)) != 62) {
            this.throwUnexpectedChar(n, " expected '>' after the internal subset");
        }
    }

    @Override
    protected final void finishCData() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] cArray = this._inputBuffer;
        char[] cArray2 = this._textBuilder.resetWithEmpty();
        int n = 0;
        block6: while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            block31: {
                if ((n5 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n5 = this._inputPtr;
                }
                if (n >= cArray2.length) {
                    cArray2 = this._textBuilder.finishCurrentSegment();
                    n = 0;
                }
                if ((n4 = n5 + (cArray2.length - n)) < (n3 = this._inputEnd)) {
                    n3 = n4;
                }
                while (n5 < n3) {
                    if ((n2 = cArray[n5++]) <= 255) {
                        if (nArray[n2] != 0) {
                            this._inputPtr = n5;
                            break block31;
                        }
                    } else if (n2 >= 55296) {
                        this._inputPtr = n5;
                        break block31;
                    }
                    cArray2[n++] = n2;
                }
                this._inputPtr = n5;
                continue;
            }
            if (n2 <= 255) {
                switch (nArray[n2]) {
                    case 1: {
                        n2 = this.handleInvalidXmlChar(n2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (cArray[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        n2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        n5 = 0;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((n3 = this._inputBuffer[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++n5;
                        }
                        int n6 = n4 = n3 == 62 && n5 >= 1 ? 1 : 0;
                        if (n4 != 0) {
                            --n5;
                        }
                        while (n5 > 0) {
                            cArray2[n++] = 93;
                            if (n >= cArray2.length) {
                                cArray2 = this._textBuilder.finishCurrentSegment();
                                n = 0;
                            }
                            --n5;
                        }
                        if (n4 != 0) {
                            ++this._inputPtr;
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (n2 >= 55296) {
                if (n2 < 57344) {
                    n5 = this.checkSurrogate((char)n2);
                    cArray2[n++] = n2;
                    if (n >= cArray2.length) {
                        cArray2 = this._textBuilder.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = n5;
                } else if (n2 >= 65534) {
                    n2 = this.handleInvalidXmlChar(n2);
                }
            }
            cArray2[n++] = n2;
        }
        this._textBuilder.setCurrentLength(n);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    @Override
    protected final void finishCharacters() throws XMLStreamException {
        int n;
        char[] cArray;
        int n2 = this.mTmpChar;
        if (n2 < 0) {
            n2 = -n2;
            cArray = this._textBuilder.resetWithEmpty();
            n = 0;
            if (n2 >> 16 != 0) {
                cArray[n++] = (char)(0xD800 | (n2 -= 65536) >> 10);
                n2 = 0xDC00 | n2 & 0x3FF;
            }
            cArray[n++] = (char)n2;
        } else if (n2 == 13 || n2 == 10) {
            ++this._inputPtr;
            n = this.checkInTreeIndentation((char)n2);
            if (n < 0) {
                return;
            }
            cArray = this._textBuilder.getBufferWithoutReset();
        } else {
            cArray = this._textBuilder.resetWithEmpty();
            n = 0;
        }
        int[] nArray = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] cArray2 = this._inputBuffer;
        block8: while (true) {
            int n3;
            int n4;
            block41: {
                int n5;
                int n6;
                if ((n4 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n4 = this._inputPtr;
                }
                if (n >= cArray.length) {
                    cArray = this._textBuilder.finishCurrentSegment();
                    n = 0;
                }
                if ((n6 = n4 + (cArray.length - n)) < (n5 = this._inputEnd)) {
                    n5 = n6;
                }
                while (n4 < n5) {
                    if ((n3 = cArray2[n4++]) <= 255) {
                        if (nArray[n3] != 0) {
                            this._inputPtr = n4;
                            break block41;
                        }
                    } else if (n3 >= 55296) {
                        this._inputPtr = n4;
                        break block41;
                    }
                    cArray[n++] = n3;
                }
                this._inputPtr = n4;
                continue;
            }
            if (n3 <= 255) {
                switch (nArray[n3]) {
                    case 1: {
                        n3 = this.handleInvalidXmlChar(n3);
                    }
                    case 2: {
                        n4 = this._inputPtr;
                        if (n4 >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            n4 = this._inputPtr;
                        }
                        if (cArray2[n4] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        n3 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        break block8;
                    }
                    case 10: {
                        n4 = this.handleEntityInText(false);
                        if (n4 == 0) {
                            this._entityPending = true;
                            break block8;
                        }
                        if (n4 >> 16 != 0) {
                            cArray[n++] = (char)(0xD800 | (n4 -= 65536) >> 10);
                            if (n >= cArray.length) {
                                cArray = this._textBuilder.finishCurrentSegment();
                                n = 0;
                            }
                            n4 = 0xDC00 | n4 & 0x3FF;
                        }
                        n3 = (char)n4;
                        break;
                    }
                    case 11: {
                        n4 = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((n3 = cArray2[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++n4;
                        }
                        if (n3 == 62 && n4 > 1) {
                            this.reportIllegalCDataEnd();
                        }
                        while (n4 > 1) {
                            cArray[n++] = 93;
                            if (n >= cArray.length) {
                                cArray = this._textBuilder.finishCurrentSegment();
                                n = 0;
                            }
                            --n4;
                        }
                        n3 = 93;
                    }
                }
            } else if (n3 >= 55296) {
                if (n3 < 57344) {
                    n4 = this.checkSurrogate((char)n3);
                    cArray[n++] = n3;
                    if (n >= cArray.length) {
                        cArray = this._textBuilder.finishCurrentSegment();
                        n = 0;
                    }
                    n3 = n4;
                } else if (n3 >= 65534) {
                    n3 = this.handleInvalidXmlChar(n3);
                }
            }
            cArray[n++] = n3;
        }
        this._textBuilder.setCurrentLength(n);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    @Override
    protected final void finishSpace() throws XMLStreamException {
        char[] cArray;
        int n;
        char c = (char)this.mTmpChar;
        if (c == '\r' || c == '\n') {
            n = this.checkPrologIndentation(c);
            if (n < 0) {
                return;
            }
            cArray = this._textBuilder.getBufferWithoutReset();
        } else {
            cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = c;
            n = 1;
        }
        int n2 = this._inputPtr;
        while (true) {
            int n3;
            if (n2 >= this._inputEnd) {
                if (!this.loadMore()) break;
                n2 = this._inputPtr;
            }
            if ((n3 = this._inputBuffer[n2]) > 32) break;
            ++n2;
            if (n3 == 10) {
                this.markLF(n2);
            } else if (n3 == 13) {
                if (n2 >= this._inputEnd) {
                    if (!this.loadMore()) {
                        if (n >= cArray.length) {
                            cArray = this._textBuilder.finishCurrentSegment();
                            n = 0;
                        }
                        cArray[n++] = 10;
                        break;
                    }
                    n2 = this._inputPtr;
                }
                if (this._inputBuffer[n2] == '\n') {
                    ++n2;
                }
                this.markLF(n2);
                n3 = 10;
            } else if (n3 != 32 && n3 != 9) {
                this._inputPtr = n2;
                this.throwInvalidSpace(n3);
            }
            if (n >= cArray.length) {
                cArray = this._textBuilder.finishCurrentSegment();
                n = 0;
            }
            cArray[n++] = n3;
        }
        this._inputPtr = n2;
        this._textBuilder.setCurrentLength(n);
    }

    protected final void finishCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return;
            }
            if (this._inputBuffer[this._inputPtr] == '<') {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return;
                }
                if (this._inputBuffer[this._inputPtr + 1] != '!' || this._inputBuffer[this._inputPtr + 2] != '[') {
                    return;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    char c;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                    this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.finishCoalescedCData();
                continue;
            }
            this.finishCoalescedCharacters();
            if (this._entityPending) break;
        }
    }

    protected final void finishCoalescedCData() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] cArray = this._inputBuffer;
        char[] cArray2 = this._textBuilder.getBufferWithoutReset();
        int n = this._textBuilder.getCurrentLength();
        block6: while (true) {
            int n2;
            int n3;
            int n4;
            int n5;
            block30: {
                if ((n5 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n5 = this._inputPtr;
                }
                if (n >= cArray2.length) {
                    cArray2 = this._textBuilder.finishCurrentSegment();
                    n = 0;
                }
                if ((n4 = n5 + (cArray2.length - n)) < (n3 = this._inputEnd)) {
                    n3 = n4;
                }
                while (n5 < n3) {
                    if ((n2 = cArray[n5++]) <= 255) {
                        if (nArray[n2] != 0) {
                            this._inputPtr = n5;
                            break block30;
                        }
                    } else if (n2 >= 55296) {
                        this._inputPtr = n5;
                        break block30;
                    }
                    cArray2[n++] = n2;
                }
                this._inputPtr = n5;
                continue;
            }
            if (n2 <= 255) {
                switch (nArray[n2]) {
                    case 1: {
                        n2 = this.handleInvalidXmlChar(n2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (cArray[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        n2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        n5 = 0;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((n3 = this._inputBuffer[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++n5;
                        }
                        int n6 = n4 = n3 == 62 && n5 >= 1 ? 1 : 0;
                        if (n4 != 0) {
                            --n5;
                        }
                        while (n5 > 0) {
                            cArray2[n++] = 93;
                            if (n >= cArray2.length) {
                                cArray2 = this._textBuilder.finishCurrentSegment();
                                n = 0;
                            }
                            --n5;
                        }
                        if (n4 != 0) {
                            ++this._inputPtr;
                            break block6;
                        } else {
                            break;
                        }
                    }
                }
            } else if (n2 >= 55296) {
                if (n2 < 57344) {
                    n5 = this.checkSurrogate((char)n2);
                    cArray2[n++] = n2;
                    if (n >= cArray2.length) {
                        cArray2 = this._textBuilder.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = n5;
                } else if (n2 >= 65534) {
                    n2 = this.handleInvalidXmlChar(n2);
                }
            }
            cArray2[n++] = n2;
        }
        this._textBuilder.setCurrentLength(n);
    }

    protected final void finishCoalescedCharacters() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] cArray = this._inputBuffer;
        char[] cArray2 = this._textBuilder.getBufferWithoutReset();
        int n = this._textBuilder.getCurrentLength();
        block8: while (true) {
            int n2;
            int n3;
            block34: {
                int n4;
                int n5;
                if ((n3 = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    n3 = this._inputPtr;
                }
                if (n >= cArray2.length) {
                    cArray2 = this._textBuilder.finishCurrentSegment();
                    n = 0;
                }
                if ((n5 = n3 + (cArray2.length - n)) < (n4 = this._inputEnd)) {
                    n4 = n5;
                }
                while (n3 < n4) {
                    if ((n2 = cArray[n3++]) <= 255) {
                        if (nArray[n2] != 0) {
                            this._inputPtr = n3;
                            break block34;
                        }
                    } else if (n2 >= 55296) {
                        this._inputPtr = n3;
                        break block34;
                    }
                    cArray2[n++] = n2;
                }
                this._inputPtr = n3;
                continue;
            }
            if (n2 <= 255) {
                switch (nArray[n2]) {
                    case 1: {
                        n2 = this.handleInvalidXmlChar(n2);
                    }
                    case 2: {
                        n3 = this._inputPtr;
                        if (n3 >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            n3 = this._inputPtr;
                        }
                        if (cArray[n3] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        n2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        break block8;
                    }
                    case 10: {
                        n3 = this.handleEntityInText(false);
                        if (n3 == 0) {
                            this._entityPending = true;
                            break block8;
                        }
                        if (n3 >> 16 != 0) {
                            cArray2[n++] = (char)(0xD800 | (n3 -= 65536) >> 10);
                            if (n >= cArray2.length) {
                                cArray2 = this._textBuilder.finishCurrentSegment();
                                n = 0;
                            }
                            n3 = 0xDC00 | n3 & 0x3FF;
                        }
                        n2 = (char)n3;
                        break;
                    }
                    case 11: {
                        n3 = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((n2 = cArray[this._inputPtr]) != 93) break;
                            ++this._inputPtr;
                            ++n3;
                        }
                        if (n2 == 62 && n3 > 1) {
                            this.reportIllegalCDataEnd();
                        }
                        while (n3 > 1) {
                            cArray2[n++] = 93;
                            if (n >= cArray2.length) {
                                cArray2 = this._textBuilder.finishCurrentSegment();
                                n = 0;
                            }
                            --n3;
                        }
                        n2 = 93;
                    }
                }
            } else if (n2 >= 55296) {
                if (n2 < 57344) {
                    n3 = this.checkSurrogate((char)n2);
                    cArray2[n++] = n2;
                    if (n >= cArray2.length) {
                        cArray2 = this._textBuilder.finishCurrentSegment();
                        n = 0;
                    }
                    n2 = n3;
                } else if (n2 >= 65534) {
                    n2 = this.handleInvalidXmlChar(n2);
                }
            }
            cArray2[n++] = n2;
        }
        this._textBuilder.setCurrentLength(n);
    }

    @Override
    protected final boolean skipCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return false;
            }
            if (this._inputBuffer[this._inputPtr] == '<') {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr + 1] != '!' || this._inputBuffer[this._inputPtr + 2] != '[') {
                    return false;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    char c;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((c = this._inputBuffer[this._inputPtr++]) == "CDATA[".charAt(i)) continue;
                    this.reportTreeUnexpChar(c, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.skipCData();
                continue;
            }
            if (this.skipCharacters()) break;
        }
        return true;
    }

    @Override
    protected final void skipComment() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c;
            block16: {
                int n;
                int n2;
                if ((n2 = this._inputPtr) >= (n = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n2 = this._inputPtr;
                    n = this._inputEnd;
                }
                while (n2 < n) {
                    if ((c = cArray[n2++]) <= '\u00ff') {
                        if (nArray[c] == 0) continue;
                        this._inputPtr = n2;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = n2;
                    }
                    break block16;
                }
                this._inputPtr = n2;
                continue;
            }
            if (c > '\u00ff') continue;
            switch (nArray[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (cArray[this._inputPtr] == '\n') {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != '-') break;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr++] != '>') {
                        this.reportDoubleHyphenInComments();
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipPI() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c;
            block15: {
                int n;
                int n2;
                if ((n2 = this._inputPtr) >= (n = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n2 = this._inputPtr;
                    n = this._inputEnd;
                }
                while (n2 < n) {
                    if ((c = cArray[n2++]) <= '\u00ff') {
                        if (nArray[c] == 0) continue;
                        this._inputPtr = n2;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = n2;
                    }
                    break block15;
                }
                this._inputPtr = n2;
                continue;
            }
            if (c <= '\u00ff') {
                switch (nArray[c]) {
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (cArray[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 12: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] != '>') break;
                        ++this._inputPtr;
                        return;
                    }
                }
                continue;
            }
            if (c < '\ud800') continue;
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            c = this.handleInvalidXmlChar(c);
        }
    }

    @Override
    protected final boolean skipCharacters() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.TEXT_CHARS;
        char[] cArray = this._inputBuffer;
        block8: while (true) {
            char c;
            int n;
            block19: {
                int n2;
                if ((n = this._inputPtr) >= (n2 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n = this._inputPtr;
                    n2 = this._inputEnd;
                }
                while (n < n2) {
                    if ((c = cArray[n++]) <= '\u00ff') {
                        if (nArray[c] == 0) continue;
                        this._inputPtr = n;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = n;
                    }
                    break block19;
                }
                this._inputPtr = n;
                continue;
            }
            if (c <= '\u00ff') {
                switch (nArray[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (cArray[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 9: {
                        --this._inputPtr;
                        return false;
                    }
                    case 10: {
                        n = this.handleEntityInText(false);
                        if (n != 0) continue block8;
                        return true;
                    }
                    case 11: {
                        n = 1;
                        while (true) {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            if ((c = cArray[this._inputPtr]) != ']') break;
                            ++this._inputPtr;
                            ++n;
                        }
                        if (c != '>' || n <= 1) break;
                        this.reportIllegalCDataEnd();
                    }
                }
                continue;
            }
            if (c < '\ud800') continue;
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            c = this.handleInvalidXmlChar(c);
        }
    }

    @Override
    protected final void skipCData() throws XMLStreamException {
        int[] nArray = ReaderScanner.sCharTypes.OTHER_CHARS;
        char[] cArray = this._inputBuffer;
        while (true) {
            char c;
            int n;
            block18: {
                int n2;
                if ((n = this._inputPtr) >= (n2 = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    n = this._inputPtr;
                    n2 = this._inputEnd;
                }
                while (n < n2) {
                    if ((c = cArray[n++]) <= '\u00ff') {
                        if (nArray[c] == 0) continue;
                        this._inputPtr = n;
                    } else {
                        if (c < '\ud800') continue;
                        this._inputPtr = n;
                    }
                    break block18;
                }
                this._inputPtr = n;
                continue;
            }
            if (c <= '\u00ff') {
                switch (nArray[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        n = this._inputPtr;
                        if (n >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                            n = this._inputPtr;
                        }
                        if (cArray[n] == '\n') {
                            ++n;
                            ++this._inputPtr;
                        }
                        this.markLF(n);
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 11: {
                        n = 0;
                        do {
                            if (this._inputPtr >= this._inputEnd) {
                                this.loadMoreGuaranteed();
                            }
                            ++n;
                        } while ((c = this._inputBuffer[this._inputPtr++]) == ']');
                        if (c == '>') {
                            if (n <= 1) break;
                            return;
                        }
                        --this._inputPtr;
                    }
                }
                continue;
            }
            if (c < '\ud800') continue;
            if (c < '\ue000') {
                this.checkSurrogate(c);
                continue;
            }
            if (c < '\ufffe') continue;
            c = this.handleInvalidXmlChar(c);
        }
    }

    @Override
    protected final void skipSpace() throws XMLStreamException {
        int n = this._inputPtr;
        while (true) {
            char c;
            if (n >= this._inputEnd) {
                if (!this.loadMore()) break;
                n = this._inputPtr;
            }
            if ((c = this._inputBuffer[n]) > ' ') break;
            ++n;
            if (c == '\n') {
                this.markLF(n);
                continue;
            }
            if (c == '\r') {
                if (n >= this._inputEnd) {
                    if (!this.loadMore()) break;
                    n = this._inputPtr;
                }
                if (this._inputBuffer[n] == '\n') {
                    ++n;
                }
                this.markLF(n);
                continue;
            }
            if (c == ' ' || c == '\t') continue;
            this._inputPtr = n;
            this.throwInvalidSpace(c);
        }
        this._inputPtr = n;
    }

    protected char skipInternalWs(boolean bl, String string) throws XMLStreamException {
        char c;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr++]) > ' ') {
            if (!bl) {
                return c;
            }
            this.reportTreeUnexpChar(c, " (expected white space " + string + ")");
        }
        do {
            if (c == '\n') {
                this.markLF();
            } else if (c == '\r') {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if (this._inputBuffer[this._inputPtr] == '\n') {
                    ++this._inputPtr;
                }
                this.markLF();
            } else if (c != ' ' && c != '\t') {
                this.throwInvalidSpace(c);
            }
            if (this._inputPtr < this._inputEnd) continue;
            this.loadMoreGuaranteed();
        } while ((c = this._inputBuffer[this._inputPtr++]) <= ' ');
        return c;
    }

    private final void matchAsciiKeyword(String string) throws XMLStreamException {
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            char c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = this._inputBuffer[this._inputPtr++]) == string.charAt(i)) continue;
            this.reportTreeUnexpChar(c, " (expected '" + string.charAt(i) + "' for " + string + " keyword)");
        }
    }

    protected final int checkInTreeIndentation(char c) throws XMLStreamException {
        int n;
        int n2;
        if (c == '\r') {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == '\n') {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c = this._inputBuffer[this._inputPtr]) != ' ' && c != '\t') {
            if (c == '<' && this._inputPtr + 1 < this._inputEnd && this._inputBuffer[this._inputPtr + 1] != '!') {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n3 = n2 = c == ' ' ? 32 : 8;
        for (n = 1; n <= n2; ++n) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr]) != c) {
                if (c2 != '<' || this._inputPtr + 1 >= this._inputEnd || this._inputBuffer[this._inputPtr + 1] == '!') break;
                this._textBuilder.resetWithIndentation(n, c);
                return -1;
            }
            ++this._inputPtr;
        }
        char[] cArray = this._textBuilder.resetWithEmpty();
        cArray[0] = 10;
        for (int i = 1; i <= n; ++i) {
            cArray[i] = c;
        }
        this._textBuilder.setCurrentLength(++n);
        return n;
    }

    protected final int checkPrologIndentation(char c) throws XMLStreamException {
        int n;
        if (c == '\r') {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            if (this._inputBuffer[this._inputPtr] == '\n') {
                ++this._inputPtr;
            }
        }
        this.markLF();
        if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
            this._textBuilder.resetWithIndentation(0, ' ');
            return -1;
        }
        c = this._inputBuffer[this._inputPtr];
        if (c != ' ' && c != '\t') {
            if (c == '<') {
                this._textBuilder.resetWithIndentation(0, ' ');
                return -1;
            }
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            this._textBuilder.setCurrentLength(1);
            return 1;
        }
        ++this._inputPtr;
        int n2 = 1;
        int n3 = n = c == ' ' ? 32 : 8;
        while ((this._inputPtr < this._inputEnd || this.loadMore()) && this._inputBuffer[this._inputPtr] == c) {
            ++this._inputPtr;
            if (++n2 < n) continue;
            char[] cArray = this._textBuilder.resetWithEmpty();
            cArray[0] = 10;
            for (int i = 1; i <= n2; ++i) {
                cArray[i] = c;
            }
            this._textBuilder.setCurrentLength(++n2);
            return n2;
        }
        this._textBuilder.resetWithIndentation(n2, c);
        return -1;
    }

    protected PName parsePName(char n) throws XMLStreamException {
        char[] cArray = this._nameBuffer;
        if (n < 65) {
            this.throwUnexpectedChar(n, "; expected a name start character");
        }
        cArray[0] = n;
        int n2 = n;
        int n3 = 1;
        while (true) {
            int n4;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = (n = this._inputBuffer[this._inputPtr])) < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                PName pName = this._symbols.findSymbol(cArray, 0, n3, n2);
                if (pName == null) {
                    pName = this.addPName(cArray, n3, n2);
                }
                return pName;
            }
            ++this._inputPtr;
            if (n3 >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[n3++] = n;
            n2 = n2 * 31 + n4;
        }
    }

    protected final PName addPName(char[] cArray, int n, int n2) throws XMLStreamException {
        char c = cArray[0];
        int n3 = 1;
        int n4 = -1;
        if (c < '\ud800' || c >= '\ue000') {
            if (!XmlChars.is10NameStartChar(c)) {
                this.reportInvalidNameChar(c, 0);
            }
        } else {
            if (n == 1) {
                this.reportInvalidFirstSurrogate(c);
            }
            this.checkSurrogateNameChar(c, cArray[1], 0);
            ++n3;
        }
        while (n3 < n) {
            c = cArray[n3];
            if (c < '\ud800' || c >= '\ue000') {
                if (c == ':') {
                    if (n4 >= 0) {
                        this.reportMultipleColonsInName();
                    }
                    n4 = n3;
                } else if (!XmlChars.is10NameChar(c)) {
                    this.reportInvalidNameChar(c, n3);
                }
            } else {
                if (n3 + 1 >= n) {
                    this.reportInvalidFirstSurrogate(c);
                }
                this.checkSurrogateNameChar(c, cArray[n3 + 1], n3);
            }
            ++n3;
        }
        return this._symbols.addSymbol(cArray, 0, n, n2);
    }

    protected String parsePublicId(char c) throws XMLStreamException {
        char[] cArray = this._nameBuffer;
        int n = 0;
        int[] nArray = XmlCharTypes.PUBID_CHARS;
        boolean bl = false;
        while (true) {
            char c2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c2 = this._inputBuffer[this._inputPtr++]) == c) break;
            if (c2 > '\u00ff' || nArray[c2] != 1) {
                this.throwUnexpectedChar(c2, " in public identifier");
            }
            if (c2 <= ' ') {
                bl = true;
                continue;
            }
            if (bl) {
                if (n >= cArray.length) {
                    cArray = this._textBuilder.finishCurrentSegment();
                    n = 0;
                }
                cArray[n++] = 32;
                bl = false;
            }
            if (n >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                n = 0;
            }
            cArray[n++] = c2;
        }
        return new String(cArray, 0, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String parseSystemId(char c) throws XMLStreamException {
        char[] cArray = this._nameBuffer;
        int n = 0;
        int[] nArray = ReaderScanner.sCharTypes.ATTR_CHARS;
        while (true) {
            int n2;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (nArray[n2 = this._inputBuffer[this._inputPtr++]] != 0) {
                switch (nArray[n2]) {
                    case 1: {
                        n2 = this.handleInvalidXmlChar(n2);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == '\n') {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        n2 = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 14: {
                        if (n2 != c) break;
                        return new String(cArray, 0, n);
                    }
                }
            }
            if (n >= cArray.length) {
                this._nameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                n = 0;
            }
            cArray[n++] = n2;
        }
    }

    private char checkSurrogate(char c) throws XMLStreamException {
        int n;
        char c2;
        if (c >= '\udc00') {
            this.reportInvalidFirstSurrogate(c);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) < '\udc00' || c2 >= '\ue000') {
            this.reportInvalidSecondSurrogate(c2);
        }
        if ((n = (c - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(n);
        }
        return c2;
    }

    private int checkSurrogateNameChar(char c, char c2, int n) throws XMLStreamException {
        int n2;
        if (c >= '\udc00') {
            this.reportInvalidFirstSurrogate(c);
        }
        if (c2 < '\udc00' || c2 >= '\ue000') {
            this.reportInvalidSecondSurrogate(c2);
        }
        if ((n2 = (c - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(n2);
        }
        this.reportInvalidNameChar(n2, n);
        return n2;
    }

    private int decodeSurrogate(char c) throws XMLStreamException {
        int n;
        char c2;
        if (c >= '\udc00') {
            this.reportInvalidFirstSurrogate(c);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c2 = this._inputBuffer[this._inputPtr++]) < '\udc00' || c2 >= '\ue000') {
            this.reportInvalidSecondSurrogate(c2);
        }
        if ((n = (c - 55296 << 10) + 65536) > 0x10FFFF) {
            this.reportInvalidXmlChar(n);
        }
        return n;
    }

    private void reportInvalidFirstSurrogate(char c) throws XMLStreamException {
        this.reportInputProblem("Invalid surrogate character (code 0x" + Integer.toHexString(c) + "): can not start a surrogate pair");
    }

    private void reportInvalidSecondSurrogate(char c) throws XMLStreamException {
        this.reportInputProblem("Invalid surrogate character (code " + Integer.toHexString(c) + "): is not legal as the second part of a surrogate pair");
    }

    @Override
    public XMLStreamLocation2 getCurrentLocation() {
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), this.mPastChars + this._inputPtr, this._currRow, this._inputPtr - this.mRowStartOffset);
    }

    @Override
    public int getCurrentLineNr() {
        return this._currRow + 1;
    }

    @Override
    public int getCurrentColumnNr() {
        return this._inputPtr - this.mRowStartOffset;
    }

    protected final void markLF(int n) {
        this.mRowStartOffset = n;
        ++this._currRow;
    }

    protected final void markLF() {
        this.mRowStartOffset = this._inputPtr;
        ++this._currRow;
    }

    @Override
    protected final boolean loadMore() throws XMLStreamException {
        if (this._in == null) {
            this._inputEnd = 0;
            return false;
        }
        this.mPastChars += this._inputEnd;
        this.mRowStartOffset -= this._inputEnd;
        this._inputPtr = 0;
        try {
            int n = this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
            if (n < 1) {
                this._inputEnd = 0;
                if (n == 0) {
                    this.reportInputProblem("Reader returned 0 bytes, even when asked to read up to " + this._inputBuffer.length);
                }
                return false;
            }
            this._inputEnd = n;
            return true;
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }

    protected final char loadOne() throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(this._currToken));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final char loadOne(int n) throws XMLStreamException {
        if (!this.loadMore()) {
            this.reportInputProblem("Unexpected end-of-input when trying to parse " + ErrorConsts.tokenTypeDesc(n));
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected final boolean loadAndRetain(int n) throws XMLStreamException {
        if (this._in == null) {
            return false;
        }
        this.mPastChars += this._inputPtr;
        this.mRowStartOffset -= this._inputPtr;
        int n2 = this._inputEnd - this._inputPtr;
        System.arraycopy(this._inputBuffer, this._inputPtr, this._inputBuffer, 0, n2);
        this._inputPtr = 0;
        this._inputEnd = n2;
        try {
            do {
                int n3;
                int n4;
                if ((n4 = this._in.read(this._inputBuffer, n2, n3 = this._inputBuffer.length - n2)) < 1) {
                    if (n4 == 0) {
                        this.reportInputProblem("Reader returned 0 bytes, even when asked to read up to " + n3);
                    }
                    return false;
                }
                this._inputEnd += n4;
            } while (this._inputEnd < n);
            return true;
        }
        catch (IOException iOException) {
            throw new IoStreamException(iOException);
        }
    }
}

