/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.io.UTF8Writer;
import com.fasterxml.aalto.out.CharWName;
import com.fasterxml.aalto.out.OutputCharTypes;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.out.XmlWriter;
import com.fasterxml.aalto.util.XmlCharTypes;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.ri.typed.AsciiValueEncoder;

public final class CharXmlWriter
extends XmlWriter {
    static final int DEFAULT_SMALL_SIZE = 200;
    static final int DEFAULT_FULL_BUFFER_SIZE = 1000;
    protected final int mSmallWriteSize;
    protected Writer _out;
    protected char[] _outputBuffer;
    protected int _outputPtr;
    protected final int _outputBufferLen;
    private final int mEncHighChar;
    private final int mTableCheckEnd;
    final XmlCharTypes mCharTypes;

    public CharXmlWriter(WriterConfig writerConfig, Writer writer) {
        super(writerConfig);
        this._out = writer;
        this._outputBuffer = writerConfig.allocFullCBuffer(1000);
        this._outputBufferLen = this._outputBuffer.length;
        this.mSmallWriteSize = 200;
        this._outputPtr = 0;
        int n = CharXmlWriter.guessEncodingBitSize(writerConfig);
        this.mEncHighChar = n < 16 ? 1 << n : 65534;
        this.mTableCheckEnd = Math.min(256, this.mEncHighChar);
        this.mCharTypes = n < 8 ? OutputCharTypes.getAsciiCharTypes() : OutputCharTypes.getLatin1CharTypes();
    }

    @Override
    protected int getOutputPtr() {
        return this._outputPtr;
    }

    @Override
    public int getHighestEncodable() {
        return this.mEncHighChar;
    }

    @Override
    public WName constructName(String string) {
        return new CharWName(string);
    }

    @Override
    public WName constructName(String string, String string2) {
        return new CharWName(string, string2);
    }

    @Override
    public void _releaseBuffers() {
        super._releaseBuffers();
        if (this._outputBuffer != null) {
            this._config.freeFullCBuffer(this._outputBuffer);
            this._outputBuffer = null;
        }
    }

    @Override
    public void _closeTarget(boolean bl) throws IOException {
        if (this._out != null && (bl || this._out instanceof UTF8Writer)) {
            this._out.close();
            this._out = null;
        }
    }

    @Override
    public final void flush() throws IOException {
        if (this._out != null) {
            this.flushBuffer();
            this._out.flush();
        }
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) throws IOException {
        if (this._out == null) {
            return;
        }
        if (n2 < this.mSmallWriteSize) {
            if (this._outputPtr + n2 > this._outputBufferLen) {
                this.flushBuffer();
            }
            System.arraycopy(cArray, n, this._outputBuffer, this._outputPtr, n2);
            this._outputPtr += n2;
            return;
        }
        int n3 = this._outputPtr;
        if (n3 > 0) {
            if (n3 < this.mSmallWriteSize) {
                int n4 = this.mSmallWriteSize - n3;
                System.arraycopy(cArray, n, this._outputBuffer, n3, n4);
                this._outputPtr = n3 + n4;
                n2 -= n4;
                n += n4;
            }
            this.flushBuffer();
        }
        this._out.write(cArray, n, n2);
    }

    @Override
    public void writeRaw(String string, int n, int n2) throws IOException {
        if (this._out == null) {
            return;
        }
        if (n2 < this.mSmallWriteSize) {
            if (this._outputPtr + n2 >= this._outputBufferLen) {
                this.flushBuffer();
            }
            string.getChars(n, n + n2, this._outputBuffer, this._outputPtr);
            this._outputPtr += n2;
            return;
        }
        int n3 = this._outputPtr;
        if (n3 > 0) {
            if (n3 < this.mSmallWriteSize) {
                int n4 = this.mSmallWriteSize - n3;
                string.getChars(n, n + n4, this._outputBuffer, n3);
                this._outputPtr = n3 + n4;
                n2 -= n4;
                n += n4;
            }
            this.flushBuffer();
        }
        this._out.write(string, n, n2);
    }

    public final void writeCDataStart() throws IOException {
        this.fastWriteRaw("<![CDATA[");
    }

    public final void writeCDataEnd() throws IOException {
        this.fastWriteRaw("]]>");
    }

    public final void writeCommentStart() throws IOException {
        this.fastWriteRaw("<!--");
    }

    public final void writeCommentEnd() throws IOException {
        this.fastWriteRaw("-->");
    }

    @Override
    public int writeCData(String string) throws IOException, XMLStreamException {
        int n;
        this.writeCDataStart();
        int n2 = 0;
        for (int i = string.length(); i > 0; i -= n) {
            char[] cArray = this._copyBuffer;
            int n3 = cArray.length;
            n = i < n3 ? i : n3;
            string.getChars(n2, n2 + n, cArray, 0);
            int n4 = this.writeCDataContents(cArray, 0, n);
            if (n4 >= 0) {
                return n2 + n4;
            }
            n2 += n;
        }
        this.writeCDataEnd();
        return -1;
    }

    @Override
    public int writeCData(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        this.writeCDataStart();
        int n3 = this.writeCDataContents(cArray, n, n2);
        if (n3 < 0) {
            this.writeCDataEnd();
        }
        return -1;
    }

    private int writeCDataContents(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        n2 += n;
        int n3 = n;
        block6: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            int n4 = this.mTableCheckEnd;
            while ((c = cArray[n]) < n4 && nArray[c] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = c;
                if (++n < n2) continue;
                break block6;
            }
            if ((c = cArray[n++]) < n4) {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("CDATA block", c);
                    }
                    case 17: {
                        if (n - n3 < 3 || cArray[n - 2] != ']' || cArray[n - 3] != ']') break;
                        --n;
                        this.writeCDataEnd();
                        this.writeCDataStart();
                    }
                }
            } else if (c >= this.mEncHighChar) {
                this.reportFailedEscaping("CDATA block", c);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c;
        }
        return -1;
    }

    @Override
    public void writeCharacters(String string) throws IOException, XMLStreamException {
        int n;
        if (this._out == null) {
            return;
        }
        int n2 = 0;
        for (int i = string.length(); i > 0; i -= n) {
            char[] cArray = this._copyBuffer;
            int n3 = cArray.length;
            n = i < n3 ? i : n3;
            string.getChars(n2, n2 + n, cArray, 0);
            this.writeCharacters(cArray, 0, n);
            n2 += n;
        }
    }

    @Override
    public void writeCharacters(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        n2 += n;
        block6: while (n < n2) {
            char c;
            block14: {
                block13: {
                    int[] nArray = this.mCharTypes.TEXT_CHARS;
                    int n3 = this.mTableCheckEnd;
                    while ((c = cArray[n]) < n3 && nArray[c] == 0) {
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = c;
                        if (++n < n2) continue;
                        break block6;
                    }
                    if ((c = cArray[n++]) >= n3) break block13;
                    switch (nArray[c]) {
                        case 1: {
                            this.reportInvalidChar(c);
                        }
                        case 11: {
                            if (n < n2 && cArray[n] != '>') break;
                        }
                        case 4: 
                        case 9: 
                        case 10: {
                            this.writeAsEntity(c);
                            continue block6;
                        }
                        case 2: {
                            if (this._config.willEscapeCR()) {
                                this.writeAsEntity(c);
                                continue block6;
                            } else {
                                break;
                            }
                        }
                    }
                    break block14;
                }
                if (c >= this.mEncHighChar) {
                    this.writeAsEntity(c);
                    continue;
                }
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c;
        }
    }

    @Override
    public void writeSpace(String string) throws IOException, XMLStreamException {
        int n;
        if (this._out == null) {
            return;
        }
        int n2 = 0;
        for (int i = string.length(); i > 0; i -= n) {
            char[] cArray = this._copyBuffer;
            int n3 = cArray.length;
            n = i < n3 ? i : n3;
            string.getChars(n2, n2 + n, cArray, 0);
            this.writeSpace(cArray, 0, n);
            n2 += n;
        }
    }

    @Override
    public void writeSpace(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        n2 += n;
        while (n < n2) {
            char c;
            if ((c = cArray[n++]) > ' ' && (!this._config.isXml11() || c != '\u0085' && c != '\u2028')) {
                this.reportNwfContent(ErrorConsts.WERR_SPACE_CONTENT, c, n - 1);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c;
        }
    }

    @Override
    public int writeComment(String string) throws IOException, XMLStreamException {
        int n;
        if (this._out == null) {
            return -1;
        }
        this.writeCommentStart();
        int n2 = 0;
        int n3 = -1;
        for (int i = string.length(); i > 0; i -= n) {
            char[] cArray = this._copyBuffer;
            n = cArray.length;
            if (n > i) {
                n = i;
            }
            string.getChars(n2, n2 + n, cArray, 0);
            n3 = this.writeCommentContents(cArray, 0, n, false);
            if (n3 >= 0) break;
            n2 += n;
        }
        if (n3 >= 0) {
            return n2 + n3;
        }
        this.writeCommentEnd();
        return -1;
    }

    private int writeCommentContents(char[] cArray, int n, int n2, boolean bl) throws IOException, XMLStreamException {
        n2 += n;
        block6: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            int n3 = this.mTableCheckEnd;
            while ((c = cArray[n]) < n3 && nArray[c] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = c;
                if (++n < n2) continue;
                break block6;
            }
            if ((c = cArray[n++]) < n3) {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("comment", c);
                    }
                    case 13: {
                        if (n != n2 && cArray[n] != '-') break;
                        if (!this._config.willFixContent()) {
                            return n - 1;
                        }
                        if (this._outputPtr >= this._outputBufferLen) {
                            this.flushBuffer();
                        }
                        this._outputBuffer[this._outputPtr++] = 32;
                    }
                }
            } else if (c >= this.mEncHighChar) {
                this.reportFailedEscaping("comment", c);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c;
        }
        return -1;
    }

    @Override
    public void writeDTD(String string) throws IOException, XMLStreamException {
        this.writeRaw(string, 0, string.length());
    }

    @Override
    public void writeDTD(WName wName, String string, String string2, String string3) throws IOException, XMLStreamException {
        this.fastWriteRaw("<!DOCTYPE ");
        this.writeName(wName);
        if (string != null) {
            if (string2 != null) {
                this.fastWriteRaw(" PUBLIC \"");
                this.fastWriteRaw(string2);
                this.fastWriteRaw("\" \"");
            } else {
                this.fastWriteRaw(" SYSTEM \"");
            }
            this.fastWriteRaw(string);
            this.fastWriteRaw('\"');
        }
        if (string3 != null && string3.length() > 0) {
            this.fastWriteRaw(' ', '[');
            this.fastWriteRaw(string3);
            this.fastWriteRaw(']');
        }
        this.fastWriteRaw('>');
    }

    @Override
    public void writeEntityReference(WName wName) throws IOException, XMLStreamException {
        this.fastWriteRaw('&');
        this.writeName(wName);
        this.fastWriteRaw(';');
    }

    @Override
    public void writeXmlDeclaration(String string, String string2, String string3) throws IOException, XMLStreamException {
        this.fastWriteRaw("<?xml version='");
        this.fastWriteRaw(string);
        this.fastWriteRaw('\'');
        if (string2 != null && string2.length() > 0) {
            this.fastWriteRaw(" encoding='");
            this.fastWriteRaw(string2);
            this.fastWriteRaw('\'');
        }
        if (string3 != null) {
            this.fastWriteRaw(" standalone='");
            this.fastWriteRaw(string3);
            this.fastWriteRaw('\'');
        }
        this.fastWriteRaw('?', '>');
    }

    @Override
    public int writePI(WName wName, String string) throws IOException, XMLStreamException {
        this.fastWriteRaw('<', '?');
        this.writeName(wName);
        if (string != null && string.length() > 0) {
            int n;
            int n2 = 0;
            int n3 = -1;
            this.fastWriteRaw(' ');
            for (int i = string.length(); i > 0; i -= n) {
                char[] cArray = this._copyBuffer;
                n = cArray.length;
                if (n > i) {
                    n = i;
                }
                string.getChars(n2, n2 + n, cArray, 0);
                n3 = this.writePIContents(cArray, 0, n);
                if (n3 >= 0) break;
                n2 += n;
            }
            if (n3 >= 0) {
                return n2 + n3;
            }
        }
        this.fastWriteRaw('?', '>');
        return -1;
    }

    private int writePIContents(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        n2 += n;
        block6: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.OTHER_CHARS;
            int n3 = this.mTableCheckEnd;
            while ((c = cArray[n]) < n3 && nArray[c] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = c;
                if (++n < n2) continue;
                break block6;
            }
            if ((c = cArray[n++]) < n3) {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                    case 4: {
                        this.reportFailedEscaping("processing instruction", c);
                    }
                    case 12: {
                        if (n >= n2 || cArray[n] != '>') break;
                        return n;
                    }
                }
            } else if (c >= this.mEncHighChar) {
                this.reportFailedEscaping("processing instruction", c);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c;
        }
        return -1;
    }

    @Override
    public void writeStartTagStart(WName wName) throws IOException, XMLStreamException {
        int n = this._outputPtr;
        int n2 = wName.serializedLength();
        if (n + n2 + 1 > this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
            if (n2 >= this._outputBufferLen) {
                this._out.write(60);
                wName.writeChars(this._out);
                return;
            }
            n = this._outputPtr;
        }
        char[] cArray = this._outputBuffer;
        cArray[n++] = 60;
        wName.appendChars(cArray, n);
        this._outputPtr = n + n2;
    }

    @Override
    public void writeStartTagEnd() throws IOException, XMLStreamException {
        this.fastWriteRaw('>');
    }

    @Override
    public void writeStartTagEmptyEnd() throws IOException {
        int n = this._outputPtr;
        if (n + 2 > this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
            n = this._outputPtr;
        }
        char[] cArray = this._outputBuffer;
        cArray[n++] = 47;
        cArray[n++] = 62;
        this._outputPtr = n;
    }

    @Override
    public void writeEndTag(WName wName) throws IOException, XMLStreamException {
        int n = this._outputPtr;
        int n2 = wName.serializedLength();
        if (n + n2 + 3 > this._outputBufferLen) {
            this.flushBuffer();
            if (n2 + 3 > this._outputBufferLen) {
                this._out.write(60);
                this._out.write(47);
                wName.writeChars(this._out);
                this._outputBuffer[this._outputPtr++] = 62;
                return;
            }
            n = this._outputPtr;
        }
        char[] cArray = this._outputBuffer;
        cArray[n++] = 60;
        cArray[n++] = 47;
        wName.appendChars(cArray, n);
        n += n2;
        cArray[n++] = 62;
        this._outputPtr = n;
    }

    @Override
    public void writeAttribute(WName wName, String string) throws IOException, XMLStreamException {
        int n;
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(wName);
        this.fastWriteRaw('=', '\"');
        int n2 = n = string == null ? 0 : string.length();
        if (n > 0) {
            this.writeAttrValue(string, n);
        }
        this.fastWriteRaw('\"');
    }

    @Override
    public void writeAttribute(WName wName, char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(wName);
        this.fastWriteRaw('=', '\"');
        if (n2 > 0) {
            this.writeAttrValue(cArray, n, n2);
        }
        this.fastWriteRaw('\"');
    }

    private final void writeAttrValue(String string, int n) throws IOException, XMLStreamException {
        int n2 = 0;
        while (n > 0) {
            char[] cArray = this._copyBuffer;
            int n3 = cArray.length;
            int n4 = n < n3 ? n : n3;
            string.getChars(n2, n2 + n4, cArray, 0);
            this.writeAttrValue(cArray, 0, n4);
            n2 += n4;
            n -= n4;
        }
    }

    private final void writeAttrValue(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        if (this._outputPtr + n2 > this._outputBufferLen) {
            this.writeSplitAttrValue(cArray, n, n2);
            return;
        }
        n2 += n;
        block5: while (n < n2) {
            char c;
            block11: {
                block10: {
                    int[] nArray = this.mCharTypes.ATTR_CHARS;
                    int n3 = this.mTableCheckEnd;
                    while ((c = cArray[n]) < n3 && nArray[c] == 0) {
                        this._outputBuffer[this._outputPtr++] = c;
                        if (++n < n2) continue;
                        break block5;
                    }
                    if ((c = cArray[n++]) >= n3) break block10;
                    switch (nArray[c]) {
                        case 1: {
                            this.reportInvalidChar(c);
                        }
                        case 4: 
                        case 9: 
                        case 10: 
                        case 14: {
                            break block11;
                        }
                        case 2: 
                        case 3: {
                            break block11;
                        }
                        default: {
                            this._outputBuffer[this._outputPtr++] = c;
                            break;
                        }
                    }
                    continue;
                }
                if (c < this.mEncHighChar) {
                    this._outputBuffer[this._outputPtr++] = c;
                    continue;
                }
            }
            this.writeAsEntity(c);
            if (n2 - n < this._outputBufferLen - this._outputPtr) continue;
            this.flushBuffer();
        }
    }

    private final void writeSplitAttrValue(char[] cArray, int n, int n2) throws IOException, XMLStreamException {
        n2 += n;
        block5: while (n < n2) {
            char c;
            int[] nArray = this.mCharTypes.ATTR_CHARS;
            int n3 = this.mTableCheckEnd;
            while ((c = cArray[n]) < n3 && nArray[c] == 0) {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = c;
                if (++n < n2) continue;
                break block5;
            }
            if ((c = cArray[n++]) < n3) {
                switch (nArray[c]) {
                    case 1: {
                        this.reportInvalidChar(c);
                    }
                    case 4: 
                    case 9: 
                    case 10: 
                    case 14: {
                        this.writeAsEntity(c);
                        continue block5;
                    }
                    case 2: 
                    case 3: {
                        this.writeAsEntity(c);
                        continue block5;
                    }
                }
            } else if (c >= this.mEncHighChar) {
                this.writeAsEntity(c);
                continue;
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = c;
        }
    }

    @Override
    public void writeTypedValue(AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        int n = this._outputBufferLen - this._outputPtr;
        if (asciiValueEncoder.bufferNeedsFlush(n)) {
            this.flush();
        }
        while (true) {
            this._outputPtr = asciiValueEncoder.encodeMore(this._outputBuffer, this._outputPtr, this._outputBufferLen);
            if (asciiValueEncoder.isCompleted()) break;
            this.flushBuffer();
        }
    }

    @Override
    public final void writeAttribute(WName wName, AsciiValueEncoder asciiValueEncoder) throws IOException, XMLStreamException {
        if (this._out == null) {
            return;
        }
        this.fastWriteRaw(' ');
        this.writeName(wName);
        this.fastWriteRaw('=', '\"');
        this.writeTypedValue(asciiValueEncoder);
        this.fastWriteRaw('\"');
    }

    private final void flushBuffer() throws IOException {
        if (this._outputPtr > 0 && this._out != null) {
            int n = this._outputPtr;
            this.mLocPastChars += n;
            this.mLocRowStartOffset -= n;
            this._outputPtr = 0;
            this._out.write(this._outputBuffer, 0, n);
        }
    }

    protected final void writeName(WName wName) throws IOException {
        int n = this._outputPtr;
        int n2 = wName.serializedLength();
        if (n + n2 > this._outputBufferLen) {
            this.flushBuffer();
            if (n2 >= this._outputBufferLen) {
                wName.writeChars(this._out);
                return;
            }
            n = this._outputPtr;
        }
        wName.appendChars(this._outputBuffer, n);
        this._outputPtr += n2;
    }

    private final void fastWriteRaw(char c) throws IOException {
        if (this._outputPtr >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c;
    }

    private final void fastWriteRaw(char c, char c2) throws IOException {
        if (this._outputPtr + 1 >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = c;
        this._outputBuffer[this._outputPtr++] = c2;
    }

    private final void fastWriteRaw(String string) throws IOException {
        int n = this._outputPtr;
        int n2 = string.length();
        if (n + n2 >= this._outputBufferLen) {
            if (this._out == null) {
                return;
            }
            if (n2 > this._outputBufferLen) {
                this.writeRaw(string, 0, string.length());
                return;
            }
            this.flushBuffer();
            n = this._outputPtr;
        }
        string.getChars(0, n2, this._outputBuffer, n);
        this._outputPtr = n + n2;
    }

    protected int verifyCDataContent(String string) {
        int n;
        if (string != null && string.length() >= 3 && (n = string.indexOf(93)) >= 0) {
            return string.indexOf("]]>", n);
        }
        return -1;
    }

    protected int verifyCDataContent(char[] cArray, int n, int n2) {
        if (cArray != null) {
            n += 2;
            while (n < n2) {
                char c = cArray[n];
                if (c == ']') {
                    ++n;
                    continue;
                }
                if (c == '>' && cArray[n - 1] == ']' && cArray[n - 2] == ']') {
                    return n - 2;
                }
                n += 2;
            }
        }
        return -1;
    }

    protected int verifyCommentContent(String string) {
        int n = string.indexOf(45);
        if (n >= 0 && n < string.length() - 1) {
            n = string.indexOf("--", n);
        }
        return n;
    }

    protected void writeSegmentedCData(String string, int n) throws IOException {
        int n2 = 0;
        while (n >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(string, n2, n + 2 - n2);
            this.fastWriteRaw("]]>");
            n2 = n + 2;
            n = string.indexOf("]]>", n2);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(string, n2, string.length() - n2);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedCData(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4 = n + n2;
        while (n3 >= 0) {
            this.fastWriteRaw("<![CDATA[");
            this.writeRaw(cArray, n, n3 + 2 - n);
            this.fastWriteRaw("]]>");
            n = n3 + 2;
            n3 = this.verifyCDataContent(cArray, n, n4);
        }
        this.fastWriteRaw("<![CDATA[");
        this.writeRaw(cArray, n, n4 - n);
        this.fastWriteRaw("]]>");
    }

    protected void writeSegmentedComment(String string, int n) throws IOException {
        int n2 = string.length();
        if (n == n2 - 1) {
            this.fastWriteRaw("<!--");
            this.writeRaw(string, 0, string.length());
            this.fastWriteRaw(" -->");
            return;
        }
        this.fastWriteRaw("<!--");
        int n3 = 0;
        while (n >= 0) {
            this.writeRaw(string, n3, n + 1 - n3);
            this.fastWriteRaw(' ');
            n3 = n + 1;
            n = string.indexOf("--", n3);
        }
        this.writeRaw(string, n3, n2 - n3);
        if (string.charAt(n2 - 1) == '-') {
            this.fastWriteRaw(' ');
        }
        this.fastWriteRaw("-->");
    }

    protected final void writeAsEntity(int n) throws IOException {
        int n2 = this._outputPtr;
        char[] cArray = this._outputBuffer;
        if (n2 + 10 >= cArray.length) {
            this.flushBuffer();
            n2 = this._outputPtr;
        }
        cArray[n2++] = 38;
        if (n < 256) {
            if (n == 38) {
                cArray[n2++] = 97;
                cArray[n2++] = 109;
                cArray[n2++] = 112;
            } else if (n == 60) {
                cArray[n2++] = 108;
                cArray[n2++] = 116;
            } else if (n == 62) {
                cArray[n2++] = 103;
                cArray[n2++] = 116;
            } else if (n == 39) {
                cArray[n2++] = 97;
                cArray[n2++] = 112;
                cArray[n2++] = 111;
                cArray[n2++] = 115;
            } else if (n == 34) {
                cArray[n2++] = 113;
                cArray[n2++] = 117;
                cArray[n2++] = 111;
                cArray[n2++] = 116;
            } else {
                cArray[n2++] = 35;
                cArray[n2++] = 120;
                if (n >= 16) {
                    int n3 = n >> 4;
                    cArray[n2++] = (char)(n3 < 10 ? 48 + n3 : 87 + n3);
                    n &= 0xF;
                }
                cArray[n2++] = (char)(n < 10 ? 48 + n : 87 + n);
            }
        } else {
            cArray[n2++] = 35;
            cArray[n2++] = 120;
            int n4 = 20;
            int n5 = n2;
            do {
                int n6;
                if ((n6 = n >> n4 & 0xF) <= 0 && n2 == n5) continue;
                cArray[n2++] = (char)(n6 < 10 ? 48 + n6 : 87 + n6);
            } while ((n4 -= 4) > 0);
            cArray[n2++] = (char)((n &= 0xF) < 10 ? 48 + n : 87 + n);
        }
        cArray[n2++] = 59;
        this._outputPtr = n2;
    }
}

