/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

import com.fasterxml.aalto.util.XmlChars;

public final class XmlNames {
    public static int findIllegalNameChar(String string, boolean bl) {
        int n = 0;
        char c = string.charAt(n);
        int n2 = string.length();
        if (c < '\ud800' || c >= '\ue000') {
            if (bl ? !XmlChars.is11NameStartChar(c) : !XmlChars.is10NameStartChar(c)) {
                return n;
            }
        } else {
            if (n2 < 2) {
                return n;
            }
            if (!XmlNames.validSurrogateNameChar(c, string.charAt(++n))) {
                return n;
            }
        }
        ++n;
        if (bl) {
            while (n < n2) {
                c = string.charAt(n);
                if (c < '\ud800' || c >= '\ue000') {
                    if (!XmlChars.is11NameChar(c)) {
                        return n;
                    }
                } else {
                    if (n + 1 >= n2) {
                        return n;
                    }
                    if (!XmlNames.validSurrogateNameChar(c, string.charAt(n + 1))) {
                        return n;
                    }
                    ++n;
                }
                ++n;
            }
        } else {
            while (n < n2) {
                c = string.charAt(n);
                if (c < '\ud800' || c >= '\ue000') {
                    if (!XmlChars.is10NameChar(c)) {
                        return n;
                    }
                } else {
                    if (n + 1 >= n2) {
                        return n;
                    }
                    if (!XmlNames.validSurrogateNameChar(c, string.charAt(n + 1))) {
                        return n;
                    }
                    ++n;
                }
                ++n;
            }
        }
        return -1;
    }

    private static boolean validSurrogateNameChar(char c, char c2) {
        if (c >= '\udc00') {
            return false;
        }
        if (c2 < '\udc00' || c2 >= '\ue000') {
            return false;
        }
        int n = (c - 55296 << 10) + 65536;
        if (n > 0x10FFFF) {
            return false;
        }
        return false;
    }
}

