/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.fasterxml.aalto.in.ByteBasedPName;
import com.fasterxml.aalto.in.ByteBasedPNameTable;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;

public final class TestPNamePerf {
    static final int INT_A = 65;
    final int mRepCount;
    int mTmpChar = 0;
    final byte[] mInputBuffer;
    final ByteBasedPNameTable mSymbols;
    final XmlCharTypes mCharTypes;
    int mInputPtr;
    int mInputLen;
    protected int[] mQuadBuffer = new int[64];
    protected char[] mNameBuffer = new char[100];

    public TestPNamePerf(byte[] byArray, int n) {
        this.mInputBuffer = byArray;
        this.mInputLen = byArray.length;
        this.mRepCount = n;
        ReaderConfig readerConfig = new ReaderConfig();
        readerConfig.setActualEncoding("UTF-8");
        this.mSymbols = readerConfig.getBBSymbols();
        this.mCharTypes = readerConfig.getCharTypes();
    }

    public void test() throws IOException, XMLStreamException {
        int n = 0;
        while (true) {
            String string = "[null]";
            int n2 = 0;
            long l = System.currentTimeMillis();
            switch (0) {
                case 1: {
                    string = "[Regular]";
                    n2 = this.testRegularA();
                    break;
                }
                case 2: {
                    string = "[New]";
                    n2 = this.testNewA();
                    break;
                }
                case 0: {
                    string = "[New/2]";
                    n2 = this.testNew2A();
                    break;
                }
                default: {
                    throw new Error("Unexpected round, #" + n);
                }
            }
            l = System.currentTimeMillis() - l;
            System.out.println(string + " -> " + l + " msecs (total " + n2 + ")");
            if (n % 3 == 0) {
                System.out.println();
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.gc();
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    private int testRegularA() throws IOException, XMLStreamException {
        int n = 0;
        for (int i = 0; i < this.mRepCount; ++i) {
            this.mInputPtr = 0;
            n += this.testRegular();
        }
        return n;
    }

    private int testNewA() throws IOException, XMLStreamException {
        int n = 0;
        for (int i = 0; i < this.mRepCount; ++i) {
            this.mInputPtr = 0;
            n += this.testNew();
        }
        return n;
    }

    private int testNew2A() throws IOException, XMLStreamException {
        int n = 0;
        for (int i = 0; i < this.mRepCount; ++i) {
            this.mInputPtr = 0;
            n += this.testNew2();
        }
        return n;
    }

    private int testRegular() throws IOException, XMLStreamException {
        ByteBasedPName byteBasedPName = null;
        int n = 0;
        while (this.mInputPtr < this.mInputLen) {
            byte by;
            int n2;
            if ((n2 = (by = this.mInputBuffer[this.mInputPtr++]) & 0xFF) < 65) continue;
            byteBasedPName = this.parsePName(by);
            n += byteBasedPName.sizeInQuads();
        }
        return n + byteBasedPName.sizeInQuads();
    }

    private int testNew() throws IOException, XMLStreamException {
        ByteBasedPName byteBasedPName = null;
        int n = 0;
        while (this.mInputPtr < this.mInputLen) {
            byte by;
            int n2;
            if ((n2 = (by = this.mInputBuffer[this.mInputPtr++]) & 0xFF) < 65) continue;
            byteBasedPName = this.parsePNameNew(by);
            n += byteBasedPName.sizeInQuads();
        }
        return n + byteBasedPName.sizeInQuads();
    }

    private int testNew2() throws IOException, XMLStreamException {
        ByteBasedPName byteBasedPName = null;
        int n = 0;
        while (this.mInputPtr < this.mInputLen) {
            byte by;
            int n2;
            if ((n2 = (by = this.mInputBuffer[this.mInputPtr++]) & 0xFF) < 65) continue;
            byteBasedPName = this.parsePNameNew2(by);
            n += byteBasedPName.sizeInQuads();
        }
        return n + byteBasedPName.sizeInQuads();
    }

    protected ByteBasedPName parsePName(byte by) throws XMLStreamException {
        int n = by & 0xFF;
        if (n < 65) {
            this.reportError("; expected a name start character");
        }
        int[] nArray = this.mQuadBuffer;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            int n4;
            if (this.mInputPtr >= this.mInputLen) {
                this.loadMoreGuaranteed();
            }
            if ((n4 = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n, 1, n3, n2, nArray);
            }
            n = n << 8 | n4;
            n4 = (this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n, 2, n3, n2, nArray);
            }
            n = n << 8 | n4;
            n4 = (this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n, 3, n3, n2, nArray);
            }
            n = n << 8 | n4;
            n4 = (this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.loadOne()) & 0xFF;
            if (n4 < 65 && (n4 < 45 || n4 > 58 || n4 == 47)) {
                return this.findPName(n, 4, n3, n2, nArray);
            }
            if (n2 == 0) {
                n3 = n;
            } else if (n2 == 1) {
                nArray[0] = n3;
                nArray[1] = n;
            } else {
                if (n2 >= nArray.length) {
                    this.mQuadBuffer = nArray = DataUtil.growArrayBy(nArray, nArray.length);
                }
                nArray[n2] = n;
            }
            ++n2;
            n = n4;
        }
    }

    protected ByteBasedPName parsePNameNew(byte by) throws XMLStreamException {
        int n;
        if (this.mInputLen - this.mInputPtr < 8) {
            return this.parsePName(by);
        }
        int n2 = by & 0xFF;
        if (n2 < 65) {
            this.reportError("; expected a name start character");
        }
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 1);
        }
        n2 = n2 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 2);
        }
        n2 = n2 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 3);
        }
        n2 = n2 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 4);
        }
        int n3 = n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 1);
        }
        n3 = n3 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 2);
        }
        n3 = n3 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 3);
        }
        n3 = n3 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 4);
        }
        int[] nArray = this.mQuadBuffer;
        nArray[0] = n2;
        nArray[1] = n3;
        return this.parsePNameNewLong(n, nArray);
    }

    protected ByteBasedPName parsePNameNew2(byte by) throws XMLStreamException {
        int n;
        if (this.mInputLen - this.mInputPtr < 8) {
            return this.parsePName(by);
        }
        int n2 = by & 0xFF;
        if (n2 < 65) {
            this.reportError("; expected a name start character");
        }
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 1);
        }
        n2 = n2 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 2);
        }
        n2 = n2 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 3);
        }
        n2 = n2 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, 4);
        }
        return this.parsePNameNewMedium(n, n2);
    }

    protected ByteBasedPName parsePNameNewMedium(int n, int n2) throws XMLStreamException {
        int n3 = n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 1);
        }
        n3 = n3 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 2);
        }
        n3 = n3 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 3);
        }
        n3 = n3 << 8 | n;
        if ((n = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n < 45 || n > 58 || n == 47)) {
            return this.findPName(n2, n3, 4);
        }
        int[] nArray = this.mQuadBuffer;
        nArray[0] = n2;
        nArray[1] = n3;
        return this.parsePNameNewLong(n, nArray);
    }

    protected ByteBasedPName parsePNameNewLong(int n, int[] nArray) throws XMLStreamException {
        int n2 = 2;
        while (true) {
            int n3;
            if (this.mInputPtr >= this.mInputLen) {
                this.loadMoreGuaranteed();
            }
            if ((n3 = this.mInputBuffer[this.mInputPtr++] & 0xFF) < 65 && (n3 < 45 || n3 > 58 || n3 == 47)) {
                return this.findPName(n, nArray, n2, 1);
            }
            n = n << 8 | n3;
            n3 = (this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.loadOne()) & 0xFF;
            if (n3 < 65 && (n3 < 45 || n3 > 58 || n3 == 47)) {
                return this.findPName(n, nArray, n2, 2);
            }
            n = n << 8 | n3;
            n3 = (this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.loadOne()) & 0xFF;
            if (n3 < 65 && (n3 < 45 || n3 > 58 || n3 == 47)) {
                return this.findPName(n, nArray, n2, 3);
            }
            n = n << 8 | n3;
            n3 = (this.mInputPtr < this.mInputLen ? this.mInputBuffer[this.mInputPtr++] : this.loadOne()) & 0xFF;
            if (n3 < 65 && (n3 < 45 || n3 > 58 || n3 == 47)) {
                return this.findPName(n, nArray, n2, 4);
            }
            if (n2 >= nArray.length) {
                nArray = DataUtil.growArrayBy(nArray, nArray.length);
                this.mQuadBuffer = nArray;
            }
            nArray[n2] = n;
            ++n2;
            n = n3;
        }
    }

    private final ByteBasedPName findPName(int n, int n2) throws XMLStreamException {
        --this.mInputPtr;
        int n3 = ByteBasedPNameTable.calcHash(n);
        ByteBasedPName byteBasedPName = this.mSymbols.findSymbol(n3, n, 0);
        if (byteBasedPName == null) {
            this.mQuadBuffer[0] = n;
            byteBasedPName = this.addPName(n3, this.mQuadBuffer, 1, n2);
        }
        return byteBasedPName;
    }

    private final ByteBasedPName findPName(int n, int n2, int n3) throws XMLStreamException {
        --this.mInputPtr;
        int n4 = ByteBasedPNameTable.calcHash(n, n2);
        ByteBasedPName byteBasedPName = this.mSymbols.findSymbol(n4, n, n2);
        if (byteBasedPName == null) {
            this.mQuadBuffer[0] = n;
            this.mQuadBuffer[1] = n2;
            byteBasedPName = this.addPName(n4, this.mQuadBuffer, 2, n3);
        }
        return byteBasedPName;
    }

    private final ByteBasedPName findPName(int n, int[] nArray, int n2, int n3) throws XMLStreamException {
        --this.mInputPtr;
        if (n2 >= nArray.length) {
            nArray = DataUtil.growArrayBy(nArray, nArray.length);
            this.mQuadBuffer = nArray;
        }
        nArray[n2++] = n;
        int n4 = ByteBasedPNameTable.calcHash(nArray, n2);
        ByteBasedPName byteBasedPName = this.mSymbols.findSymbol(n4, nArray, n2);
        if (byteBasedPName == null) {
            byteBasedPName = this.addPName(n4, nArray, n2, n3);
        }
        return byteBasedPName;
    }

    private final ByteBasedPName findPName(int n, int n2, int n3, int n4, int[] nArray) throws XMLStreamException {
        --this.mInputPtr;
        if (n4 <= 1) {
            if (n4 == 0) {
                int n5 = ByteBasedPNameTable.calcHash(n, 0);
                ByteBasedPName byteBasedPName = this.mSymbols.findSymbol(n5, n, 0);
                if (byteBasedPName == null) {
                    nArray = this.mQuadBuffer;
                    nArray[0] = n;
                    byteBasedPName = this.addPName(n5, nArray, 1, n2);
                }
                return byteBasedPName;
            }
            int n6 = ByteBasedPNameTable.calcHash(n3, n);
            ByteBasedPName byteBasedPName = this.mSymbols.findSymbol(n6, n3, n);
            if (byteBasedPName == null) {
                nArray = this.mQuadBuffer;
                nArray[0] = n3;
                nArray[1] = n;
                byteBasedPName = this.addPName(n6, nArray, 2, n2);
            }
            return byteBasedPName;
        }
        if (n4 >= nArray.length) {
            nArray = DataUtil.growArrayBy(nArray, nArray.length);
            this.mQuadBuffer = nArray;
        }
        nArray[n4++] = n;
        int n7 = ByteBasedPNameTable.calcHash(nArray, n4);
        ByteBasedPName byteBasedPName = this.mSymbols.findSymbol(n7, nArray, n4);
        if (byteBasedPName == null) {
            byteBasedPName = this.addPName(n7, nArray, n4, n2);
        }
        return byteBasedPName;
    }

    protected final ByteBasedPName addPName(int n, int[] nArray, int n2, int n3) throws XMLStreamException {
        int n4;
        int n5;
        int n6;
        boolean bl;
        int n7;
        int n8 = (n2 << 2) - 4 + n3;
        if (n3 < 4) {
            n7 = nArray[n2 - 1];
            nArray[n2 - 1] = n7 << (4 - n3 << 3);
        } else {
            n7 = 0;
        }
        int n9 = nArray[0] >>> 24;
        int n10 = 1;
        char[] cArray = this.mNameBuffer;
        int n11 = 0;
        int[] nArray2 = this.mCharTypes.NAME_CHARS;
        switch (nArray2[n9]) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                bl = false;
                break;
            }
            case 3: {
                bl = true;
                break;
            }
            default: {
                if ((n9 & 0xE0) == 192) {
                    n9 &= 0x1F;
                    n6 = 1;
                } else if ((n9 & 0xF0) == 224) {
                    n9 &= 0xF;
                    n6 = 2;
                } else if ((n9 & 0xF8) == 240) {
                    n9 &= 7;
                    n6 = 3;
                } else {
                    this.reportError(n9);
                    n9 = 1;
                    n6 = 1;
                }
                if (n10 + n6 > n8) {
                    this.reportError(n9);
                }
                n10 += n6;
                n5 = nArray[0];
                n4 = n5 >> 16 & 0xFF;
                if ((n4 & 0xC0) != 128) {
                    this.reportError(n4);
                }
                n9 = n9 << 6 | n4 & 0x3F;
                if (n6 > 1) {
                    n4 = n5 >> 8 & 0xFF;
                    if ((n4 & 0xC0) != 128) {
                        this.reportError(n4);
                    }
                    n9 = n9 << 6 | n4 & 0x3F;
                    if (n6 > 2) {
                        n4 = n5 & 0xFF;
                        if ((n4 & 0xC0) != 128) {
                            this.reportError(n4 & 0xFF);
                        }
                        n9 = n9 << 6 | n4 & 0x3F;
                    }
                }
                bl = XmlChars.is10NameStartChar(n9);
                if (n6 <= 2) break;
                cArray[n11++] = (char)(55296 + ((n9 -= 65536) >> 10));
                n9 = 0xDC00 | n9 & 0x3FF;
            }
        }
        if (!bl) {
            this.reportError(n9);
        }
        cArray[n11++] = (char)n9;
        n6 = -1;
        while (n10 < n8) {
            n9 = nArray[n10 >> 2];
            n5 = n10 & 3;
            n9 = n9 >> (3 - n5 << 3) & 0xFF;
            ++n10;
            switch (nArray2[n9]) {
                case 0: 
                case 4: {
                    bl = false;
                    break;
                }
                case 1: {
                    if (n6 >= 0) {
                        this.reportError(0);
                    }
                    n6 = n11;
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    if ((n9 & 0xE0) == 192) {
                        n9 &= 0x1F;
                        n4 = 1;
                    } else if ((n9 & 0xF0) == 224) {
                        n9 &= 0xF;
                        n4 = 2;
                    } else if ((n9 & 0xF8) == 240) {
                        n9 &= 7;
                        n4 = 3;
                    } else {
                        this.reportError(n9);
                        n9 = 1;
                        n4 = 1;
                    }
                    if (n10 + n4 > n8) {
                        this.reportError(n11);
                    }
                    int n12 = nArray[n10 >> 2];
                    n5 = n10 & 3;
                    ++n10;
                    if (((n12 >>= 3 - n5 << 3) & 0xC0) != 128) {
                        this.reportError(n12);
                    }
                    n9 = n9 << 6 | n12 & 0x3F;
                    if (n4 > 1) {
                        n12 = nArray[n10 >> 2];
                        n5 = n10 & 3;
                        ++n10;
                        if (((n12 >>= 3 - n5 << 3) & 0xC0) != 128) {
                            this.reportError(n12);
                        }
                        n9 = n9 << 6 | n12 & 0x3F;
                        if (n4 > 2) {
                            n12 = nArray[n10 >> 2];
                            n5 = n10 & 3;
                            ++n10;
                            if (((n12 >>= 3 - n5 << 3) & 0xC0) != 128) {
                                this.reportError(n12 & 0xFF);
                            }
                            n9 = n9 << 6 | n12 & 0x3F;
                        }
                    }
                    bl = XmlChars.is10NameChar(n9);
                    if (n4 <= 2) break;
                    n9 -= 65536;
                    if (n11 >= cArray.length) {
                        this.mNameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
                    }
                    cArray[n11++] = (char)(55296 + (n9 >> 10));
                    n9 = 0xDC00 | n9 & 0x3FF;
                }
            }
            if (!bl) {
                this.reportError(n11);
            }
            if (n11 >= cArray.length) {
                this.mNameBuffer = cArray = DataUtil.growArrayBy(cArray, cArray.length);
            }
            cArray[n11++] = (char)n9;
        }
        String string = new String(cArray, 0, n11);
        if (n3 < 4) {
            nArray[n2 - 1] = n7;
        }
        return this.mSymbols.addSymbol(n, string, n6, nArray, n2);
    }

    private void loadMoreGuaranteed() {
        throw new IllegalStateException();
    }

    private int loadOne() {
        throw new IllegalStateException();
    }

    private void reportError(int n) {
        throw new IllegalStateException();
    }

    private void reportError(String string) {
        throw new IllegalStateException(string);
    }

    private static byte[] readData(File file) throws IOException {
        int n;
        int n2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        FileInputStream fileInputStream = new FileInputStream(file);
        for (n2 = (int)file.length(); n2 > 0; n2 -= n) {
            n = fileInputStream.read(byArray, n3, n2 - n3);
            n3 += n;
        }
        fileInputStream.close();
        return byArray;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java ... [input file]");
            System.exit(1);
        }
        byte[] byArray = TestPNamePerf.readData(new File(stringArray[0]));
        int n = byArray.length;
        int n2 = 1;
        int n3 = 10000000;
        if (n < n3) {
            n2 = n3 / n;
        }
        System.out.println("Ok, read in test data, " + n + " bytes; using " + n2 + " repetitions");
        new TestPNamePerf(byArray, n2).test();
    }
}

