/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.fasterxml.aalto.sax.SAXParserFactoryImpl;
import com.fasterxml.aalto.sax.SAXProperty;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;

public class TestSaxReader {
    protected TestSaxReader() {
    }

    protected void test(File file) throws Exception {
        SAXParserFactoryImpl sAXParserFactoryImpl = new SAXParserFactoryImpl();
        SAXParser sAXParser = sAXParserFactoryImpl.newSAXParser();
        MyContentHandler myContentHandler = new MyContentHandler();
        sAXParser.setProperty(SAXProperty.LEXICAL_HANDLER.toExternal(), myContentHandler);
        FileInputStream fileInputStream = new FileInputStream(file);
        sAXParser.parse(new InputSource(fileInputStream), (DefaultHandler)myContentHandler);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java ... " + TestSaxReader.class + " [file]");
            System.exit(1);
        }
        try {
            new TestSaxReader().test(new File(stringArray[0]));
            System.out.println("\nDone!");
        }
        catch (Throwable throwable) {
            System.err.println("Error: " + throwable);
            throwable.printStackTrace();
        }
    }

    static final class MyContentHandler
    extends DefaultHandler2
    implements DeclHandler {
        @Override
        public void characters(char[] cArray, int n, int n2) {
            System.out.print("[CHARACTERS] (len " + n2 + "): '");
            this.printString(cArray, n, n2);
            System.out.println("'");
        }

        @Override
        public void endDocument() {
            System.out.println("[END-DOCUMENT]");
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            System.out.print("[END-ELEMENT] </");
            System.out.print(string3);
            if (string != null) {
                System.out.print(" {");
                System.out.print(string);
                System.out.print(" }");
            }
            System.out.println(">");
        }

        @Override
        public void endPrefixMapping(String string) {
            System.out.println("[UNMAP-PREFIX '" + string + "']");
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) {
            System.out.println("[IGN-WS] (len " + n2 + ")");
        }

        @Override
        public void processingInstruction(String string, String string2) {
            System.out.println("[PROC-INSTR '" + string + "' ...]");
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String string) {
            System.out.println("[SKIPPED-entity '" + string + "']");
        }

        @Override
        public void startDocument() {
            System.out.println("[START-DOC]");
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            System.out.print("[START-ELEMENT] (");
            System.out.print(attributes.getLength());
            System.out.print(" attrs) <");
            System.out.print(string3);
            if (string != null) {
                System.out.print(" {");
                System.out.print(string);
                System.out.print(" }");
            }
            System.out.println(">");
        }

        @Override
        public void startPrefixMapping(String string, String string2) {
            System.out.println("[MAP-PREFIX '" + string + "'->'" + string2 + "']");
        }

        @Override
        public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
            System.out.println("[UNPARSED-ENTITY-DECL '" + string + "']");
        }

        @Override
        public void warning(SAXParseException sAXParseException) {
            System.out.println("[WARNING: '" + sAXParseException.getMessage() + "']");
        }

        @Override
        public void comment(char[] cArray, int n, int n2) {
            System.out.print("[COMMENT] '");
            this.printString(cArray, n, n2);
            System.out.println("'");
        }

        @Override
        public void endCDATA() {
            System.out.println("[END-CDATA]");
        }

        @Override
        public void endDTD() {
            System.out.println("[END-DTD]");
        }

        @Override
        public void endEntity(String string) {
            System.out.println("[END-ENTITY '" + string + "']");
        }

        @Override
        public void startCDATA() {
            System.out.println("[START-CDATA]");
        }

        @Override
        public void startDTD(String string, String string2, String string3) {
            System.out.print("[START-DTD ");
            System.out.print(string);
            System.out.println("]");
        }

        @Override
        public void startEntity(String string) {
            System.out.println("[START-ENTITY '" + string + "']");
        }

        private void printString(char[] cArray, int n, int n2) {
            if (n2 < 60) {
                System.out.print(new String(cArray, n, n2));
            } else {
                StringBuffer stringBuffer = new StringBuffer(64);
                stringBuffer.append(cArray, n, 28);
                stringBuffer.append("]..[");
                stringBuffer.append(cArray, n + n2 - 28, 28);
            }
        }
    }
}

