/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.maven.watcher;

import com.fizzed.maven.watcher.WatchFileSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.maven.Maven;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.prefix.PluginPrefixResolver;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.util.DirectoryScanner;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class RunMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(property="watches", alias="watcher.watches", required=true)
    protected List<WatchFileSet> watches;
    @Parameter(property="goals", alias="watcher.goals", required=true)
    protected List<String> goals;
    @Parameter(property="profiles", alias="watcher.profiles", required=false)
    protected List<String> profiles;
    @Parameter(property="watcher.skipTouch", defaultValue="false")
    protected boolean skipTouch;
    @Parameter(property="watcher.touchFile", defaultValue="${project.build.directory}/watcher.txt")
    protected File touchFile;
    @Component
    protected PluginPrefixResolver pluginPrefixResolver;
    @Component
    protected PluginVersionResolver pluginVersionResolver;
    @Component
    protected Maven maven;
    private WatchService watchService;
    private Map<Path, WatchFileSet> configMap;
    private Map<Path, WatchKey> pathMap;
    private Map<WatchKey, Path> watchKeyMap;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.configMap = new HashMap<Path, WatchFileSet>();
        this.pathMap = new HashMap<Path, WatchKey>();
        this.watchKeyMap = new HashMap<WatchKey, Path>();
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to create watch service");
        }
        this.getLog().info((CharSequence)("Registering " + this.watches.size() + " watch sets..."));
        for (WatchFileSet wfs : this.watches) {
            this.getLog().info((CharSequence)("Registering watch set: " + (Object)((Object)wfs)));
            File dir = new File(wfs.getDirectory());
            if (!dir.exists()) {
                throw new MojoFailureException("Directory " + dir + " does not exist. Unable to watch a dir that does not exist");
            }
            if (!dir.isDirectory()) {
                throw new MojoFailureException("Unable to watch " + dir + " - its not a directory");
            }
            this.configMap.put(dir.toPath(), wfs);
            if (wfs.isRecursive()) {
                this.walkTreeAndSetWatches(dir, null);
                continue;
            }
            this.registerWatch(dir.toPath());
        }
        long longTimeout = 86400000L;
        long shortTimeout = 750L;
        long timeout = longTimeout;
        int dueToRunGoal = 0;
        try {
            while (true) {
                WatchKey watchKey;
                if (timeout > shortTimeout) {
                    this.getLog().info((CharSequence)"Watcher - waiting for changes...");
                }
                if ((watchKey = this.watchService.poll(timeout, TimeUnit.MILLISECONDS)) == null) {
                    if (dueToRunGoal > 0) {
                        MavenExecutionRequest request = DefaultMavenExecutionRequest.copy((MavenExecutionRequest)this.session.getRequest());
                        if (this.profiles != null && this.profiles.size() > 0) {
                            request.setActiveProfiles(this.profiles);
                        }
                        request.setGoals(this.goals);
                        this.getLog().info((CharSequence)"Changed detected. Running command-line equivalent of:");
                        this.getLog().info((CharSequence)(" " + this.buildMavenCommandLineEquivalent()));
                        MavenExecutionResult executionResult = this.maven.execute(request);
                        if (executionResult.hasExceptions()) {
                            this.getLog().error((CharSequence)"Goal(s) had exceptions, skipping touch file");
                        } else {
                            this.touchFileIfRequested();
                        }
                    }
                    timeout = longTimeout;
                    dueToRunGoal = 0;
                    continue;
                }
                timeout = shortTimeout;
                ++dueToRunGoal;
                Path watchPath = this.watchKeyMap.get(watchKey);
                List<WatchEvent<?>> pollEvents = watchKey.pollEvents();
                for (WatchEvent<?> event : pollEvents) {
                    if (!(event.context() instanceof Path)) continue;
                    Path eventPath = (Path)event.context();
                    Path path = watchPath.resolve(eventPath);
                    File file = path.toFile();
                    String fileOrDir = file.isDirectory() ? "directory" : "file";
                    WatchFileSet wfs = this.findWatchFileSet(path);
                    this.getLog().debug((CharSequence)("eventPath: " + eventPath));
                    this.getLog().debug((CharSequence)("watchFileSet: " + (Object)((Object)wfs)));
                    boolean matches = this.matches(eventPath.toString(), wfs);
                    this.getLog().debug((CharSequence)("Watcher - matches=" + matches));
                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.getLog().info((CharSequence)("Watcher - " + fileOrDir + " created: " + path));
                        if (file.isDirectory()) {
                            if (wfs.isRecursive()) {
                                this.walkTreeAndSetWatches(file, new File(wfs.getDirectory()));
                            }
                            matches = false;
                        }
                    } else if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.getLog().info((CharSequence)("Watcher - " + fileOrDir + " deleted: " + path));
                        int count = this.unregisterStaleWatches();
                        if (count > 0 && count == event.count()) {
                            matches = false;
                        }
                    } else if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                        this.getLog().info((CharSequence)("Watcher - " + fileOrDir + " modified: " + path));
                        if (file.isDirectory()) {
                            matches = false;
                        }
                    } else if (event.kind() == StandardWatchEventKinds.OVERFLOW) {
                        this.getLog().warn((CharSequence)"Watcher - some events may have been discarded!!!!");
                        this.getLog().warn((CharSequence)"Ideally, just restart maven to pick it up again");
                    }
                    if (matches) continue;
                    this.getLog().info((CharSequence)"Change either a dir or did not match includes/excludes (not triggering goals...)");
                    --dueToRunGoal;
                }
                watchKey.reset();
            }
        }
        catch (InterruptedException | ClosedWatchServiceException e) {
            return;
        }
    }

    public void touchFileIfRequested() {
        if (!this.skipTouch && this.touchFile != null) {
            this.getLog().info((CharSequence)("Touching file " + this.touchFile));
            try {
                if (!this.touchFile.exists()) {
                    File parent = this.touchFile.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    new FileOutputStream(this.touchFile).close();
                }
                this.touchFile.setLastModified(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.getLog().debug((CharSequence)"Unable to touch file", (Throwable)e);
            }
        }
    }

    public String buildMavenCommandLineEquivalent() {
        StringBuilder sb = new StringBuilder();
        sb.append("mvn");
        if (this.profiles != null && this.profiles.size() > 0) {
            for (String p : this.profiles) {
                sb.append(" -P").append(p);
            }
        }
        if (this.goals != null && this.goals.size() > 0) {
            for (String g : this.goals) {
                sb.append(" ").append(g);
            }
        }
        return sb.toString();
    }

    public void addWatch(WatchFileSet wfs) {
        if (this.watches == null) {
            this.watches = new ArrayList<WatchFileSet>();
        }
        this.watches.add(wfs);
    }

    private WatchFileSet findWatchFileSet(Path path) {
        for (Path p = path; p != null; p = p.getParent()) {
            if (!this.configMap.containsKey(p)) continue;
            return this.configMap.get(p);
        }
        return null;
    }

    private boolean matches(String name, WatchFileSet wfs) {
        boolean matches = false;
        if ((wfs.getIncludes() == null || wfs.getIncludes().isEmpty()) && (wfs.getExcludes() == null || wfs.getExcludes().isEmpty())) {
            matches = true;
        }
        if (wfs.getIncludes() != null && !wfs.getIncludes().isEmpty()) {
            for (String include : wfs.getIncludes()) {
                this.getLog().debug((CharSequence)("Trying to match: include=" + include + " for name " + name));
                if (!DirectoryScanner.match((String)include, (String)name)) continue;
                matches = true;
                break;
            }
        } else {
            matches = true;
        }
        if (wfs.getExcludes() != null) {
            for (String exclude : wfs.getExcludes()) {
                this.getLog().debug((CharSequence)("Trying to match: exclude=" + exclude + " for name " + name));
                if (!DirectoryScanner.match((String)exclude, (String)name)) continue;
                matches = false;
                break;
            }
        }
        return matches;
    }

    private void walkTreeAndSetWatches(File dir, File root) {
        try {
            Path parent;
            if (root != null && !this.pathMap.containsKey(parent = dir.toPath().getParent())) {
                this.walkTreeAndSetWatches(root, null);
                return;
            }
            Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    RunMojo.this.registerWatch(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private int unregisterStaleWatches() {
        HashSet<Path> paths = new HashSet<Path>(this.pathMap.keySet());
        HashSet<Path> stalePaths = new HashSet<Path>();
        for (Path path : paths) {
            if (Files.exists(path, LinkOption.NOFOLLOW_LINKS)) continue;
            stalePaths.add(path);
        }
        if (stalePaths.size() > 0) {
            for (Path stalePath : stalePaths) {
                this.unregisterWatch(stalePath);
            }
        }
        return stalePaths.size();
    }

    private void registerWatch(Path dir) {
        if (!this.pathMap.containsKey(dir)) {
            this.getLog().info((CharSequence)("Watcher - registering watch on dir: " + dir));
            try {
                WatchKey watchKey = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.OVERFLOW);
                this.pathMap.put(dir, watchKey);
                this.watchKeyMap.put(watchKey, dir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void unregisterWatch(Path dir) {
        WatchKey watchKey = this.pathMap.get(dir);
        if (watchKey != null) {
            this.getLog().info((CharSequence)("Watcher - unregistering watch on dir: " + dir));
            watchKey.cancel();
            this.pathMap.remove(dir);
            this.watchKeyMap.remove(watchKey);
        }
    }
}

