/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.template;

import com.sforce.ws.template.Expression;
import com.sforce.ws.template.JspNode;
import com.sforce.ws.template.JspTokenizer;
import com.sforce.ws.template.Scriptlet;
import com.sforce.ws.template.TemplateException;
import com.sforce.ws.template.Text;
import com.sforce.ws.template.Token;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class JspParser {
    private ArrayList<JspNode> nodes = new ArrayList();

    public JspParser(InputStream in) throws IOException, TemplateException {
        BufferedInputStream bio = new BufferedInputStream(in);
        JspTokenizer tokenizer = new JspTokenizer(bio);
        boolean done = false;
        block11: while (!done) {
            Token token = tokenizer.nextToken();
            switch (token) {
                case TEXT: {
                    Text text = new Text(tokenizer);
                    this.nodes.add(text);
                    continue block11;
                }
                case START_SCRIPTLET: {
                    Scriptlet scriptlet = new Scriptlet(tokenizer);
                    this.nodes.add(scriptlet);
                    continue block11;
                }
                case START_EXPRESSION: {
                    Expression expression = new Expression(tokenizer);
                    this.nodes.add(expression);
                    continue block11;
                }
                case EOF: {
                    done = true;
                    continue block11;
                }
                case END_COMMENT: {
                    continue block11;
                }
                case START_COMMENT: {
                    continue block11;
                }
                case START_DECLARATION: {
                    continue block11;
                }
                case START_DIRECTIVES: {
                    continue block11;
                }
                case END_TAG: {
                    throw new TemplateException("Found unexpected token:" + (Object)((Object)token));
                }
            }
            throw new InternalError("unknown token: " + (Object)((Object)token));
        }
    }

    public String toJavaScript() {
        StringBuilder sb = new StringBuilder();
        for (JspNode node : this.nodes) {
            node.toJavaScript(sb);
        }
        return sb.toString();
    }
}

