/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.persistence.model;

import com.github.adminfaces.persistence.model.AdminMultiSort;
import com.github.adminfaces.persistence.model.AdminSort;
import com.github.adminfaces.persistence.model.PersistenceEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Filter<T extends PersistenceEntity>
implements Serializable {
    private T entity;
    private int first;
    private int pageSize;
    private String sortField;
    private AdminSort adminSort;
    private List<AdminMultiSort> multiSort = new ArrayList<AdminMultiSort>();
    private Map<String, Object> params = new HashMap<String, Object>();

    public Filter() {
    }

    public Filter(T entity) {
        this.entity = entity;
    }

    public Filter setFirst(int first) {
        this.first = first;
        return this;
    }

    public int getFirst() {
        return this.first;
    }

    public Filter setPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Filter setSortField(String sortField) {
        this.sortField = sortField;
        return this;
    }

    public String getSortField() {
        return this.sortField;
    }

    public Filter setAdminSort(AdminSort adminSort) {
        this.adminSort = adminSort;
        return this;
    }

    public AdminSort getAdminSort() {
        return this.adminSort;
    }

    public Filter setParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public List<AdminMultiSort> getMultiSort() {
        return this.multiSort;
    }

    public Filter setMultiSort(List<AdminMultiSort> multiSort) {
        this.multiSort = multiSort;
        return this;
    }

    public Filter addMultSort(AdminSort adminSort, String sortField) {
        if (!this.multiSort.contains((Object)adminSort)) {
            this.multiSort.add(new AdminMultiSort(adminSort, sortField));
        }
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public T getEntity() {
        return this.entity;
    }

    public Filter setEntity(T entity) {
        this.entity = entity;
        return this;
    }

    public Filter addParam(String key, Object value) {
        this.getParams().put(key, value);
        return this;
    }

    public boolean hasParam(String key) {
        return this.getParams().containsKey(key) && this.getParam(key) != null;
    }

    public Object getParam(String key) {
        return this.getParams().get(key);
    }

    public <X> X getParam(String key, Class<X> type) {
        return (X)(this.hasParam(key) ? this.getParams().get(key) : null);
    }

    public String getStringParam(String key) {
        return this.hasParam(key) ? this.getParam(key).toString() : null;
    }

    public Integer getIntParam(String key) {
        return this.hasParam(key) ? Integer.valueOf(Integer.parseInt(this.getStringParam(key))) : null;
    }

    public Long getLongParam(String key) {
        return this.hasParam(key) ? Long.valueOf(Long.parseLong(this.getStringParam(key))) : null;
    }

    public Boolean getBooleanParam(String key) {
        return this.hasParam(key) ? Boolean.valueOf(Boolean.parseBoolean(this.getStringParam(key))) : null;
    }

    public Double getDoubleParam(String key) {
        return this.hasParam(key) ? Double.valueOf(Double.parseDouble(this.getStringParam(key))) : null;
    }
}

