/*
 * Decompiled with CFR 0.152.
 */
package com.github.adminfaces.persistence.util;

import com.github.adminfaces.persistence.model.AdminMultiSort;
import com.github.adminfaces.persistence.model.AdminSort;
import com.github.adminfaces.persistence.model.Filter;
import com.github.adminfaces.persistence.model.PersistenceEntity;
import com.github.adminfaces.persistence.service.CrudService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;

public class AdminDataModel<T extends PersistenceEntity>
extends LazyDataModel<T> {
    private CrudService<T, ?> crudService;
    private Filter<T> filter;
    private boolean keepFiltersInSession;

    public AdminDataModel(CrudService<T, ?> crudService, Filter<T> filter) {
        this(crudService, filter, true);
    }

    public AdminDataModel(CrudService<T, ?> crudService, Filter<T> filter, boolean keepFiltersInSession) {
        this.crudService = crudService;
        this.filter = filter;
        this.keepFiltersInSession = keepFiltersInSession;
    }

    public List<T> load(int first, int pageSize, String sortField, SortOrder sortOrder, Map<String, Object> filters) {
        ArrayList<SortMeta> multiSortMeta = new ArrayList<SortMeta>();
        multiSortMeta.add(new SortMeta(null, sortField, sortOrder, null));
        return this.load(first, pageSize, multiSortMeta, filters);
    }

    public List<T> load(int first, int pageSize, List<SortMeta> multiSortMeta, Map<String, Object> filters) {
        ArrayList<AdminMultiSort> adminMultiSort = new ArrayList<AdminMultiSort>();
        if (multiSortMeta != null && !multiSortMeta.isEmpty()) {
            for (SortMeta sortMeta : multiSortMeta) {
                AdminSort adminSort = AdminSort.UNSORTED;
                if (SortOrder.ASCENDING.equals((Object)sortMeta.getSortOrder())) {
                    adminSort = AdminSort.ASCENDING;
                } else if (SortOrder.DESCENDING.equals((Object)sortMeta.getSortOrder())) {
                    adminSort = AdminSort.DESCENDING;
                }
                adminMultiSort.add(new AdminMultiSort(adminSort, sortMeta.getSortField()));
            }
        }
        if ((filters == null || filters.isEmpty()) && this.keepFiltersInSession) {
            filters = this.filter.getParams();
        }
        this.filter.setFirst(first).setPageSize(pageSize).setMultiSort(adminMultiSort).setParams(filters);
        List<T> list = this.crudService.paginate(this.filter);
        this.setRowCount(this.crudService.count(this.filter).intValue());
        return list;
    }

    public int getRowCount() {
        return super.getRowCount();
    }

    public T getRowData(String key) {
        List list = this.getWrappedData();
        if (list != null && !list.isEmpty()) {
            for (PersistenceEntity t : list) {
                if (!key.equals(t.getId().toString())) continue;
                return (T)t;
            }
        }
        return null;
    }

    public void setFilter(Filter<T> filter) {
        this.filter = filter;
    }
}

