/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractArtifact {
    @Parameter(required=true)
    protected String groupId;
    @Parameter(required=true)
    protected String artifactId;
    @Parameter
    protected String version;
    @Parameter
    protected String type;
    @Parameter
    protected String classifier;
    @Parameter
    protected String systemPath;
    protected File file;

    public AbstractArtifact() {
    }

    public AbstractArtifact(String groupId, String artifactId, String version, String classifier, String type) {
        this.setGroupId(groupId);
        this.setArtifactId(artifactId);
        this.setVersion(version);
        this.setClassifier(classifier);
        this.setType(type);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public abstract String getType();

    public void setType(String type) {
        this.type = type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getSystemPath() {
        return this.systemPath;
    }

    public void setSystemPath(String systemPath) {
        this.systemPath = systemPath;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getArtifactCoordinates() {
        if (!StringUtils.isBlank((CharSequence)this.getSystemPath())) {
            return this.getSystemPath();
        }
        return this.buildDefaultMavenCoordinates();
    }

    protected String buildDefaultMavenCoordinates() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getGroupId()).append(":");
        sb.append(this.getArtifactId());
        if (StringUtils.isNotBlank((CharSequence)this.getType())) {
            sb.append(":").append(this.getType());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getClassifier())) {
            sb.append(":").append(this.getClassifier());
        }
        sb.append(":");
        sb.append(this.getVersion());
        return sb.toString().trim();
    }

    public String toString() {
        return "Artifact[" + this.getArtifactCoordinates() + "]";
    }
}

