/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ChainedArtifactResolver;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.ElasticsearchBaseConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.configuration.PluginArtifactResolver;
import java.io.File;
import org.apache.maven.monitor.logging.DefaultLog;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public abstract class AbstractElasticsearchBaseMojo
extends AbstractMojo
implements ElasticsearchBaseConfiguration {
    @Parameter(property="es.instanceCount", defaultValue="1")
    protected int instanceCount;
    @Parameter(defaultValue="${project.build.directory}/elasticsearch", readonly=true)
    protected File baseDir;
    @Parameter(property="es.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="es.logLevel", defaultValue="INFO")
    protected String logLevel;
    private Log log;

    @Override
    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
    }

    @Override
    public File getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    private int getMavenLogLevel() {
        switch (this.logLevel) {
            case "DEBUG": {
                return 0;
            }
            case "WARN": {
                return 2;
            }
            case "ERROR": {
                return 3;
            }
            case "FATAL": {
                return 4;
            }
            case "DISABLED": {
                return 5;
            }
        }
        return 1;
    }

    @Override
    public Log getLog() {
        if (this.log == null) {
            this.log = new DefaultLog((Logger)new ConsoleLogger(this.getMavenLogLevel(), "console"));
        }
        return this.log;
    }

    @Override
    public ClusterConfiguration buildClusterConfiguration() {
        ClusterConfiguration.Builder clusterConfigBuilder = new ClusterConfiguration.Builder().withArtifactResolver(this.buildArtifactResolver()).withLog(this.getLog());
        for (int i = 0; i < this.instanceCount; ++i) {
            clusterConfigBuilder.addInstanceConfiguration(new InstanceConfiguration.Builder().withId(i).withBaseDir(this.baseDir.getAbsolutePath() + i).build());
        }
        ClusterConfiguration clusterConfig = clusterConfigBuilder.build();
        return clusterConfig;
    }

    @Override
    public PluginArtifactResolver buildArtifactResolver() {
        ChainedArtifactResolver artifactResolver = new ChainedArtifactResolver();
        return artifactResolver;
    }
}

