/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexcojocaru.mojo.elasticsearch.v2;

import com.github.alexcojocaru.mojo.elasticsearch.v2.AbstractElasticsearchMojo;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ClusterConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.ForkedInstance;
import com.github.alexcojocaru.mojo.elasticsearch.v2.InstanceConfiguration;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.PostStartClusterSequence;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.PostStartInstanceSequence;
import com.github.alexcojocaru.mojo.elasticsearch.v2.step.PreStartClusterSequence;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="runforked", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class RunForkedMojo
extends AbstractElasticsearchMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping plugin execution");
            return;
        }
        ClusterConfiguration clusterConfig = this.buildClusterConfiguration();
        new PreStartClusterSequence().execute(clusterConfig);
        for (InstanceConfiguration config : clusterConfig.getInstanceConfigurationList()) {
            this.getLog().info((CharSequence)String.format("Using Elasticsearch [%d] configuration: %s", config.getId(), config));
            try {
                ForkedInstance instance = new ForkedInstance(config);
                instance.configureInstance();
                Thread thread = new Thread(instance);
                thread.start();
                new PostStartInstanceSequence().execute(config);
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        new PostStartClusterSequence().execute(clusterConfig);
    }
}

